/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.helpers;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.IsolationLevels;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSail
implements Sail {
    protected static final long DEFAULT_CONNECTION_TIMEOUT = 20000L;
    private IsolationLevel defaultIsolationLevel = IsolationLevels.READ_COMMITTED;
    private List<IsolationLevel> supportedIsolationLevels = new ArrayList<IsolationLevel>();
    protected static final long DEFAULT_ITERATION_SYNC_THRESHOLD = 0L;
    static final String DEBUG_PROP = "org.eclipse.rdf4j.repository.debug";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile File dataDir;
    private volatile boolean initialized = false;
    protected final ReentrantReadWriteLock initializationLock = new ReentrantReadWriteLock();
    protected volatile long connectionTimeOut = 20000L;
    private long iterationCacheSyncThreshold = 0L;
    private final Map<SailConnection, Throwable> activeConnections = new IdentityHashMap<SailConnection, Throwable>();

    protected static boolean debugEnabled() {
        try {
            String value = System.getProperty(DEBUG_PROP);
            return value != null && !value.equals("false");
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public AbstractSail() {
        this.addSupportedIsolationLevel(IsolationLevels.READ_UNCOMMITTED);
        this.addSupportedIsolationLevel(IsolationLevels.SERIALIZABLE);
    }

    public void setConnectionTimeOut(long connectionTimeOut) {
        this.connectionTimeOut = connectionTimeOut;
    }

    @Override
    public void setDataDir(File dataDir) {
        if (this.isInitialized()) {
            throw new IllegalStateException("sail has already been initialized");
        }
        this.dataDir = dataDir;
    }

    @Override
    public File getDataDir() {
        return this.dataDir;
    }

    public String toString() {
        if (this.dataDir == null) {
            return super.toString();
        }
        return this.dataDir.toString();
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void initialize() throws SailException {
        this.initializationLock.writeLock().lock();
        try {
            this.logger.trace("is initialized: {}", (Object)this.isInitialized());
            if (this.isInitialized()) {
                throw new IllegalStateException("Sail has already been intialized. Ensure this Sail is being used via a Repository.");
            }
            this.initializeInternal();
            this.initialized = true;
        }
        finally {
            this.initializationLock.writeLock().unlock();
        }
    }

    protected void initializeInternal() throws SailException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutDown() throws SailException {
        this.initializationLock.writeLock().lock();
        try {
            IdentityHashMap<SailConnection, Throwable> activeConnectionsCopy;
            if (!this.isInitialized()) {
                return;
            }
            Map<SailConnection, Throwable> map = this.activeConnections;
            synchronized (map) {
                if (!this.activeConnections.isEmpty()) {
                    this.logger.debug("Waiting for active connections to close before shutting down...");
                    try {
                        this.activeConnections.wait(this.connectionTimeOut);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                activeConnectionsCopy = new IdentityHashMap<SailConnection, Throwable>(this.activeConnections);
            }
            for (Map.Entry entry : activeConnectionsCopy.entrySet()) {
                SailConnection con = (SailConnection)entry.getKey();
                Throwable stackTrace = (Throwable)entry.getValue();
                if (stackTrace == null) {
                    this.logger.warn("Closing active connection due to shut down; consider setting the {} system property", (Object)DEBUG_PROP);
                } else {
                    this.logger.warn("Closing active connection due to shut down, connection was acquired in", stackTrace);
                }
                try {
                    con.close();
                }
                catch (SailException e) {
                    this.logger.error("Failed to close connection", (Throwable)((Object)e));
                }
            }
            map = this.activeConnections;
            synchronized (map) {
                this.activeConnections.clear();
            }
            this.shutDownInternal();
        }
        finally {
            this.initialized = false;
            this.initializationLock.writeLock().unlock();
        }
    }

    protected abstract void shutDownInternal() throws SailException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SailConnection getConnection() throws SailException {
        this.initializationLock.readLock().lock();
        try {
            if (!this.isInitialized()) {
                throw new IllegalStateException("Sail is not initialized or has been shut down");
            }
            SailConnection connection = this.getConnectionInternal();
            Throwable stackTrace = AbstractSail.debugEnabled() ? new Throwable() : null;
            Object object = this.activeConnections;
            synchronized (object) {
                this.activeConnections.put(connection, stackTrace);
            }
            object = connection;
            return object;
        }
        finally {
            this.initializationLock.readLock().unlock();
        }
    }

    protected abstract SailConnection getConnectionInternal() throws SailException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectionClosed(SailConnection connection) {
        Map<SailConnection, Throwable> map = this.activeConnections;
        synchronized (map) {
            if (this.activeConnections.containsKey(connection)) {
                this.activeConnections.remove(connection);
                if (this.activeConnections.isEmpty()) {
                    this.activeConnections.notifyAll();
                }
            } else {
                this.logger.warn("tried to remove unknown connection object from store.");
            }
        }
    }

    protected void addSupportedIsolationLevel(IsolationLevels level) {
        this.supportedIsolationLevels.add((IsolationLevel)level);
    }

    protected void removeSupportedIsolationLevel(IsolationLevel level) {
        while (this.supportedIsolationLevels.remove(level)) {
        }
    }

    protected void setSupportedIsolationLevels(List<IsolationLevel> supportedIsolationLevels) {
        this.supportedIsolationLevels = supportedIsolationLevels;
    }

    protected void setSupportedIsolationLevels(IsolationLevel ... supportedIsolationLevels) {
        this.supportedIsolationLevels = Arrays.asList(supportedIsolationLevels);
    }

    @Override
    public List<IsolationLevel> getSupportedIsolationLevels() {
        return Collections.unmodifiableList(this.supportedIsolationLevels);
    }

    @Override
    public IsolationLevel getDefaultIsolationLevel() {
        return this.defaultIsolationLevel;
    }

    public void setDefaultIsolationLevel(IsolationLevel defaultIsolationLevel) {
        if (defaultIsolationLevel == null) {
            throw new IllegalArgumentException("default isolation level may not be null");
        }
        this.defaultIsolationLevel = defaultIsolationLevel;
    }

    public long getIterationCacheSyncThreshold() {
        return this.iterationCacheSyncThreshold;
    }

    public void setIterationCacheSyncThreshold(long iterationCacheSyncThreshold) {
        this.iterationCacheSyncThreshold = iterationCacheSyncThreshold;
    }
}

