/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sail;

import org.apache.http.client.HttpClient;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.OpenRDFUtil;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.http.client.HttpClientDependent;
import org.eclipse.rdf4j.http.client.HttpClientSessionManager;
import org.eclipse.rdf4j.http.client.SessionManagerDependent;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolverClient;
import org.eclipse.rdf4j.query.parser.ParsedBooleanQuery;
import org.eclipse.rdf4j.query.parser.ParsedGraphQuery;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.query.parser.ParsedUpdate;
import org.eclipse.rdf4j.query.parser.QueryParserUtil;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryReadOnlyException;
import org.eclipse.rdf4j.repository.RepositoryResolver;
import org.eclipse.rdf4j.repository.RepositoryResolverClient;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.UnknownTransactionStateException;
import org.eclipse.rdf4j.repository.base.AbstractRepositoryConnection;
import org.eclipse.rdf4j.repository.sail.SailBooleanQuery;
import org.eclipse.rdf4j.repository.sail.SailCloseableIteration;
import org.eclipse.rdf4j.repository.sail.SailGraphQuery;
import org.eclipse.rdf4j.repository.sail.SailQuery;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.sail.SailTupleQuery;
import org.eclipse.rdf4j.repository.sail.SailUpdate;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.SailReadOnlyException;

public class SailRepositoryConnection
extends AbstractRepositoryConnection
implements FederatedServiceResolverClient,
RepositoryResolverClient,
HttpClientDependent,
SessionManagerDependent {
    private final SailConnection sailConnection;

    protected SailRepositoryConnection(SailRepository repository, SailConnection sailConnection) {
        super((Repository)repository);
        this.sailConnection = sailConnection;
    }

    public SailConnection getSailConnection() {
        return this.sailConnection;
    }

    public void setFederatedServiceResolver(FederatedServiceResolver resolver) {
        if (this.sailConnection instanceof FederatedServiceResolverClient) {
            ((FederatedServiceResolverClient)this.sailConnection).setFederatedServiceResolver(resolver);
        }
    }

    public void setRepositoryResolver(RepositoryResolver resolver) {
        if (this.sailConnection instanceof RepositoryResolverClient) {
            ((RepositoryResolverClient)this.sailConnection).setRepositoryResolver(resolver);
        }
    }

    public HttpClientSessionManager getHttpClientSessionManager() {
        if (this.sailConnection instanceof SessionManagerDependent) {
            return ((SessionManagerDependent)this.sailConnection).getHttpClientSessionManager();
        }
        return null;
    }

    public void setHttpClientSessionManager(HttpClientSessionManager client) {
        if (this.sailConnection instanceof SessionManagerDependent) {
            ((SessionManagerDependent)this.sailConnection).setHttpClientSessionManager(client);
        }
    }

    public HttpClient getHttpClient() {
        if (this.sailConnection instanceof HttpClientDependent) {
            return ((HttpClientDependent)this.sailConnection).getHttpClient();
        }
        return null;
    }

    public void setHttpClient(HttpClient client) {
        if (this.sailConnection instanceof HttpClientDependent) {
            ((HttpClientDependent)this.sailConnection).setHttpClient(client);
        }
    }

    public void begin() throws RepositoryException {
        try {
            this.sailConnection.begin(this.getIsolationLevel());
        }
        catch (SailException e) {
            throw new RepositoryException((Throwable)((Object)e));
        }
    }

    public void begin(IsolationLevel level) throws RepositoryException {
        try {
            this.sailConnection.begin(level);
        }
        catch (SailException e) {
            throw new RepositoryException((Throwable)((Object)e));
        }
    }

    public void commit() throws RepositoryException {
        try {
            this.sailConnection.flush();
            this.sailConnection.prepare();
            this.sailConnection.commit();
        }
        catch (SailException e) {
            throw new RepositoryException((Throwable)((Object)e));
        }
    }

    public void rollback() throws RepositoryException {
        try {
            this.sailConnection.rollback();
        }
        catch (SailException e) {
            throw new RepositoryException((Throwable)((Object)e));
        }
    }

    public void close() throws RepositoryException {
        try {
            super.close();
        }
        catch (SailException e) {
            throw new RepositoryException((Throwable)((Object)e));
        }
        finally {
            this.sailConnection.close();
        }
    }

    public boolean isOpen() throws RepositoryException {
        try {
            return this.sailConnection.isOpen();
        }
        catch (SailException e) {
            throw new RepositoryException((Throwable)((Object)e));
        }
    }

    public SailQuery prepareQuery(QueryLanguage ql, String queryString, String baseURI) throws MalformedQueryException {
        ParsedQuery parsedQuery = QueryParserUtil.parseQuery((QueryLanguage)ql, (String)queryString, (String)baseURI);
        if (parsedQuery instanceof ParsedTupleQuery) {
            return new SailTupleQuery((ParsedTupleQuery)parsedQuery, this);
        }
        if (parsedQuery instanceof ParsedGraphQuery) {
            return new SailGraphQuery((ParsedGraphQuery)parsedQuery, this);
        }
        if (parsedQuery instanceof ParsedBooleanQuery) {
            return new SailBooleanQuery((ParsedBooleanQuery)parsedQuery, this);
        }
        throw new RuntimeException("Unexpected query type: " + parsedQuery.getClass());
    }

    public SailTupleQuery prepareTupleQuery(QueryLanguage ql, String queryString, String baseURI) throws MalformedQueryException {
        ParsedTupleQuery parsedQuery = QueryParserUtil.parseTupleQuery((QueryLanguage)ql, (String)queryString, (String)baseURI);
        return new SailTupleQuery(parsedQuery, this);
    }

    public SailGraphQuery prepareGraphQuery(QueryLanguage ql, String queryString, String baseURI) throws MalformedQueryException {
        ParsedGraphQuery parsedQuery = QueryParserUtil.parseGraphQuery((QueryLanguage)ql, (String)queryString, (String)baseURI);
        return new SailGraphQuery(parsedQuery, this);
    }

    public SailBooleanQuery prepareBooleanQuery(QueryLanguage ql, String queryString, String baseURI) throws MalformedQueryException {
        ParsedBooleanQuery parsedQuery = QueryParserUtil.parseBooleanQuery((QueryLanguage)ql, (String)queryString, (String)baseURI);
        return new SailBooleanQuery(parsedQuery, this);
    }

    public Update prepareUpdate(QueryLanguage ql, String update, String baseURI) throws RepositoryException, MalformedQueryException {
        ParsedUpdate parsedUpdate = QueryParserUtil.parseUpdate((QueryLanguage)ql, (String)update, (String)baseURI);
        return new SailUpdate(parsedUpdate, this);
    }

    public boolean hasStatement(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        return this.sailConnection.hasStatement(subj, pred, obj, includeInferred, contexts);
    }

    public RepositoryResult<Resource> getContextIDs() throws RepositoryException {
        try {
            return this.createRepositoryResult(this.sailConnection.getContextIDs());
        }
        catch (SailException e) {
            throw new RepositoryException("Unable to get context IDs from Sail", (Throwable)((Object)e));
        }
    }

    public RepositoryResult<Statement> getStatements(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        try {
            return this.createRepositoryResult(this.sailConnection.getStatements(subj, pred, obj, includeInferred, contexts));
        }
        catch (SailException e) {
            throw new RepositoryException("Unable to get statements from Sail", (Throwable)((Object)e));
        }
    }

    public boolean isEmpty() throws RepositoryException {
        return !this.hasStatement(null, null, null, false, new Resource[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportStatements(Resource subj, IRI pred, Value obj, boolean includeInferred, RDFHandler handler, Resource ... contexts) throws RepositoryException, RDFHandlerException {
        handler.startRDF();
        try (RepositoryResult<Namespace> nsIter = this.getNamespaces();){
            while (nsIter.hasNext()) {
                Namespace ns = (Namespace)nsIter.next();
                handler.handleNamespace(ns.getPrefix(), ns.getName());
            }
        }
        try (RepositoryResult<Statement> stIter = this.getStatements(subj, pred, obj, includeInferred, contexts);){
            while (stIter.hasNext()) {
                handler.handleStatement((Statement)stIter.next());
            }
        }
        handler.endRDF();
    }

    public long size(Resource ... contexts) throws RepositoryException {
        try {
            return this.sailConnection.size(contexts);
        }
        catch (SailException e) {
            throw new RepositoryException((Throwable)((Object)e));
        }
    }

    protected void addWithoutCommit(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        try {
            this.sailConnection.addStatement(subject, predicate, object, contexts);
        }
        catch (SailReadOnlyException e) {
            throw new RepositoryReadOnlyException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (SailException e) {
            throw new RepositoryException((Throwable)((Object)e));
        }
    }

    protected void removeWithoutCommit(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        try {
            if (subject == null && predicate == null && object == null) {
                this.sailConnection.clear(contexts);
            } else {
                this.sailConnection.removeStatements(subject, predicate, object, contexts);
            }
        }
        catch (SailReadOnlyException e) {
            throw new RepositoryReadOnlyException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (SailException e) {
            throw new RepositoryException((Throwable)((Object)e));
        }
    }

    public void clear(Resource ... contexts) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        try {
            boolean local = this.startLocalTransaction();
            this.sailConnection.clear(contexts);
            this.conditionalCommit(local);
        }
        catch (SailReadOnlyException e) {
            throw new RepositoryReadOnlyException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (SailException e) {
            throw new RepositoryException((Throwable)((Object)e));
        }
    }

    public void setNamespace(String prefix, String name) throws RepositoryException {
        try {
            boolean local = this.startLocalTransaction();
            this.sailConnection.setNamespace(prefix, name);
            this.conditionalCommit(local);
        }
        catch (SailReadOnlyException e) {
            throw new RepositoryReadOnlyException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (SailException e) {
            throw new RepositoryException((Throwable)((Object)e));
        }
    }

    public void removeNamespace(String prefix) throws RepositoryException {
        try {
            boolean local = this.startLocalTransaction();
            this.sailConnection.removeNamespace(prefix);
            this.conditionalCommit(local);
        }
        catch (SailReadOnlyException e) {
            throw new RepositoryReadOnlyException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (SailException e) {
            throw new RepositoryException((Throwable)((Object)e));
        }
    }

    public void clearNamespaces() throws RepositoryException {
        try {
            boolean local = this.startLocalTransaction();
            this.sailConnection.clearNamespaces();
            this.conditionalCommit(local);
        }
        catch (SailReadOnlyException e) {
            throw new RepositoryReadOnlyException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (SailException e) {
            throw new RepositoryException((Throwable)((Object)e));
        }
    }

    public RepositoryResult<Namespace> getNamespaces() throws RepositoryException {
        try {
            return this.createRepositoryResult(this.sailConnection.getNamespaces());
        }
        catch (SailException e) {
            throw new RepositoryException("Unable to get namespaces from Sail", (Throwable)((Object)e));
        }
    }

    public String getNamespace(String prefix) throws RepositoryException {
        try {
            return this.sailConnection.getNamespace(prefix);
        }
        catch (SailException e) {
            throw new RepositoryException((Throwable)((Object)e));
        }
    }

    protected <E> RepositoryResult<E> createRepositoryResult(CloseableIteration<? extends E, SailException> sailIter) {
        return new RepositoryResult(new SailCloseableIteration<E>(sailIter));
    }

    public boolean isActive() throws UnknownTransactionStateException {
        try {
            return this.sailConnection.isActive();
        }
        catch (SailException e) {
            throw new UnknownTransactionStateException((Throwable)((Object)e));
        }
    }

    public String toString() {
        return this.getSailConnection().toString();
    }
}

