/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.util;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.ConvertingIteration;
import org.eclipse.rdf4j.common.iteration.FilterIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Statements;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;

public class TripleSources {
    private static final ValueFactory vf = SimpleValueFactory.getInstance();

    TripleSources() {
    }

    public static Iteration<? extends Resource, QueryEvaluationException> listResources(Resource subj, TripleSource store) throws QueryEvaluationException {
        return new ConvertingIteration<Value, Resource, QueryEvaluationException>((Iteration)new FilterIteration<Value, QueryEvaluationException>(TripleSources.list(subj, store)){

            protected boolean accept(Value v) throws QueryEvaluationException {
                return v instanceof Resource;
            }
        }){

            protected Resource convert(Value v) throws QueryEvaluationException {
                return (Resource)v;
            }
        };
    }

    public static Iteration<? extends Value, QueryEvaluationException> list(final Resource subj, final TripleSource store) throws QueryEvaluationException {
        if (subj == null) {
            throw new NullPointerException("RDF list subject cannot be null");
        }
        return new Iteration<Value, QueryEvaluationException>(){
            Resource list;
            {
                this.list = subj;
            }

            public boolean hasNext() throws QueryEvaluationException {
                return !RDF.NIL.equals((Object)this.list);
            }

            public Value next() throws QueryEvaluationException {
                Value v = TripleSources.singleValue(this.list, RDF.FIRST, store);
                if (v == null) {
                    throw new QueryEvaluationException("List missing rdf:first: " + this.list);
                }
                Resource nextList = (Resource)TripleSources.singleValue(this.list, RDF.REST, store);
                if (nextList == null) {
                    throw new QueryEvaluationException("List missing rdf:rest: " + this.list);
                }
                this.list = nextList;
                return v;
            }

            public void remove() throws QueryEvaluationException {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static boolean booleanValue(Resource subj, IRI pred, TripleSource store) throws QueryEvaluationException {
        Value v = TripleSources.singleValue(subj, pred, store);
        if (v == null) {
            return false;
        }
        if (v instanceof Literal) {
            try {
                return ((Literal)v).booleanValue();
            }
            catch (IllegalArgumentException e) {
                throw new QueryEvaluationException("Value for " + pred + " must be of datatype " + XMLSchema.BOOLEAN + ": " + subj);
            }
        }
        throw new QueryEvaluationException("Non-literal value for " + pred + ": " + subj);
    }

    public static Value singleValue(Resource subj, IRI pred, TripleSource store) throws QueryEvaluationException {
        Statement stmt = TripleSources.single(subj, pred, null, store);
        return stmt != null ? stmt.getObject() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Statement single(Resource subj, IRI pred, Value obj, TripleSource store) throws QueryEvaluationException {
        Statement stmt;
        try (CloseableIteration<? extends Statement, QueryEvaluationException> stmts = store.getStatements(subj, pred, obj, new Resource[0]);){
            if (stmts.hasNext()) {
                stmt = (Statement)stmts.next();
                while (stmts.hasNext()) {
                    Statement nextStmt = (Statement)stmts.next();
                    if (Statements.isSameTriple((Statement)stmt, (Statement)nextStmt)) continue;
                    throw new QueryEvaluationException("Multiple statements for pattern: " + subj + " " + pred + " " + obj);
                }
            } else {
                stmt = null;
            }
        }
        return stmt;
    }

    public static CloseableIteration<? extends IRI, QueryEvaluationException> getSubjectURIs(IRI predicate, Value object, TripleSource store) throws QueryEvaluationException {
        return new ConvertingIteration<Statement, IRI, QueryEvaluationException>((Iteration)new FilterIteration<Statement, QueryEvaluationException>(store.getStatements(null, predicate, object, new Resource[0])){

            protected boolean accept(Statement stmt) throws QueryEvaluationException {
                return stmt.getSubject() instanceof IRI;
            }
        }){

            protected IRI convert(Statement stmt) throws QueryEvaluationException {
                return (IRI)stmt.getSubject();
            }
        };
    }

    public static CloseableIteration<? extends Resource, QueryEvaluationException> getObjectResources(Resource subject, IRI predicate, TripleSource store) throws QueryEvaluationException {
        return new ConvertingIteration<Statement, Resource, QueryEvaluationException>((Iteration)new FilterIteration<Statement, QueryEvaluationException>(store.getStatements(subject, predicate, null, new Resource[0])){

            protected boolean accept(Statement stmt) throws QueryEvaluationException {
                return stmt.getObject() instanceof Resource;
            }
        }){

            protected Resource convert(Statement stmt) throws QueryEvaluationException {
                return (Resource)stmt.getObject();
            }
        };
    }

    public static CloseableIteration<? extends IRI, QueryEvaluationException> getObjectURIs(Resource subject, IRI predicate, TripleSource store) throws QueryEvaluationException {
        return new ConvertingIteration<Statement, IRI, QueryEvaluationException>((Iteration)new FilterIteration<Statement, QueryEvaluationException>(store.getStatements(subject, predicate, null, new Resource[0])){

            protected boolean accept(Statement stmt) throws QueryEvaluationException {
                return stmt.getObject() instanceof IRI;
            }
        }){

            protected IRI convert(Statement stmt) throws QueryEvaluationException {
                return (IRI)stmt.getObject();
            }
        };
    }

    public static CloseableIteration<? extends Literal, QueryEvaluationException> getObjectLiterals(Resource subject, IRI predicate, TripleSource store) throws QueryEvaluationException {
        return new ConvertingIteration<Statement, Literal, QueryEvaluationException>((Iteration)new FilterIteration<Statement, QueryEvaluationException>(store.getStatements(subject, predicate, null, new Resource[0])){

            protected boolean accept(Statement stmt) throws QueryEvaluationException {
                return stmt.getObject() instanceof Literal;
            }
        }){

            protected Literal convert(Statement stmt) throws QueryEvaluationException {
                return (Literal)stmt.getObject();
            }
        };
    }
}

