/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory.model;

import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.common.lang.ObjectUtil;
import org.eclipse.rdf4j.sail.memory.model.MemIRI;
import org.eclipse.rdf4j.sail.memory.model.MemResource;
import org.eclipse.rdf4j.sail.memory.model.MemStatement;
import org.eclipse.rdf4j.sail.memory.model.MemStatementList;
import org.eclipse.rdf4j.sail.memory.model.MemValue;

public class MemStatementIterator<X extends Exception>
extends LookAheadIteration<MemStatement, X> {
    private final MemStatementList statementList;
    private final MemResource subject;
    private final MemIRI predicate;
    private final MemValue object;
    private final MemResource[] contexts;
    private final Boolean explicit;
    private final int snapshot;
    private int statementIdx;

    public MemStatementIterator(MemStatementList statementList, MemResource subject, MemIRI predicate, MemValue object, Boolean explicit, int snapshot, MemResource ... contexts) {
        this.statementList = statementList;
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
        this.contexts = contexts;
        this.explicit = explicit;
        this.snapshot = snapshot;
        this.statementIdx = -1;
    }

    protected MemStatement getNextElement() {
        ++this.statementIdx;
        while (this.statementIdx < this.statementList.size()) {
            block6: {
                MemStatement st;
                block7: {
                    st = this.statementList.get(this.statementIdx);
                    if (!this.isInSnapshot(st) || this.subject != null && this.subject != st.getSubject() || this.predicate != null && this.predicate != st.getPredicate() || this.object != null && this.object != st.getObject()) break block6;
                    if (this.contexts == null || this.contexts.length <= 0) break block7;
                    boolean matchingContext = false;
                    for (int i = 0; i < this.contexts.length && !matchingContext; ++i) {
                        matchingContext = ObjectUtil.nullEquals((Object)st.getContext(), (Object)this.contexts[i]);
                    }
                    if (!matchingContext) break block6;
                }
                if (this.explicit == null || this.explicit.booleanValue() == st.isExplicit()) {
                    return st;
                }
            }
            ++this.statementIdx;
        }
        return null;
    }

    private boolean isInSnapshot(MemStatement st) {
        return this.snapshot < 0 || st.isInSnapshot(this.snapshot);
    }
}

