/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.TupleFunctionCall;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.lucene.LuceneSailSchema;
import org.eclipse.rdf4j.sail.lucene.QuerySpec;
import org.eclipse.rdf4j.sail.lucene.SearchQueryEvaluator;
import org.eclipse.rdf4j.sail.lucene.SearchQueryInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuerySpecBuilder
implements SearchQueryInterpreter {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final boolean incompleteQueryFails;

    public QuerySpecBuilder(boolean incompleteQueryFails) {
        this.incompleteQueryFails = incompleteQueryFails;
    }

    @Deprecated
    public Set<QuerySpec> process(TupleExpr tupleExpr, BindingSet bindings) throws SailException {
        HashSet<SearchQueryEvaluator> result = new HashSet<SearchQueryEvaluator>();
        this.process(tupleExpr, bindings, result);
        return result;
    }

    @Override
    public void process(TupleExpr tupleExpr, BindingSet bindings, Collection<SearchQueryEvaluator> result) throws SailException {
        PatternFilter filter = new PatternFilter();
        tupleExpr.visit((QueryModelVisitor)filter);
        for (StatementPattern matchesPattern : filter.matchesPatterns) {
            QuerySpec querySpec;
            Var snippetVar;
            Var scoreVar;
            StatementPattern snippetPattern;
            StatementPattern scorePattern;
            StatementPattern propertyPattern;
            StatementPattern queryPattern;
            StatementPattern typePattern;
            Value subjectValue;
            Var subjectVar = matchesPattern.getSubjectVar();
            Value value = subjectValue = subjectVar.hasValue() ? subjectVar.getValue() : bindings.getValue(subjectVar.getName());
            if (subjectValue != null && !(subjectValue instanceof Resource)) {
                this.failOrWarn(LuceneSailSchema.MATCHES + " properties should have Resource subjects: " + subjectVar.getValue());
                continue;
            }
            Resource subject = (Resource)subjectValue;
            Var matchesVar = matchesPattern.getObjectVar();
            if (matchesVar.hasValue()) {
                this.failOrWarn(LuceneSailSchema.MATCHES + " properties should have variable objects: " + matchesVar.getValue());
                continue;
            }
            try {
                typePattern = this.getPattern(matchesVar, filter.typePatterns);
                queryPattern = this.getPattern(matchesVar, filter.queryPatterns);
                propertyPattern = this.getPattern(matchesVar, filter.propertyPatterns);
                scorePattern = this.getPattern(matchesVar, filter.scorePatterns);
                snippetPattern = this.getPattern(matchesVar, filter.snippetPatterns);
            }
            catch (IllegalArgumentException e) {
                this.failOrWarn(e);
                continue;
            }
            String queryString = null;
            if (queryPattern != null) {
                Value queryValue;
                Var queryVar = queryPattern.getObjectVar();
                Value value2 = queryValue = queryVar.hasValue() ? queryVar.getValue() : bindings.getValue(queryVar.getName());
                if (queryValue instanceof Literal) {
                    queryString = ((Literal)queryValue).getLabel();
                }
            }
            IRI propertyURI = null;
            if (propertyPattern != null) {
                Value propertyValue;
                Var propertyVar = propertyPattern.getObjectVar();
                Value value3 = propertyValue = propertyVar.hasValue() ? propertyVar.getValue() : bindings.getValue(propertyVar.getName());
                if (propertyValue instanceof IRI) {
                    propertyURI = (IRI)propertyValue;
                } else if (propertyValue != null) {
                    this.failOrWarn(LuceneSailSchema.PROPERTY + " should have a property URI or a variable as object: " + propertyVar.getValue());
                    continue;
                }
            }
            Var var = scoreVar = scorePattern == null ? null : scorePattern.getObjectVar();
            if (scoreVar != null && scoreVar.hasValue()) {
                this.failOrWarn(LuceneSailSchema.SCORE + " should have a variable as object: " + scoreVar.getValue());
                continue;
            }
            Var var2 = snippetVar = snippetPattern == null ? null : snippetPattern.getObjectVar();
            if (snippetVar != null && snippetVar.hasValue()) {
                this.failOrWarn(LuceneSailSchema.SNIPPET + " should have a variable as object: " + snippetVar.getValue());
                continue;
            }
            if (typePattern == null) {
                this.logger.debug("Query variable '{}' has not rdf:type, assuming {}", (Object)subject, (Object)LuceneSailSchema.LUCENE_QUERY);
            }
            if ((querySpec = new QuerySpec(matchesPattern, queryPattern, propertyPattern, scorePattern, snippetPattern, typePattern, subject, queryString, propertyURI)).isEvaluable()) {
                result.add(querySpec);
                continue;
            }
            TupleFunctionCall funcCall = new TupleFunctionCall();
            funcCall.setURI(LuceneSailSchema.SEARCH.toString());
            funcCall.addArg((ValueExpr)queryPattern.getObjectVar());
            if (subject != null) {
                funcCall.addArg((ValueExpr)matchesPattern.getSubjectVar());
            } else {
                funcCall.addArg((ValueExpr)new ValueConstant((Value)LuceneSailSchema.ALL_MATCHES));
                funcCall.addResultVar(matchesPattern.getSubjectVar());
            }
            if (propertyPattern != null) {
                funcCall.addArg((ValueExpr)new ValueConstant((Value)LuceneSailSchema.PROPERTY));
                if (propertyURI != null) {
                    funcCall.addArg((ValueExpr)propertyPattern.getObjectVar());
                } else {
                    funcCall.addArg((ValueExpr)new ValueConstant((Value)LuceneSailSchema.ALL_PROPERTIES));
                    funcCall.addResultVar(propertyPattern.getObjectVar());
                }
            }
            if (scoreVar != null) {
                funcCall.addArg((ValueExpr)new ValueConstant((Value)LuceneSailSchema.SCORE));
                funcCall.addResultVar(scoreVar);
            }
            if (snippetVar != null) {
                funcCall.addArg((ValueExpr)new ValueConstant((Value)LuceneSailSchema.SNIPPET));
                funcCall.addResultVar(snippetVar);
            }
            Join join = new Join();
            matchesPattern.replaceWith((QueryModelNode)join);
            join.setLeftArg((TupleExpr)matchesPattern);
            join.setRightArg((TupleExpr)funcCall);
            querySpec.removeQueryPatterns();
        }
    }

    private void failOrWarn(Exception exception) throws SailException {
        if (this.incompleteQueryFails) {
            throw exception instanceof SailException ? (SailException)exception : new SailException((Throwable)exception);
        }
        this.logger.warn(exception.getMessage(), (Throwable)exception);
    }

    private void failOrWarn(String message) throws SailException {
        if (this.incompleteQueryFails) {
            throw new SailException("Invalid Text Query: " + message);
        }
        this.logger.warn(message);
    }

    private StatementPattern getPattern(Var subjectVar, ArrayList<StatementPattern> patterns) throws IllegalArgumentException {
        StatementPattern result = null;
        for (StatementPattern pattern : patterns) {
            if (!pattern.getSubjectVar().equals((Object)subjectVar)) continue;
            if (result == null) {
                result = pattern;
                continue;
            }
            throw new IllegalArgumentException("multiple StatementPatterns with the same subject: " + result + ", " + pattern);
        }
        if (result != null) {
            patterns.remove(result);
        }
        return result;
    }

    private static class PatternFilter
    extends AbstractQueryModelVisitor<RuntimeException> {
        public ArrayList<StatementPattern> typePatterns = new ArrayList();
        public ArrayList<StatementPattern> matchesPatterns = new ArrayList();
        public ArrayList<StatementPattern> queryPatterns = new ArrayList();
        public ArrayList<StatementPattern> propertyPatterns = new ArrayList();
        public ArrayList<StatementPattern> scorePatterns = new ArrayList();
        public ArrayList<StatementPattern> snippetPatterns = new ArrayList();

        private PatternFilter() {
        }

        public void meet(StatementPattern node) {
            Value object;
            Value predicate = node.getPredicateVar().getValue();
            if (LuceneSailSchema.MATCHES.equals((Object)predicate)) {
                this.matchesPatterns.add(node);
            } else if (LuceneSailSchema.QUERY.equals((Object)predicate)) {
                this.queryPatterns.add(node);
            } else if (LuceneSailSchema.PROPERTY.equals((Object)predicate)) {
                this.propertyPatterns.add(node);
            } else if (LuceneSailSchema.SCORE.equals((Object)predicate)) {
                this.scorePatterns.add(node);
            } else if (LuceneSailSchema.SNIPPET.equals((Object)predicate)) {
                this.snippetPatterns.add(node);
            } else if (RDF.TYPE.equals((Object)predicate) && LuceneSailSchema.LUCENE_QUERY.equals((Object)(object = node.getObjectVar().getValue()))) {
                this.typePatterns.add(node);
            }
        }
    }
}

