/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.concurrent.locks;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.StampedLock;
import org.eclipse.rdf4j.common.concurrent.locks.Lock;
import org.eclipse.rdf4j.common.concurrent.locks.ReadWriteLockManager;
import org.eclipse.rdf4j.common.concurrent.locks.diagnostics.LockCleaner;
import org.eclipse.rdf4j.common.concurrent.locks.diagnostics.LockDiagnostics;
import org.eclipse.rdf4j.common.concurrent.locks.diagnostics.LockMonitoring;
import org.eclipse.rdf4j.common.concurrent.locks.diagnostics.LockTracking;
import org.slf4j.LoggerFactory;

public abstract class AbstractReadWriteLockManager
implements ReadWriteLockManager {
    private final LockMonitoring<ReadLock> readLockMonitoring;
    private final LockMonitoring<WriteLock> writeLockMonitoring;
    final StampedLock stampedLock = new StampedLock();
    final LongAdder readersLocked = new LongAdder();
    final LongAdder readersUnlocked = new LongAdder();
    private final int tryWriteLockMillis;
    final int writePreference;

    public AbstractReadWriteLockManager() {
        this(false);
    }

    public AbstractReadWriteLockManager(boolean trackLocks) {
        this(trackLocks, 10000);
    }

    public AbstractReadWriteLockManager(boolean trackLocks, int waitToCollect) {
        this("", waitToCollect, LockDiagnostics.fromLegacyTracking(trackLocks));
    }

    public AbstractReadWriteLockManager(String alias, LockDiagnostics ... lockDiagnostics) {
        this(alias, 10000, lockDiagnostics);
    }

    public AbstractReadWriteLockManager(String alias, int waitToCollect, LockDiagnostics ... lockDiagnostics) {
        this.tryWriteLockMillis = Math.min(1000, waitToCollect);
        this.writePreference = Math.max(1, this.getWriterPreference());
        boolean releaseAbandoned = false;
        boolean detectStalledOrDeadlock = false;
        boolean stackTrace = false;
        block5: for (LockDiagnostics lockDiagnostic : lockDiagnostics) {
            switch (lockDiagnostic) {
                case releaseAbandoned: {
                    releaseAbandoned = true;
                    continue block5;
                }
                case detectStalledOrDeadlock: {
                    detectStalledOrDeadlock = true;
                    continue block5;
                }
                case stackTrace: {
                    stackTrace = true;
                }
            }
        }
        if (lockDiagnostics.length == 0) {
            this.readLockMonitoring = LockMonitoring.wrap(Lock.ExtendedSupplier.wrap(this::createReadLockInner, this::tryReadLockInner));
            this.writeLockMonitoring = LockMonitoring.wrap(Lock.ExtendedSupplier.wrap(this::createWriteLockInner, this::tryWriteLockInner));
        } else if (releaseAbandoned && !detectStalledOrDeadlock) {
            this.readLockMonitoring = new LockCleaner<ReadLock>(stackTrace, alias + "_READ", LoggerFactory.getLogger(this.getClass()), Lock.ExtendedSupplier.wrap(this::createReadLockInner, this::tryReadLockInner));
            this.writeLockMonitoring = new LockCleaner<WriteLock>(stackTrace, alias + "_WRITE", LoggerFactory.getLogger(this.getClass()), Lock.ExtendedSupplier.wrap(this::createWriteLockInner, this::tryWriteLockInner));
        } else {
            this.readLockMonitoring = new LockTracking<ReadLock>(stackTrace, alias + "_READ", LoggerFactory.getLogger(this.getClass()), waitToCollect, Lock.ExtendedSupplier.wrap(this::createReadLockInner, this::tryReadLockInner));
            this.writeLockMonitoring = new LockTracking<WriteLock>(stackTrace, alias + "_WRITE", LoggerFactory.getLogger(this.getClass()), waitToCollect, Lock.ExtendedSupplier.wrap(this::createWriteLockInner, this::tryWriteLockInner));
        }
    }

    abstract int getWriterPreference();

    @Override
    public boolean isWriterActive() {
        return this.stampedLock.isWriteLocked();
    }

    @Override
    public boolean isReaderActive() {
        long lockedSum;
        long unlockedSum = this.readersUnlocked.sum();
        return unlockedSum != (lockedSum = this.readersLocked.sum());
    }

    @Override
    public void waitForActiveWriter() throws InterruptedException {
        while (this.stampedLock.isWriteLocked() && !this.isReaderActive()) {
            this.spinWait();
        }
    }

    @Override
    public void waitForActiveReaders() throws InterruptedException {
        while (this.isReaderActive()) {
            this.spinWait();
        }
    }

    @Override
    public Lock getReadLock() throws InterruptedException {
        return this.readLockMonitoring.getLock();
    }

    ReadLock createReadLockInner() throws InterruptedException {
        this.readersLocked.increment();
        while (this.stampedLock.isWriteLocked()) {
            try {
                this.spinWaitAtReadLock();
            }
            catch (InterruptedException e) {
                this.readersUnlocked.increment();
                throw e;
            }
        }
        return new ReadLock(this.readersUnlocked);
    }

    @Override
    public Lock getWriteLock() throws InterruptedException {
        return this.writeLockMonitoring.getLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WriteLock createWriteLockInner() throws InterruptedException {
        long writeStamp = this.writeLockInterruptibly();
        boolean lockAcquired = false;
        try {
            int attempts = 0;
            do {
                long lockedSum;
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                long unlockedSum = this.readersUnlocked.sum();
                if (unlockedSum == (lockedSum = this.readersLocked.sum())) {
                    lockAcquired = true;
                    continue;
                }
                if (attempts++ > this.writePreference) {
                    attempts = 0;
                    this.stampedLock.unlockWrite(writeStamp);
                    writeStamp = 0L;
                    this.yieldWait();
                    writeStamp = this.writeLockInterruptibly();
                    continue;
                }
                this.spinWait();
            } while (!lockAcquired);
        }
        finally {
            if (!lockAcquired && writeStamp != 0L) {
                this.stampedLock.unlockWrite(writeStamp);
                writeStamp = 0L;
            }
        }
        return new WriteLock(this.stampedLock, writeStamp);
    }

    private long writeLockInterruptibly() throws InterruptedException {
        if (this.writeLockMonitoring.requiresManualCleanup()) {
            long writeStamp;
            do {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                writeStamp = this.stampedLock.tryWriteLock(this.tryWriteLockMillis, TimeUnit.MILLISECONDS);
                if (writeStamp != 0L) continue;
                this.writeLockMonitoring.runCleanup();
                this.readLockMonitoring.runCleanup();
            } while (writeStamp == 0L);
            return writeStamp;
        }
        return this.stampedLock.writeLockInterruptibly();
    }

    @Override
    public Lock tryReadLock() {
        return this.readLockMonitoring.tryLock();
    }

    private ReadLock tryReadLockInner() {
        this.readersLocked.increment();
        if (!this.stampedLock.isWriteLocked()) {
            return new ReadLock(this.readersUnlocked);
        }
        this.readersUnlocked.increment();
        this.readLockMonitoring.runCleanup();
        this.writeLockMonitoring.runCleanup();
        return null;
    }

    @Override
    public Lock tryWriteLock() {
        return this.writeLockMonitoring.tryLock();
    }

    private WriteLock tryWriteLockInner() {
        long writeStamp = this.stampedLock.tryWriteLock();
        if (writeStamp != 0L) {
            long lockedSum;
            long unlockedSum = this.readersUnlocked.sum();
            if (unlockedSum == (lockedSum = this.readersLocked.sum())) {
                return new WriteLock(this.stampedLock, writeStamp);
            }
            this.stampedLock.unlockWrite(writeStamp);
            this.readLockMonitoring.runCleanup();
            this.writeLockMonitoring.runCleanup();
        }
        return null;
    }

    void spinWait() throws InterruptedException {
        Thread.onSpinWait();
        this.writeLockMonitoring.runCleanup();
        this.readLockMonitoring.runCleanup();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    void spinWaitAtReadLock() throws InterruptedException {
        Thread.onSpinWait();
        this.writeLockMonitoring.runCleanup();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    private void yieldWait() throws InterruptedException {
        Thread.yield();
        this.writeLockMonitoring.runCleanup();
        this.readLockMonitoring.runCleanup();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    static class ReadLock
    implements Lock {
        private final LongAdder readersUnlocked;
        private boolean locked = true;

        public ReadLock(LongAdder readersUnlocked) {
            this.readersUnlocked = readersUnlocked;
        }

        @Override
        public boolean isActive() {
            return this.locked;
        }

        @Override
        public void release() {
            if (!this.locked) {
                throw new IllegalMonitorStateException("Trying to release a lock that is not locked");
            }
            this.locked = false;
            this.readersUnlocked.increment();
        }
    }

    static class WriteLock
    implements Lock {
        private final StampedLock lock;
        private long stamp;

        public WriteLock(StampedLock lock, long stamp) {
            assert (stamp != 0L);
            this.lock = lock;
            this.stamp = stamp;
        }

        @Override
        public boolean isActive() {
            return this.stamp != 0L;
        }

        @Override
        public void release() {
            long temp = this.stamp;
            this.stamp = 0L;
            if (temp == 0L) {
                throw new IllegalMonitorStateException("Trying to release a lock that is not locked");
            }
            this.lock.unlockWrite(temp);
        }
    }
}

