/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.hdt;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CheckedInputStream;
import org.eclipse.rdf4j.common.io.UncloseableInputStream;
import org.eclipse.rdf4j.rio.hdt.CRC8;
import org.eclipse.rdf4j.rio.hdt.HDTPart;
import org.eclipse.rdf4j.rio.hdt.VByte;

abstract class HDTArray
extends HDTPart {
    int nrbits;
    int entries;

    HDTArray() {
    }

    abstract int getType();

    int getNrBits() {
        return this.nrbits;
    }

    int size() {
        return this.entries;
    }

    abstract int get(int var1);

    @Override
    void parse(InputStream is) throws IOException {
        CRC8 crc8 = new CRC8();
        crc8.update(this.getType());
        try (UncloseableInputStream uis = new UncloseableInputStream(is);
             CheckedInputStream cis = new CheckedInputStream((InputStream)uis, crc8);){
            this.nrbits = cis.read();
            long l = VByte.decode(cis);
            if (l > Integer.MAX_VALUE) {
                throw new UnsupportedOperationException("Maximum number of bytes in array exceeded: " + l);
            }
            this.entries = (int)l;
            HDTArray.checkCRC(cis, is, 1);
        }
    }

    static enum Type {
        LOG64(1),
        UINT32(2),
        UINT64(3);

        private final int value;

        int getValue() {
            return this.value;
        }

        private Type(int value) {
            this.value = value;
        }
    }
}

