/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio.text.csv;

import com.opencsv.CSVReader;
import com.opencsv.bean.BeanField;
import com.opencsv.bean.MappingStrategy;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.impl.ListBindingSet;

public class SPARQLResultsCSVMappingStrategy
implements MappingStrategy<BindingSet> {
    private List<String> bindingNames = null;
    private final ValueFactory valueFactory;
    private static final Pattern numberPattern = Pattern.compile("^[-+]?[\\d.].*");
    private static final String WRITING_UNSUPPORTED = "This mapping strategy does not write.";

    public SPARQLResultsCSVMappingStrategy(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    public List<String> getBindingNames() {
        return this.bindingNames;
    }

    @Deprecated
    public PropertyDescriptor findDescriptor(int col) {
        return null;
    }

    @Deprecated
    public BeanField<BindingSet> findField(int col) {
        return null;
    }

    @Deprecated
    public int findMaxFieldIndex() {
        return 0;
    }

    @Deprecated
    public BindingSet createBean() {
        return null;
    }

    public void captureHeader(CSVReader reader) throws IOException {
        this.bindingNames = Arrays.asList(reader.readNext());
    }

    public String[] generateHeader(BindingSet bean) {
        throw new UnsupportedOperationException(WRITING_UNSUPPORTED);
    }

    @Deprecated
    public Integer getColumnIndex(String name) {
        return null;
    }

    public boolean isAnnotationDriven() {
        return true;
    }

    public BindingSet populateNewBean(String[] line) {
        ArrayList<BNode> values = new ArrayList<BNode>(line.length);
        for (String valueString : line) {
            BNode v = null;
            if (valueString.startsWith("_:")) {
                v = this.valueFactory.createBNode(valueString.substring(2));
            } else if (!"".equals(valueString)) {
                if (numberPattern.matcher(valueString).matches()) {
                    IRI datatype = null;
                    if (XMLDatatypeUtil.isValidInteger((String)valueString)) {
                        datatype = XMLDatatypeUtil.isValidNegativeInteger((String)valueString) ? XMLSchema.NEGATIVE_INTEGER : XMLSchema.INTEGER;
                    } else if (XMLDatatypeUtil.isValidDecimal((String)valueString)) {
                        datatype = XMLSchema.DECIMAL;
                    } else if (XMLDatatypeUtil.isValidDouble((String)valueString)) {
                        datatype = XMLSchema.DOUBLE;
                    }
                    v = datatype != null ? this.valueFactory.createLiteral(valueString, datatype) : this.valueFactory.createLiteral(valueString);
                } else {
                    try {
                        v = this.valueFactory.createIRI(valueString);
                    }
                    catch (IllegalArgumentException e) {
                        v = this.valueFactory.createLiteral(valueString);
                    }
                }
            }
            values.add(v);
        }
        return new ListBindingSet(this.bindingNames, values.toArray(new Value[values.size()]));
    }

    @Deprecated
    public BindingSet populateNewBeanWithIntrospection(String[] line) {
        throw new UnsupportedOperationException("Please use populateNewBean() instead.");
    }

    @Deprecated
    public void verifyLineLength(int numberOfFields) {
    }

    public void setErrorLocale(Locale errorLocale) {
    }

    public void setType(Class<? extends BindingSet> type) {
    }

    public String[] transmuteBean(BindingSet bean) {
        throw new UnsupportedOperationException(WRITING_UNSUPPORTED);
    }
}

