/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.xsd;

import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.xsd.CastFunction;

public class DoubleCast
extends CastFunction {
    @Override
    protected Literal convert(ValueFactory valueFactory, Value value) throws ValueExprEvaluationException {
        if (value instanceof Literal) {
            Literal literal = (Literal)value;
            CoreDatatype.XSD datatype = literal.getCoreDatatype().asXSDDatatypeOrNull();
            if (datatype != null && datatype.isNumericDatatype()) {
                try {
                    double doubleValue = literal.doubleValue();
                    return valueFactory.createLiteral(doubleValue);
                }
                catch (NumberFormatException e) {
                    throw new ValueExprEvaluationException(e.getMessage(), e);
                }
            }
            if (datatype == CoreDatatype.XSD.BOOLEAN) {
                try {
                    return valueFactory.createLiteral(literal.booleanValue() ? 1.0 : 0.0);
                }
                catch (IllegalArgumentException e) {
                    throw this.typeError((Value)literal, e);
                }
            }
        }
        throw this.typeError(value, null);
    }

    @Override
    protected CoreDatatype.XSD getCoreXsdDatatype() {
        return CoreDatatype.XSD.DOUBLE;
    }

    @Override
    protected boolean isValidForDatatype(String lexicalValue) {
        return XMLDatatypeUtil.isValidDouble((String)lexicalValue);
    }
}

