/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl;

import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.FN;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.Compare;
import org.eclipse.rdf4j.query.algebra.FunctionCall;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.Regex;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

@Deprecated(forRemoval=true, since="4.1.0")
public class RegexAsStringFunctionOptimizer
implements QueryOptimizer {
    private final ValueFactory vf;

    public RegexAsStringFunctionOptimizer(ValueFactory vf) {
        this.vf = vf;
    }

    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit((QueryModelVisitor)new RegexAsStringFunctionVisitor());
    }

    protected class RegexAsStringFunctionVisitor
    extends AbstractQueryModelVisitor<RuntimeException> {
        protected RegexAsStringFunctionVisitor() {
        }

        public void meet(Regex node) {
            ValueExpr flagsArg = node.getFlagsArg();
            if ((flagsArg == null || flagsArg.toString().isEmpty()) && node.getPatternArg() instanceof ValueConstant) {
                ValueConstant vc = (ValueConstant)node.getPatternArg();
                String regex = vc.getValue().stringValue();
                boolean anchoredAtStart = regex.startsWith("^");
                boolean anchoredAtEnd = regex.endsWith("$");
                if (anchoredAtStart && anchoredAtEnd) {
                    this.equalsCandidate(node, regex);
                } else if (anchoredAtStart) {
                    this.strstartsCandidate(node, regex);
                } else if (anchoredAtEnd) {
                    this.strendsCandidate(node, regex);
                } else {
                    this.containsCandidate(node, regex);
                }
            }
            super.meet(node);
        }

        private void containsCandidate(Regex node, String potential) {
            if (this.plain(potential)) {
                node.replaceWith((QueryModelNode)new FunctionCall(FN.CONTAINS.stringValue(), new ValueExpr[]{node.getArg(), node.getPatternArg()}));
            }
        }

        private boolean plain(String potential) {
            for (char not : new char[]{'?', '*', '+', '{', '|', '\\', '.', '[', ']', '&', '(', ')'}) {
                if (potential.indexOf(not) == -1) continue;
                return false;
            }
            return true;
        }

        private void strendsCandidate(Regex node, String regex) {
            String potential = regex.substring(0, regex.length() - 1);
            if (this.plain(potential)) {
                ValueConstant vc = new ValueConstant((Value)RegexAsStringFunctionOptimizer.this.vf.createLiteral(potential));
                node.replaceWith((QueryModelNode)new FunctionCall(FN.ENDS_WITH.stringValue(), new ValueExpr[]{node.getArg(), vc}));
            }
        }

        private void strstartsCandidate(Regex node, String regex) {
            String potential = regex.substring(1, regex.length());
            if (this.plain(potential)) {
                ValueConstant vc = new ValueConstant((Value)RegexAsStringFunctionOptimizer.this.vf.createLiteral(potential));
                node.replaceWith((QueryModelNode)new FunctionCall(FN.STARTS_WITH.stringValue(), new ValueExpr[]{node.getArg(), vc}));
            }
        }

        private void equalsCandidate(Regex node, String regex) {
            String potential = regex.substring(1, regex.length() - 1);
            if (this.plain(potential)) {
                ValueConstant vc = new ValueConstant((Value)RegexAsStringFunctionOptimizer.this.vf.createLiteral(potential));
                node.replaceWith((QueryModelNode)new Compare(node.getArg(), (ValueExpr)vc, Compare.CompareOp.EQ));
            }
        }
    }
}

