/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.TupleQueryResult;

public class MutableTupleQueryResult
implements TupleQueryResult,
Cloneable {
    private Set<String> bindingNames = new LinkedHashSet<String>();
    private List<BindingSet> bindingSets = new ArrayList<BindingSet>();
    private int currentIndex = 0;
    private int lastReturned = -1;

    public <E extends Exception> MutableTupleQueryResult(Collection<String> bindingNames, BindingSet ... bindingSets) {
        this(bindingNames, Arrays.asList(bindingSets));
    }

    public MutableTupleQueryResult(Collection<String> bindingNames, Collection<? extends BindingSet> bindingSets) {
        this.bindingNames.addAll(bindingNames);
        this.bindingSets.addAll(bindingSets);
    }

    public <E extends Exception> MutableTupleQueryResult(Collection<String> bindingNames, Iteration<? extends BindingSet, E> bindingSetIter) throws E {
        this.bindingNames.addAll(bindingNames);
        Iterations.addAll(bindingSetIter, this.bindingSets);
    }

    public MutableTupleQueryResult(TupleQueryResult tqr) throws QueryEvaluationException {
        this((Collection<String>)tqr.getBindingNames(), (Iteration)tqr);
    }

    @Override
    public List<String> getBindingNames() {
        return new ArrayList<String>(this.bindingNames);
    }

    public int size() {
        return this.bindingSets.size();
    }

    public BindingSet get(int index) {
        return this.bindingSets.get(index);
    }

    public int getIndex() {
        return this.currentIndex;
    }

    public void setIndex(int index) {
        if (index < 0 || index > this.bindingSets.size() + 1) {
            throw new IllegalArgumentException("Index out of range: " + index);
        }
        this.currentIndex = index;
    }

    public boolean hasNext() {
        return this.currentIndex < this.bindingSets.size();
    }

    public BindingSet next() {
        if (this.hasNext()) {
            BindingSet result = this.get(this.currentIndex);
            this.lastReturned = this.currentIndex++;
            return result;
        }
        throw new NoSuchElementException();
    }

    public boolean hasPrevious() {
        return this.currentIndex > 0;
    }

    public BindingSet previous() {
        if (this.hasPrevious()) {
            BindingSet result = this.bindingSets.get(this.currentIndex - 1);
            --this.currentIndex;
            this.lastReturned = this.currentIndex;
            return result;
        }
        throw new NoSuchElementException();
    }

    public void beforeFirst() {
        this.currentIndex = 0;
    }

    public void afterLast() {
        this.currentIndex = this.bindingSets.size() + 1;
    }

    public void insert(BindingSet bindingSet) {
        this.insert(this.currentIndex, bindingSet);
    }

    public void insert(int index, BindingSet bindingSet) {
        this.bindingSets.add(index, bindingSet);
        if (this.currentIndex > index) {
            ++this.currentIndex;
        }
        this.lastReturned = -1;
    }

    public void append(BindingSet bindingSet) {
        this.bindingSets.add(bindingSet);
        this.lastReturned = -1;
    }

    public void set(BindingSet bindingSet) {
        if (this.lastReturned == -1) {
            throw new IllegalStateException();
        }
        this.set(this.lastReturned, bindingSet);
    }

    public BindingSet set(int index, BindingSet bindingSet) {
        return this.bindingSets.set(index, bindingSet);
    }

    public void remove() {
        if (this.lastReturned == -1) {
            throw new IllegalStateException();
        }
        this.remove(this.lastReturned);
        if (this.currentIndex > this.lastReturned) {
            --this.currentIndex;
        }
        this.lastReturned = -1;
    }

    public BindingSet remove(int index) {
        BindingSet result = this.bindingSets.remove(index);
        if (this.currentIndex > index) {
            --this.currentIndex;
        }
        this.lastReturned = -1;
        return result;
    }

    public void clear() {
        this.bindingNames.clear();
        this.bindingSets.clear();
        this.currentIndex = 0;
        this.lastReturned = -1;
    }

    public void close() {
    }

    public MutableTupleQueryResult clone() throws CloneNotSupportedException {
        MutableTupleQueryResult clone = (MutableTupleQueryResult)super.clone();
        clone.bindingNames = new LinkedHashSet<String>(this.bindingNames);
        clone.bindingSets = new ArrayList<BindingSet>(this.bindingSets);
        return clone;
    }
}

