/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.mappings.transformers.AttributeTransformer;
import org.eclipse.persistence.mappings.transformers.FieldTransformer;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.sessions.DataRecord;
import org.eclipse.persistence.sessions.Session;

public class QNameTransformer
implements AttributeTransformer,
FieldTransformer {
    public static final Map<String, QName> SCHEMA_QNAMES = Map.ofEntries(Map.entry("any", Constants.ANY_QNAME), Map.entry("anySimpleType", Constants.ANY_SIMPLE_TYPE_QNAME), Map.entry("base64Binary", Constants.BASE_64_BINARY_QNAME), Map.entry("boolean", Constants.BOOLEAN_QNAME), Map.entry("byte", Constants.BYTE_QNAME), Map.entry("date", Constants.DATE_QNAME), Map.entry("dateTime", Constants.DATE_TIME_QNAME), Map.entry("decimal", Constants.DECIMAL_QNAME), Map.entry("double", Constants.DOUBLE_QNAME), Map.entry("float", Constants.FLOAT_QNAME), Map.entry("hexBinary", Constants.HEX_BINARY_QNAME), Map.entry("int", Constants.INT_QNAME), Map.entry("integer", Constants.INTEGER_QNAME), Map.entry("long", Constants.LONG_QNAME), Map.entry("QName", Constants.QNAME_QNAME), Map.entry("short", Constants.SHORT_QNAME), Map.entry("string", Constants.STRING_QNAME), Map.entry("time", Constants.TIME_QNAME), Map.entry("unsignedByte", Constants.UNSIGNED_BYTE_QNAME), Map.entry("unsignedInt", Constants.UNSIGNED_INT_QNAME), Map.entry("unsignedShort", Constants.UNSIGNED_SHORT_QNAME), Map.entry("swaRef", Constants.SWA_REF_QNAME));
    private static final char COLON = ':';
    private static final String DEFAULT_NAMESPACE_PREFIX = "";
    AbstractTransformationMapping transformationMapping;
    private transient NamespaceResolver namespaceResolver;
    private final String xPath;

    public QNameTransformer(String xPath) {
        this.xPath = xPath;
    }

    @Override
    public void initialize(AbstractTransformationMapping mapping) {
        this.transformationMapping = mapping;
        this.namespaceResolver = ((XMLDescriptor)mapping.getDescriptor()).getNamespaceResolver();
    }

    @Override
    public Object buildAttributeValue(DataRecord dataRecord, Object object, Session session) {
        if (null == dataRecord) {
            return null;
        }
        String value = (String)dataRecord.get(this.xPath);
        if (null == value) {
            return null;
        }
        int index = value.lastIndexOf(58);
        if (index > -1) {
            QName qName;
            String prefix = value.substring(0, index);
            String localName = value.substring(index + 1);
            String namespaceURI = ((XMLRecord)dataRecord).resolveNamespacePrefix(prefix);
            if ("http://www.w3.org/2001/XMLSchema".equals(namespaceURI) && (qName = SCHEMA_QNAMES.get(localName)) == null) {
                return new QName("http://www.w3.org/2001/XMLSchema", localName, prefix);
            }
            return new QName(namespaceURI, localName, prefix);
        }
        String namespaceURI = ((XMLRecord)dataRecord).resolveNamespacePrefix(DEFAULT_NAMESPACE_PREFIX);
        return new QName(namespaceURI, value);
    }

    @Override
    public Object buildFieldValue(Object instance, String fieldName, Session session) {
        if (null == instance) {
            return null;
        }
        QName qName = (QName)this.transformationMapping.getAttributeValueFromObject(instance);
        if (null == qName.getNamespaceURI()) {
            return qName.getLocalPart();
        }
        String namespaceURI = qName.getNamespaceURI();
        String prefix = this.namespaceResolver.resolveNamespaceURI(namespaceURI);
        if (null == prefix) {
            return qName.getLocalPart();
        }
        return prefix + ":" + qName.getLocalPart();
    }
}

