/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.exceptions;

import jakarta.persistence.EntityExistsException;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.NoResultException;
import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.OptimisticLockException;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.PessimisticLockException;
import jakarta.persistence.QueryTimeoutException;
import jakarta.persistence.RollbackException;
import jakarta.persistence.TransactionRequiredException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Map;
import javax.naming.NamingException;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.JAXBContextFactory;
import org.eclipse.persistence.jaxb.JAXBMarshaller;
import org.eclipse.persistence.jpa.rs.DataStorage;
import org.eclipse.persistence.jpa.rs.exceptions.ErrorResponse;
import org.eclipse.persistence.jpa.rs.exceptions.JPARSException;
import org.eclipse.persistence.jpa.rs.features.ServiceVersion;
import org.eclipse.persistence.jpa.rs.util.JPARSLogger;
import org.eclipse.persistence.jpa.rs.util.StreamingOutputMarshaller;

public abstract class AbstractExceptionMapper {
    @Context
    private HttpHeaders headers;
    @Context
    UriInfo uriInfo;
    private static final Map<String, Response.Status> HTTP_STATUS_CODE_MAPPING = Map.ofEntries(Map.entry(ClassNotFoundException.class.getName(), Response.Status.BAD_REQUEST), Map.entry(ConversionException.class.getName(), Response.Status.BAD_REQUEST), Map.entry(DatabaseException.class.getName(), Response.Status.INTERNAL_SERVER_ERROR), Map.entry(EntityExistsException.class.getName(), Response.Status.CONFLICT), Map.entry(EntityNotFoundException.class.getName(), Response.Status.NOT_FOUND), Map.entry(IOException.class.getName(), Response.Status.BAD_REQUEST), Map.entry(IllegalAccessException.class.getName(), Response.Status.BAD_REQUEST), Map.entry(IllegalArgumentException.class.getName(), Response.Status.BAD_REQUEST), Map.entry(IllegalStateException.class.getName(), Response.Status.BAD_REQUEST), Map.entry(InvocationTargetException.class.getName(), Response.Status.INTERNAL_SERVER_ERROR), Map.entry(JAXBException.class.getName(), Response.Status.NOT_FOUND), Map.entry(MalformedURLException.class.getName(), Response.Status.BAD_REQUEST), Map.entry(NamingException.class.getName(), Response.Status.BAD_REQUEST), Map.entry(NoResultException.class.getName(), Response.Status.NOT_FOUND), Map.entry(NoSuchMethodException.class.getName(), Response.Status.BAD_REQUEST), Map.entry(NonUniqueResultException.class.getName(), Response.Status.NOT_FOUND), Map.entry(NumberFormatException.class.getName(), Response.Status.BAD_REQUEST), Map.entry(OptimisticLockException.class.getName(), Response.Status.INTERNAL_SERVER_ERROR), Map.entry(PersistenceException.class.getName(), Response.Status.INTERNAL_SERVER_ERROR), Map.entry(PessimisticLockException.class.getName(), Response.Status.INTERNAL_SERVER_ERROR), Map.entry(QueryTimeoutException.class.getName(), Response.Status.BAD_REQUEST), Map.entry(RollbackException.class.getName(), Response.Status.BAD_REQUEST), Map.entry(TransactionRequiredException.class.getName(), Response.Status.INTERNAL_SERVER_ERROR));
    private static final String PROBLEM_TYPE = "http://www.eclipse.org/eclipselink/documentation/";

    protected AbstractExceptionMapper() {
    }

    protected Response buildResponse(JPARSException exception) {
        URI requestURI;
        String path = null;
        exception.setHttpStatusCode(AbstractExceptionMapper.getHttpStatusCode(exception.getCause()));
        if (this.uriInfo != null && (requestURI = this.uriInfo.getRequestUri()) != null) {
            path = requestURI.getPath();
        }
        if (path != null && (path.contains(ServiceVersion.VERSION_2_0.getCode()) || path.contains(ServiceVersion.LATEST.getCode()))) {
            ErrorResponse errorResponse = new ErrorResponse(PROBLEM_TYPE, exception.getMessage(), String.valueOf(exception.getErrorCode()));
            errorResponse.setRequestId((String)DataStorage.get("requestId"));
            errorResponse.setHttpStatus(exception.getHttpStatusCode().getStatusCode());
            String error = this.marshallErrorResponse(errorResponse, StreamingOutputMarshaller.getResponseMediaType(this.headers).toString());
            if (error != null) {
                return Response.status((Response.Status)exception.getHttpStatusCode()).entity((Object)error).type(StreamingOutputMarshaller.getResponseMediaType(this.headers)).build();
            }
        }
        return Response.status((Response.Status)exception.getHttpStatusCode()).type(StreamingOutputMarshaller.getResponseMediaType(this.headers)).build();
    }

    private static Response.Status getHttpStatusCode(Throwable throwable) {
        if (throwable != null) {
            Throwable cause;
            Response.Status httpStatusCode = HTTP_STATUS_CODE_MAPPING.get(throwable.getClass().getName());
            if (throwable instanceof RollbackException && (cause = throwable.getCause()) != null && cause instanceof DatabaseException) {
                httpStatusCode = Response.Status.CONFLICT;
            }
            if (httpStatusCode != null) {
                return httpStatusCode;
            }
        }
        return Response.Status.BAD_REQUEST;
    }

    private String marshallErrorResponse(ErrorResponse errorResponse, String mediaType) {
        try {
            JAXBContext context = (JAXBContext)JAXBContextFactory.createContext(new Class[]{ErrorResponse.class}, null);
            JAXBMarshaller marshaller = context.createMarshaller();
            marshaller.setProperty("eclipselink.media-type", mediaType);
            marshaller.setProperty("eclipselink.json.include-root", Boolean.FALSE);
            marshaller.setProperty("eclipselink.json.reduce-any-arrays", true);
            StringWriter writer = new StringWriter();
            marshaller.marshal(errorResponse, writer);
            return writer.toString();
        }
        catch (Exception ex) {
            JPARSLogger.exception(ex.getMessage(), null, ex);
            return null;
        }
    }
}

