/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.List;
import java.util.Locale;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;

public final class IdentificationVariable
extends AbstractExpression {
    private StateFieldPathExpression stateFieldPathExpression;
    private String variableName;
    private boolean virtual;

    public IdentificationVariable(AbstractExpression parent, String identificationVariable) {
        super(parent, identificationVariable);
        if (!"this".equalsIgnoreCase(identificationVariable) && this.getRoot().isGenerateThisPrefix()) {
            this.setVirtualIdentificationVariable("this");
        }
    }

    public IdentificationVariable(AbstractExpression parent, String identificationVariable, boolean virtual) {
        super(parent, identificationVariable);
        this.virtual = virtual;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        if (this.getRoot().isGenerateThisPrefix() && this.isVirtual() && this.stateFieldPathExpression != null) {
            visitor.visit(this.getStateFieldPathExpression());
        } else {
            visitor.visit(this);
        }
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        children.add(this.buildStringExpression(this.getText()));
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("identification_variable");
    }

    public StateFieldPathExpression getStateFieldPathExpression() {
        if (!this.virtual) {
            throw new IllegalAccessError("IdentificationVariable.getStateFieldPathExpression() can only be accessed when it represents an attribute that is not fully qualified, which can be present in an UPDATE or DELETE query.");
        }
        return this.stateFieldPathExpression;
    }

    @Override
    public String getText() {
        return super.getText();
    }

    public String getVariableName() {
        if (this.variableName == null) {
            this.variableName = this.getText().toUpperCase(Locale.ROOT).intern();
        }
        return this.variableName;
    }

    @Override
    public boolean isVirtual() {
        return this.virtual;
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        wordParser.moveForward(this.getText());
    }

    public void setVirtualIdentificationVariable(String variableName) {
        this.virtual = true;
        this.stateFieldPathExpression = new StateFieldPathExpression(this.getParent(), this.getText());
        this.stateFieldPathExpression.setVirtualIdentificationVariable(variableName);
        this.rebuildActualText();
        this.rebuildParsedText();
    }

    @Override
    public String toParsedText() {
        return this.getText();
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        writer.append(this.getText());
    }
}

