/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record.namespaces;

import org.eclipse.persistence.internal.oxm.Namespace;
import org.eclipse.persistence.internal.oxm.NamespacePrefixMapper;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;

public class PrefixMapperNamespaceResolver
extends org.eclipse.persistence.oxm.NamespaceResolver {
    private NamespacePrefixMapper prefixMapper;
    private NamespaceResolver contextualNamespaces;

    public PrefixMapperNamespaceResolver(NamespacePrefixMapper mapper, NamespaceResolver nestedResolver) {
        String[] uris;
        String uri;
        Object prefix;
        this.prefixMapper = mapper;
        String[] declarations = mapper.getContextualNamespaceDecls();
        if (declarations != null && declarations.length > 0) {
            this.contextualNamespaces = new org.eclipse.persistence.oxm.NamespaceResolver();
            for (int i = 0; i < declarations.length - 1; i += 2) {
                prefix = declarations[i];
                String uri2 = declarations[i + 1];
                this.contextualNamespaces.put((String)prefix, uri2);
            }
        }
        String defaultUri = null;
        if (nestedResolver != null) {
            prefix = nestedResolver.getNamespaces().iterator();
            while (prefix.hasNext()) {
                Namespace next;
                Namespace ns = next = prefix.next();
                uri = ns.getNamespaceURI();
                String existingPrefix = null;
                if (this.contextualNamespaces != null) {
                    existingPrefix = this.contextualNamespaces.resolveNamespaceURI(uri);
                }
                if (existingPrefix != null) continue;
                String originalPrefix = ns.getPrefix();
                String prefix2 = this.prefixMapper.getPreferredPrefix(uri, originalPrefix, true);
                if (prefix2 != null) {
                    this.put(prefix2, uri);
                    continue;
                }
                this.put(originalPrefix, uri);
            }
            defaultUri = nestedResolver.getDefaultNamespaceURI();
        }
        if (defaultUri != null) {
            prefix = this.prefixMapper.getPreferredPrefix(defaultUri, "", false);
            if ("".equals(prefix) || prefix == null) {
                this.setDefaultNamespaceURI(defaultUri);
            } else {
                this.put((String)prefix, defaultUri);
            }
        }
        if ((uris = mapper.getPreDeclaredNamespaceUris()) != null && uris.length > 0) {
            for (int i = 0; i < uris.length; ++i) {
                String uri3 = uris[i];
                String prefix3 = this.prefixMapper.getPreferredPrefix(uri3, null, true);
                if (prefix3 != null) {
                    this.put(prefix3, uri3);
                    continue;
                }
                this.put(this.generatePrefix(), uri3);
            }
        }
        if ((declarations = this.prefixMapper.getPreDeclaredNamespaceUris2()) != null && declarations.length > 0) {
            for (int i = 0; i < declarations.length - 1; i += 2) {
                String prefix4 = declarations[i];
                uri = declarations[i + 1];
                this.put(prefix4, uri);
            }
        }
    }

    @Override
    public String resolveNamespaceURI(String uri) {
        String prefix = null;
        if (this.contextualNamespaces != null) {
            prefix = this.contextualNamespaces.resolveNamespaceURI(uri);
        }
        if (prefix == null) {
            prefix = super.resolveNamespaceURI(uri);
        }
        return prefix;
    }

    @Override
    public void put(String prefix, String uri) {
        String newPrefix = this.prefixMapper.getPreferredPrefix(uri, prefix, true);
        if (newPrefix == null || newPrefix.isEmpty()) {
            super.put(prefix, uri);
        } else {
            super.put(newPrefix, uri);
        }
    }

    public NamespacePrefixMapper getPrefixMapper() {
        return this.prefixMapper;
    }
}

