/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.codegen;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.codegen.HierarchyNode;
import org.eclipse.persistence.sessions.Project;

public class InheritanceHierarchyBuilder {
    private InheritanceHierarchyBuilder() {
    }

    public static HierarchyNode getNodeForClass(String className, Map<String, HierarchyNode> hierarchyTree) {
        HierarchyNode node = hierarchyTree.get(className);
        if (node == null) {
            node = new HierarchyNode(className);
            hierarchyTree.put(className, node);
        }
        return node;
    }

    public static Map<String, HierarchyNode> buildInheritanceHierarchyTree(Project project) {
        Map<Class<?>, ClassDescriptor> descriptors = project.getDescriptors();
        HashMap<String, HierarchyNode> hierarchyTree = new HashMap<String, HierarchyNode>(descriptors.size());
        for (ClassDescriptor descriptor : descriptors.values()) {
            String className = descriptor.getJavaClassName();
            if (className == null) {
                className = descriptor.getJavaClass().getName();
            }
            HierarchyNode node = InheritanceHierarchyBuilder.getNodeForClass(className, hierarchyTree);
            if (!descriptor.hasInheritance() || descriptor.getInheritancePolicy().getParentClassName() == null) continue;
            HierarchyNode parentNode = InheritanceHierarchyBuilder.getNodeForClass(descriptor.getInheritancePolicy().getParentClassName(), hierarchyTree);
            node.setParent(parentNode);
        }
        return hierarchyTree;
    }
}

