/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.descriptors.InstanceVariableAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.MethodAttributeAccessor;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.mappings.VariableXPathObjectMapping;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLInverseReferenceMapping;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.sessions.Session;

public class XMLVariableXPathObjectMapping
extends XMLCompositeObjectMapping
implements VariableXPathObjectMapping<AbstractSession, AttributeAccessor, ContainerPolicy, Converter, ClassDescriptor, DatabaseField, XMLMarshaller, Session, XMLUnmarshaller, XMLRecord>,
XMLMapping {
    protected String variableAttributeName;
    protected String variableGetMethodName;
    protected String variableSetMethodName;
    private AttributeAccessor variableAttributeAccessor;
    private boolean isAttribute;

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        String referenceClassName = this.getReferenceClassName();
        if (this.referenceClass == null && referenceClassName != null && !referenceClassName.equals("UNKNOWN_OR_TRANSIENT_CLASS")) {
            this.setReferenceClass(session.getDatasourcePlatform().getConversionManager().convertClassNameToClass(referenceClassName));
        }
        if (this.referenceClass != null) {
            super.initialize(session);
        } else {
            if (this.field == null) {
                throw DescriptorException.fieldNameNotSetInMapping(this);
            }
            this.setField(this.getDescriptor().buildField(this.field));
            this.setFields(this.collectFields());
            if (this.hasConverter()) {
                this.getConverter().initialize(this, session);
            }
        }
        XMLInverseReferenceMapping inverseReferenceMapping = this.getInverseReferenceMapping();
        if (null != inverseReferenceMapping && null != inverseReferenceMapping.getAttributeAccessor()) {
            inverseReferenceMapping.getAttributeAccessor().initializeAttributes(this.referenceClass);
        }
        if (this.variableAttributeName != null) {
            this.variableAttributeAccessor = new InstanceVariableAttributeAccessor();
            this.variableAttributeAccessor.setAttributeName(this.variableAttributeName);
            this.variableAttributeAccessor.initializeAttributes(this.getReferenceClass());
        } else if (this.variableGetMethodName != null) {
            this.variableAttributeAccessor = new MethodAttributeAccessor();
            this.variableAttributeAccessor.setAttributeName("VARIABLE");
            ((MethodAttributeAccessor)this.variableAttributeAccessor).setGetMethodName(this.variableGetMethodName);
            if (this.variableSetMethodName == null) {
                this.variableAttributeAccessor.setIsWriteOnly(true);
            } else {
                ((MethodAttributeAccessor)this.variableAttributeAccessor).setSetMethodName(this.variableSetMethodName);
            }
            this.variableAttributeAccessor.initializeAttributes(this.getReferenceClass());
        }
    }

    @Override
    protected Vector collectFields() {
        if (this.field != null) {
            return super.collectFields();
        }
        return NO_FIELDS;
    }

    @Override
    public Vector getFields() {
        return this.collectFields();
    }

    @Override
    protected void initializeReferenceDescriptorAndField(AbstractSession session) {
        if (this.getReferenceClass() == null) {
            throw DescriptorException.referenceClassNotSpecified(this);
        }
        this.setReferenceDescriptor((ClassDescriptor)session.getDescriptor((Class)this.getReferenceClass()));
        ClassDescriptor refDescriptor = this.getReferenceDescriptor();
        if (refDescriptor == null) {
            session.getIntegrityChecker().handleError(DescriptorException.descriptorIsMissing(this.getReferenceClass().getName(), this));
            return;
        }
        if (this.hasConverter()) {
            this.getConverter().initialize(this, session);
        }
    }

    @Override
    public boolean isAbstractCompositeObjectMapping() {
        return false;
    }

    public String getVariableAttributeName() {
        return this.variableAttributeName;
    }

    @Override
    public void setVariableAttributeName(String variableAttributeName) {
        this.variableAttributeName = variableAttributeName;
    }

    public String getVariableGetMethodName() {
        return this.variableGetMethodName;
    }

    @Override
    public void setVariableGetMethodName(String variableGetMethodName) {
        this.variableGetMethodName = variableGetMethodName;
    }

    public String getVariableSetMethodName() {
        return this.variableSetMethodName;
    }

    @Override
    public void setVariableSetMethodName(String variableSetMethodName) {
        this.variableSetMethodName = variableSetMethodName;
    }

    @Override
    public AttributeAccessor getVariableAttributeAccessor() {
        return this.variableAttributeAccessor;
    }

    @Override
    public void setVariableAttributeAccessor(AttributeAccessor variableAttributeAccessor) {
        this.variableAttributeAccessor = variableAttributeAccessor;
    }

    @Override
    public void writeSingleValue(Object value, Object parent, XMLRecord xmlRow, AbstractSession session) {
        Object attributeValue = this.convertObjectValueToDataValue(value, session, xmlRow.getMarshaller());
        if (attributeValue != null) {
            XMLField variableField = new XMLField();
            variableField.setXPathFragment(this.getXPathFragmentForValue(attributeValue, xmlRow.getNamespaceResolver(), xmlRow.isNamespaceAware(), xmlRow.getNamespaceSeparator()));
            xmlRow.put(variableField, (Object)this.buildCompositeRow(variableField, attributeValue, session, xmlRow, DatabaseMapping.WriteType.UNDEFINED));
        }
    }

    protected AbstractRecord buildCompositeRow(XMLField variableField, Object attributeValue, AbstractSession session, AbstractRecord parentRow, DatabaseMapping.WriteType writeType) {
        ClassDescriptor classDesc = this.getReferenceDescriptor(attributeValue, session);
        return this.buildCompositeRowForDescriptor(classDesc, attributeValue, session, (XMLRecord)parentRow, writeType);
    }

    @Override
    public XPathFragment getXPathFragmentForValue(Object obj, NamespaceResolver nr, boolean isNamespaceAware, char namespaceSep) {
        Object returnString;
        Object value = this.getVariableAttributeAccessor().getAttributeValueFromObject(obj);
        String uri = null;
        if (value instanceof QName) {
            returnString = ((QName)value).getLocalPart();
            uri = ((QName)value).getNamespaceURI();
        } else {
            returnString = (String)value;
        }
        XPathFragment frag = new XPathFragment();
        if (isNamespaceAware && uri != null && uri.length() > 0) {
            String prefix = nr.resolveNamespaceURI(uri);
            if (prefix == null) {
                prefix = nr.generatePrefix();
                frag.setGeneratedPrefix(true);
            }
            if (prefix != null && prefix.length() > 0) {
                frag.setPrefix(prefix);
                returnString = prefix + namespaceSep + (String)returnString;
            }
        }
        frag.setXPath((String)returnString);
        frag.setNamespaceURI(uri);
        return frag;
    }

    @Override
    public boolean isAttribute() {
        return this.isAttribute;
    }

    @Override
    public void setAttribute(boolean isAttribute) {
        this.isAttribute = isAttribute;
    }
}

