/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import java.sql.Connection;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.ConnectionCustomizer;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.sequencing.SequencingCallback;
import org.eclipse.persistence.internal.sequencing.SequencingCallbackFactory;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.server.ConnectionPool;

public abstract class DatasourceAccessor
implements Accessor {
    protected Object datasourceConnection;
    protected Login login;
    protected int callCount = 0;
    public int storedProcedureStatementsCount;
    public int readStatementsCount;
    public int writeStatementsCount;
    public static final String READ_STATEMENTS_COUNT_PROPERTY = "Read_Statements_Count_Property";
    public static final String WRITE_STATEMENTS_COUNT_PROPERTY = "Write_Statements_Count_Property";
    public static final String STOREDPROCEDURE_STATEMENTS_COUNT_PROPERTY = "StoredProcedure_Statements_Count_Property";
    protected boolean isInTransaction = false;
    protected boolean isConnected = false;
    protected DatasourcePlatform platform;
    protected boolean isValid = true;
    protected transient SequencingCallback sequencingCallback;
    protected boolean possibleFailure;
    protected transient AbstractSession currentSession;
    protected boolean usesExternalConnectionPooling;
    public static boolean shouldCheckConnection = false;
    protected ConnectionCustomizer customizer;
    protected ConnectionPool pool;

    protected DatasourceAccessor() {
    }

    @Override
    public Object clone() {
        try {
            DatasourceAccessor accessor = (DatasourceAccessor)super.clone();
            if (accessor.customizer != null) {
                accessor.customizer.setAccessor(accessor);
            }
            return accessor;
        }
        catch (CloneNotSupportedException exception) {
            throw new InternalError("clone not supported");
        }
    }

    @Override
    public void closeJTSConnection() {
        if (this.usesExternalTransactionController()) {
            this.isInTransaction = false;
            if (this.usesExternalConnectionPooling) {
                this.closeConnection();
            }
        }
    }

    protected void setIsInTransaction(boolean value) {
        this.isInTransaction = value;
    }

    @Override
    public void setIsValid(boolean isValid) {
        this.isValid = isValid;
    }

    @Override
    public boolean isInTransaction() {
        return this.isInTransaction;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    public boolean isPossibleFailure() {
        return this.possibleFailure;
    }

    public void setPossibleFailure(boolean possibleFailure) {
        this.possibleFailure = possibleFailure;
    }

    @Override
    public boolean usesExternalConnectionPooling() {
        return this.usesExternalConnectionPooling;
    }

    @Override
    public void beginTransaction(AbstractSession session) throws DatabaseException {
        if (this.usesExternalTransactionController()) {
            if (session.isExclusiveConnectionRequired() && !this.isInTransaction && this.usesExternalConnectionPooling) {
                this.closeConnection();
            }
            this.isInTransaction = true;
            return;
        }
        session.log(2, "transaction", "begin_transaction", null, this);
        try {
            session.startOperationProfile("Timer:Transactions");
            this.incrementCallCount(session);
            this.basicBeginTransaction(session);
            this.isInTransaction = true;
        }
        finally {
            this.decrementCallCount();
            session.endOperationProfile("Timer:Transactions");
        }
    }

    protected abstract void basicBeginTransaction(AbstractSession var1);

    protected abstract void basicCommitTransaction(AbstractSession var1);

    protected abstract void basicRollbackTransaction(AbstractSession var1);

    @Override
    public synchronized void decrementCallCount() {
        int count;
        if ((count = this.callCount--) <= 0) {
            return;
        }
        if (!(!this.usesExternalConnectionPooling || this.isInTransaction || this.currentSession != null && this.currentSession.isExclusiveConnectionRequired() || count != 1)) {
            try {
                this.closeConnection();
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void incrementCallCount(AbstractSession session) {
        ++this.callCount;
        if (this.callCount == 1) {
            if (this.login == null) {
                throw DatabaseException.databaseAccessorNotConnected();
            }
            if (this.datasourceConnection != null) {
                if (shouldCheckConnection && !this.isConnected()) {
                    if (this.isInTransaction) {
                        throw DatabaseException.databaseAccessorNotConnected();
                    }
                    this.reconnect(session);
                }
            } else if (this.usesExternalConnectionPooling) {
                this.reconnect(session);
                session.postAcquireConnection(this);
                this.currentSession = session;
            } else {
                throw DatabaseException.databaseAccessorNotConnected();
            }
        }
    }

    @Override
    public void reset() {
        this.readStatementsCount = 0;
        this.writeStatementsCount = 0;
        this.storedProcedureStatementsCount = 0;
    }

    protected void connectInternal(Login login, AbstractSession session) throws DatabaseException {
        try {
            this.datasourceConnection = login.connectToDatasource(this, session);
            this.isConnected = true;
            if (this.customizer != null) {
                this.customizer.customize();
            }
        }
        catch (DatabaseException ex) {
            ex.setAccessor(this);
            throw ex;
        }
    }

    protected void setIsConnected(boolean isConnected) {
        this.isConnected = isConnected;
    }

    protected void setCallCount(int callCount) {
        this.callCount = callCount;
    }

    @Override
    public int getCallCount() {
        return this.callCount;
    }

    @Override
    public void commitTransaction(AbstractSession session) throws DatabaseException {
        if (this.usesExternalTransactionController()) {
            if (!session.isSynchronized()) {
                this.isInTransaction = false;
                if (this.usesExternalConnectionPooling) {
                    this.currentSession = session;
                    this.closeConnection();
                }
            }
            return;
        }
        session.log(2, "transaction", "commit_transaction", null, this);
        try {
            session.startOperationProfile("Timer:Transactions");
            this.incrementCallCount(session);
            this.basicCommitTransaction(session);
            if (this.sequencingCallback != null) {
                this.sequencingCallback.afterCommit(this);
            }
            this.isInTransaction = false;
        }
        finally {
            this.sequencingCallback = null;
            this.decrementCallCount();
            session.endOperationProfile("Timer:Transactions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(Login login, AbstractSession session) throws DatabaseException {
        session.startOperationProfile("Timer:ConnectionManagement");
        session.incrementProfile("Counter:ConnectCalls");
        try {
            if (session.shouldLog(3, "connection")) {
                Object[] args = new Object[]{login};
                session.log(3, "connection", "connecting", args, this);
            }
            this.setLogin(login);
            this.setDatasourcePlatform((DatasourcePlatform)session.getDatasourceLogin().getDatasourcePlatform());
            this.createCustomizer(session);
            try {
                this.connectInternal(login, session);
                this.isInTransaction = false;
            }
            catch (RuntimeException exception) {
                session.handleSevere(exception);
            }
            if (session.hasEventManager()) {
                session.getEventManager().postConnect(this);
            }
            this.incrementCallCount(session);
            try {
                this.buildConnectLog(session);
            }
            finally {
                this.decrementCallCount();
            }
        }
        finally {
            session.endOperationProfile("Timer:ConnectionManagement");
        }
    }

    protected abstract void closeDatasourceConnection();

    protected abstract Object basicExecuteCall(Call var1, AbstractRecord var2, AbstractSession var3);

    protected abstract void buildConnectLog(AbstractSession var1);

    public Login getLogin() {
        return this.login;
    }

    protected void setLogin(Login login) {
        this.login = login;
        this.usesExternalConnectionPooling = login.shouldUseExternalConnectionPooling();
    }

    @Override
    public void disconnect(AbstractSession session) throws DatabaseException {
        session.log(3, "connection", "disconnect", null, this);
        if (this.datasourceConnection == null) {
            return;
        }
        session.incrementProfile("Counter:DisconnectCalls");
        session.startOperationProfile("Timer:ConnectionManagement");
        try {
            this.releaseCustomizer();
            this.closeDatasourceConnection();
            this.datasourceConnection = null;
            this.isInTransaction = true;
        }
        finally {
            session.endOperationProfile("Timer:ConnectionManagement");
        }
    }

    @Override
    public void closeConnection() {
        try {
            if (this.datasourceConnection != null) {
                if (this.isDatasourceConnected()) {
                    if (this.currentSession != null) {
                        this.currentSession.preReleaseConnection(this);
                    }
                    if (this.customizer != null && this.customizer.isActive()) {
                        this.customizer.clear();
                    }
                    this.closeDatasourceConnection();
                }
                this.datasourceConnection = null;
            }
        }
        catch (DatabaseException exception) {
            this.datasourceConnection = null;
        }
        finally {
            this.currentSession = null;
        }
    }

    @Override
    public Object executeCall(Call call, AbstractRecord translationRow, AbstractSession session) throws DatabaseException {
        if (this.login == null) {
            throw DatabaseException.databaseAccessorNotConnected();
        }
        if (session.shouldLog(3, "sql")) {
            session.log(3, "sql", call.getLogString(this), null, this, false);
        }
        Object result = this.basicExecuteCall(call, translationRow, session);
        return result;
    }

    @Override
    public void reestablishConnection(AbstractSession session) throws DatabaseException {
        if (session.shouldLog(3, "connection")) {
            Object[] args = new Object[]{this.getLogin()};
            session.log(3, "connection", "reconnecting", args, this);
        }
        this.reestablishCustomizer();
        this.reconnect(session);
        this.isInTransaction = false;
        this.isValid = true;
        if (session.hasEventManager()) {
            session.getEventManager().postConnect(this);
        }
    }

    protected void reconnect(AbstractSession session) throws DatabaseException {
        session.log(1, "connection", "reconnecting_to_external_connection_pool", null, this);
        session.startOperationProfile("Timer:ConnectionManagement");
        try {
            this.connectInternal(this.login, session);
        }
        finally {
            session.endOperationProfile("Timer:ConnectionManagement");
        }
    }

    public DatasourcePlatform getDatasourcePlatform() {
        return this.platform;
    }

    public void setDatasourcePlatform(DatasourcePlatform platform) {
        this.platform = platform;
    }

    @Override
    public Object getDatasourceConnection() {
        return this.datasourceConnection;
    }

    @Override
    public Connection getConnection() {
        return (Connection)this.datasourceConnection;
    }

    @Override
    public Vector<AbstractRecord> getColumnInfo(String catalog, String schema, String tableName, String columnName, AbstractSession session) throws DatabaseException {
        return new Vector<AbstractRecord>();
    }

    public int getReadStatementsCount() {
        return this.readStatementsCount;
    }

    public int getWriteStatementsCount() {
        return this.writeStatementsCount;
    }

    public int getStoredProcedureStatementsCount() {
        return this.storedProcedureStatementsCount;
    }

    @Override
    public Vector<AbstractRecord> getTableInfo(String catalog, String schema, String tableName, String[] types, AbstractSession session) throws DatabaseException {
        return new Vector<AbstractRecord>();
    }

    protected void setDatasourceConnection(Object connection) {
        this.datasourceConnection = connection;
    }

    @Override
    public void rollbackTransaction(AbstractSession session) throws DatabaseException {
        if (this.usesExternalTransactionController()) {
            if (!session.isSynchronized()) {
                this.isInTransaction = false;
                if (this.usesExternalConnectionPooling) {
                    this.currentSession = session;
                    this.closeConnection();
                }
            }
            return;
        }
        session.log(2, "transaction", "rollback_transaction", null, this);
        try {
            session.startOperationProfile("Timer:Transactions");
            this.incrementCallCount(session);
            this.basicRollbackTransaction(session);
        }
        finally {
            this.isInTransaction = false;
            this.sequencingCallback = null;
            this.decrementCallCount();
            session.endOperationProfile("Timer:Transactions");
        }
    }

    @Override
    public boolean usesExternalTransactionController() {
        if (this.login == null) {
            throw DatabaseException.databaseAccessorNotConnected();
        }
        return this.login.shouldUseExternalTransactionController();
    }

    @Override
    public boolean isConnected() {
        if (this.datasourceConnection == null && this.login == null) {
            return false;
        }
        if (this.usesExternalConnectionPooling) {
            return true;
        }
        if (this.datasourceConnection == null) {
            return false;
        }
        return this.isDatasourceConnected();
    }

    protected abstract boolean isDatasourceConnected();

    @Override
    public void flushSelectCalls(AbstractSession session) {
    }

    @Override
    public void writesCompleted(AbstractSession session) {
    }

    @Override
    public SequencingCallback getSequencingCallback(SequencingCallbackFactory sequencingCallbackFactory) {
        if (this.sequencingCallback == null) {
            this.sequencingCallback = sequencingCallbackFactory.createSequencingCallback();
        }
        return this.sequencingCallback;
    }

    @Override
    public void createCustomizer(AbstractSession session) {
        if (this.customizer == null) {
            ConnectionCustomizer newCustomizer = this.platform != null ? this.platform.createConnectionCustomizer(this, session) : ((DatasourcePlatform)session.getDatasourcePlatform()).createConnectionCustomizer(this, session);
            if (newCustomizer != null) {
                this.setCustomizer(newCustomizer);
            }
        } else {
            if (this.customizer.getSession() == session) {
                return;
            }
            ConnectionCustomizer newCustomizer = this.platform != null ? this.platform.createConnectionCustomizer(this, session) : ((DatasourcePlatform)session.getDatasourcePlatform()).createConnectionCustomizer(this, session);
            if (newCustomizer == null) {
                if (this.customizer.isActive()) {
                    this.customizer.clear();
                }
                newCustomizer = ConnectionCustomizer.createEmptyCustomizer(session);
                newCustomizer.setPrevCustomizer(this.customizer);
                this.customizer = newCustomizer;
            } else if (!newCustomizer.equals(this.customizer)) {
                if (this.customizer.isActive()) {
                    this.customizer.clear();
                }
                newCustomizer.setPrevCustomizer(this.customizer);
                this.setCustomizer(newCustomizer);
            }
        }
    }

    protected void setCustomizer(ConnectionCustomizer newCustomizer) {
        this.customizer = newCustomizer;
        if (this.getDatasourceConnection() != null) {
            this.customizer.customize();
        }
    }

    @Override
    public void releaseCustomizer() {
        if (this.customizer != null) {
            if (this.customizer.isActive()) {
                this.customizer.clear();
            }
            this.customizer = null;
        }
    }

    @Override
    public void releaseCustomizer(AbstractSession session) {
        if (this.customizer != null && this.customizer.getSession() == session) {
            if (this.customizer.isActive()) {
                this.customizer.clear();
            }
            if (this.customizer.getPrevCustomizer() == null) {
                this.customizer = null;
            } else {
                this.setCustomizer(this.customizer.getPrevCustomizer());
            }
        }
    }

    protected void reestablishCustomizer() {
        if (this.customizer != null && this.customizer.isActive()) {
            if (this.isValid()) {
                this.customizer.clear();
            } else {
                AbstractSession customizerSession = (AbstractSession)this.customizer.getSession();
                this.customizer = this.customizer.getPrevCustomizer();
                this.createCustomizer(customizerSession);
            }
        }
    }

    @Override
    public ConnectionPool getPool() {
        return this.pool;
    }

    @Override
    public void setPool(ConnectionPool pool) {
        this.pool = pool;
    }
}

