/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.internal.oxm.NamespaceResolverStorage;
import org.eclipse.persistence.internal.oxm.VectorUtils;
import org.eclipse.persistence.platform.xml.XMLNamespaceResolver;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamespaceResolver
implements XMLNamespaceResolver {
    private static final String BASE_PREFIX = "ns";
    private static final Vector EMPTY_VECTOR = VectorUtils.emptyVector();
    private String defaultNamespaceURI;
    private NamespaceResolverStorage prefixesToNamespaces;
    private int prefixCounter;
    private Node dom;

    public NamespaceResolver() {
    }

    public NamespaceResolver(NamespaceResolver namespaceResolver) {
        this.defaultNamespaceURI = namespaceResolver.defaultNamespaceURI;
        this.setPrefixesToNamespaces(namespaceResolver.prefixesToNamespaces);
        this.prefixCounter = namespaceResolver.prefixCounter;
        this.dom = namespaceResolver.dom;
    }

    private void setPrefixesToNamespaces(Map<String, String> input) {
        if (input == null) {
            return;
        }
        this.prefixesToNamespaces = new NamespaceResolverStorage(input.size());
        this.prefixesToNamespaces.putAll((Map<? extends String, ? extends String>)input);
    }

    public Map<String, String> getPrefixesToNamespaces() {
        if (null == this.prefixesToNamespaces) {
            this.prefixesToNamespaces = new NamespaceResolverStorage();
        }
        return this.prefixesToNamespaces;
    }

    public boolean hasPrefixesToNamespaces() {
        return null != this.prefixesToNamespaces;
    }

    public boolean hasPrefix(String prefix) {
        return null != this.prefixesToNamespaces ? this.prefixesToNamespaces.containsKey(prefix) : false;
    }

    public void setDOM(Node dom) {
        this.dom = dom;
    }

    @Override
    public String resolveNamespacePrefix(String prefix) {
        if (null == prefix || prefix.length() == 0) {
            return this.defaultNamespaceURI;
        }
        String uri = null;
        if (null != this.prefixesToNamespaces) {
            uri = (String)this.prefixesToNamespaces.get(prefix);
        }
        if (null != uri) {
            return uri;
        }
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(prefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        if (this.dom != null) {
            return XMLPlatformFactory.getInstance().getXMLPlatform().resolveNamespacePrefix(this.dom, prefix);
        }
        return null;
    }

    public String resolveNamespaceURI(String uri) {
        if (null == uri) {
            return null;
        }
        if (null != this.prefixesToNamespaces) {
            for (Map.Entry<String, String> entry : this.prefixesToNamespaces.entrySet()) {
                if (!uri.equals(entry.getValue())) continue;
                return entry.getKey();
            }
        }
        if (uri.equalsIgnoreCase("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        if (uri.equalsIgnoreCase("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        return this.resolveNamespaceURI(this.dom, uri);
    }

    private String resolveNamespaceURI(Node node, String uri) {
        if (null == node) {
            return null;
        }
        if (uri.equals(node.getNamespaceURI())) {
            return node.getPrefix();
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (null != namedNodeMap) {
            int namedNodeMapSize = namedNodeMap.getLength();
            for (int x = 0; x < namedNodeMapSize; ++x) {
                Node attr = namedNodeMap.item(x);
                if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI()) || !uri.equals(attr.getNodeValue())) continue;
                if (attr.getLocalName() != null && !attr.getLocalName().equals("xmlns")) {
                    return attr.getLocalName();
                }
                return "";
            }
        }
        return this.resolveNamespaceURI(node.getParentNode(), uri);
    }

    public void put(String prefix, String namespaceURI) {
        if (null == prefix || 0 == prefix.length()) {
            this.defaultNamespaceURI = namespaceURI;
        } else {
            ArrayList removedKeys = null;
            String cachedJvmValue = namespaceURI.intern();
            if (this.getPrefixesToNamespaces().containsValue(cachedJvmValue)) {
                removedKeys = new ArrayList();
                for (Map.Entry entry : this.prefixesToNamespaces.entrySet()) {
                    if (!cachedJvmValue.equals(entry.getValue())) continue;
                    removedKeys.add(entry.getKey());
                }
            }
            if (null != removedKeys) {
                for (String string : removedKeys) {
                    this.prefixesToNamespaces.remove(string);
                }
            }
            this.prefixesToNamespaces.put(prefix, cachedJvmValue);
            if (null != removedKeys) {
                for (String string : removedKeys) {
                    this.prefixesToNamespaces.put(string, cachedJvmValue);
                }
            }
        }
    }

    public Enumeration getPrefixes() {
        if (this.hasPrefixesToNamespaces()) {
            return new IteratorEnumeration(this.getPrefixesToNamespaces().keySet().iterator());
        }
        return new IteratorEnumeration(null);
    }

    public Vector getNamespaces() {
        if (!this.hasPrefixesToNamespaces()) {
            return EMPTY_VECTOR;
        }
        return this.prefixesToNamespaces.getNamespaces();
    }

    public void setNamespaces(Vector names) {
        this.prefixesToNamespaces = new NamespaceResolverStorage(names.size());
        this.prefixesToNamespaces.setNamespaces(names);
    }

    public String generatePrefix() {
        return this.generatePrefix(this.getNextPrefix());
    }

    private String getNextPrefix() {
        return BASE_PREFIX + this.prefixCounter++;
    }

    public String generatePrefix(String defaultPrefix) {
        String lookup = this.resolveNamespacePrefix(defaultPrefix);
        while (lookup != null) {
            defaultPrefix = this.getNextPrefix();
            lookup = this.resolveNamespacePrefix(defaultPrefix);
        }
        return defaultPrefix;
    }

    public void removeNamespace(String prefix) {
        if (null != this.prefixesToNamespaces) {
            this.prefixesToNamespaces.remove(prefix);
        }
    }

    public void setDefaultNamespaceURI(String namespaceUri) {
        this.defaultNamespaceURI = namespaceUri == null ? null : namespaceUri.intern();
    }

    public String getDefaultNamespaceURI() {
        if (null != this.defaultNamespaceURI) {
            return this.defaultNamespaceURI;
        }
        if (this.dom != null) {
            return XMLPlatformFactory.getInstance().getXMLPlatform().resolveNamespacePrefix(this.dom, null);
        }
        return null;
    }

    private static class IteratorEnumeration
    implements Enumeration {
        private Iterator iterator;

        public IteratorEnumeration(Iterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasMoreElements() {
            if (null == this.iterator) {
                return false;
            }
            return this.iterator.hasNext();
        }

        public Object nextElement() {
            return this.iterator.next();
        }
    }
}

