/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.weaving;

import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.weaving.AttributeDetails;
import org.eclipse.persistence.internal.jpa.weaving.ClassDetails;
import org.eclipse.persistence.internal.jpa.weaving.MethodWeaver;
import org.eclipse.persistence.internal.libraries.asm.ClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.FieldVisitor;
import org.eclipse.persistence.internal.libraries.asm.Label;
import org.eclipse.persistence.internal.libraries.asm.MethodVisitor;
import org.eclipse.persistence.internal.libraries.asm.Opcodes;

public class ClassWeaver
extends ClassVisitor
implements Opcodes {
    public static final String PERSISTENCE_WEAVED_SHORT_SIGNATURE = "org/eclipse/persistence/internal/weaving/PersistenceWeaved";
    public static final String TW_LAZY_SHORT_SIGNATURE = "org/eclipse/persistence/internal/weaving/PersistenceWeavedLazy";
    public static final String VHI_CLASSNAME = "org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface";
    public static final String VH_SHORT_SIGNATURE = "org/eclipse/persistence/indirection/ValueHolder";
    public static final String VHI_SHORT_SIGNATURE = "org/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface";
    public static final String VHI_SIGNATURE = "Lorg/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface;";
    public static final String TW_CT_SHORT_SIGNATURE = "org/eclipse/persistence/internal/weaving/PersistenceWeavedChangeTracking";
    public static final String PCL_SHORT_SIGNATURE = "java/beans/PropertyChangeListener";
    public static final String PCL_SIGNATURE = "Ljava/beans/PropertyChangeListener;";
    public static final String CT_SHORT_SIGNATURE = "org/eclipse/persistence/descriptors/changetracking/ChangeTracker";
    public static final String PCE_SHORT_SIGNATURE = "java/beans/PropertyChangeEvent";
    public static final String PCE_SIGNATURE = "Ljava/beans/PropertyChangeEvent;";
    public static final String PERSISTENCE_ENTITY_SHORT_SIGNATURE = "org/eclipse/persistence/internal/descriptors/PersistenceEntity";
    public static final String PERSISTENCE_OBJECT_SHORT_SIGNATURE = "org/eclipse/persistence/internal/descriptors/PersistenceObject";
    public static final String PERSISTENCE_OBJECT_SIGNATURE = "Lorg/eclipse/persistence/internal/descriptors/PersistenceObject;";
    public static final String VECTOR_SIGNATURE = "Ljava/util/Vector;";
    public static final String OBJECT_SIGNATURE = "Ljava/lang/Object;";
    public static final String STRING_SIGNATURE = "Ljava/lang/String;";
    public static final String CACHEKEY_SIGNATURE = "Lorg/eclipse/persistence/internal/identitymaps/CacheKey;";
    public static final String WEAVED_FETCHGROUPS_SHORT_SIGNATURE = "org/eclipse/persistence/internal/weaving/PersistenceWeavedFetchGroups";
    public static final String FETCHGROUP_TRACKER_SIGNATURE = "Lorg/eclipse/persistence/queries/FetchGroupTracker;";
    public static final String FETCHGROUP_TRACKER_SHORT_SIGNATURE = "org/eclipse/persistence/queries/FetchGroupTracker";
    public static final String FETCHGROUP_SHORT_SIGNATURE = "org/eclipse/persistence/queries/FetchGroup";
    public static final String FETCHGROUP_SIGNATURE = "Lorg/eclipse/persistence/queries/FetchGroup;";
    public static final String SESSION_SIGNATURE = "Lorg/eclipse/persistence/sessions/Session;";
    public static final String ENTITY_MANAGER_IMPL_SHORT_SIGNATURE = "org/eclipse/persistence/internal/jpa/EntityManagerImpl";
    public static final String PBOOLEAN_SIGNATURE = "Z";
    public static final String LONG_SIGNATURE = "J";
    public static final String WEAVED_REST_LAZY_SHORT_SIGNATURE = "org/eclipse/persistence/internal/weaving/PersistenceWeavedRest";
    public static final String LIST_RELATIONSHIP_INFO_SIGNATURE = "Ljava/util/List;";
    public static final String CLONEABLE_SHORT_SIGNATURE = "java/lang/Cloneable";
    public static final String JPA_TRANSIENT_DESCRIPTION = "Ljavax/persistence/Transient;";
    public static final String XML_TRANSIENT_DESCRIPTION = "Ljavax/xml/bind/annotation/XmlTransient;";
    public static final String PERSISTENCE_SET = "_persistence_set_";
    public static final String PERSISTENCE_GET = "_persistence_get_";
    public static final String PERSISTENCE_FIELDNAME_PREFIX = "_persistence_";
    public static final String PERSISTENCE_FIELDNAME_POSTFIX = "_vh";
    public static final String VIRTUAL_GETTER_SIGNATURE = "(Ljava/lang/String;)Ljava/lang/Object;";
    public static final String VIRTUAL_SETTER_SIGNATURE = "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;";
    protected static Boolean isJAXBOnPath;
    public static final String LINK_SIGNATURE = "Lorg/eclipse/persistence/internal/jpa/rs/metadata/model/Link;";
    public static final String ITEM_LINKS_SIGNATURE = "Lorg/eclipse/persistence/internal/jpa/rs/metadata/model/ItemLinks;";
    protected ClassDetails classDetails;
    protected boolean alreadyWeaved = false;
    public boolean weaved = false;
    public boolean weavedLazy = false;
    public boolean weavedPersistenceEntity = false;
    public boolean weavedChangeTracker = false;
    public boolean weavedFetchGroups = false;
    public boolean weavedRest = false;

    public static String wrapperFor(int sort) {
        switch (sort) {
            case 1: {
                return "java/lang/Boolean";
            }
            case 3: {
                return "java/lang/Byte";
            }
            case 2: {
                return "java/lang/Character";
            }
            case 4: {
                return "java/lang/Short";
            }
            case 5: {
                return "java/lang/Integer";
            }
            case 6: {
                return "java/lang/Float";
            }
            case 7: {
                return "java/lang/Long";
            }
            case 8: {
                return "java/lang/Double";
            }
        }
        return null;
    }

    public static void unwrapPrimitive(AttributeDetails attribute, MethodVisitor visitor) {
        String wrapper = ClassWeaver.wrapperFor(attribute.getReferenceClassType().getSort());
        switch (attribute.getReferenceClassType().getSort()) {
            case 1: {
                visitor.visitMethodInsn(182, wrapper, "booleanValue", "()Z", false);
                return;
            }
            case 3: {
                visitor.visitMethodInsn(182, wrapper, "byteValue", "()B", false);
                return;
            }
            case 2: {
                visitor.visitMethodInsn(182, wrapper, "charValue", "()C", false);
                return;
            }
            case 4: {
                visitor.visitMethodInsn(182, wrapper, "shortValue", "()S", false);
                return;
            }
            case 5: {
                visitor.visitMethodInsn(182, wrapper, "intValue", "()I", false);
                return;
            }
            case 6: {
                visitor.visitMethodInsn(182, wrapper, "floatValue", "()F", false);
                return;
            }
            case 7: {
                visitor.visitMethodInsn(182, wrapper, "longValue", "()J", false);
                return;
            }
            case 8: {
                visitor.visitMethodInsn(182, wrapper, "doubleValue", "()D", false);
                return;
            }
        }
    }

    public static String getWeavedValueHolderGetMethodName(String attributeName) {
        return Helper.getWeavedValueHolderGetMethodName(attributeName);
    }

    public static String getWeavedValueHolderSetMethodName(String attributeName) {
        return Helper.getWeavedValueHolderSetMethodName(attributeName);
    }

    public static boolean isJAXBOnPath() {
        isJAXBOnPath = true;
        if (isJAXBOnPath == null) {
            try {
                Class.forName("javax.xml.bind.annotation.XmlTransient");
            }
            catch (Exception exception) {
                isJAXBOnPath = false;
            }
        }
        return isJAXBOnPath;
    }

    public ClassWeaver(ClassVisitor classWriter, ClassDetails classDetails) {
        super(327680, classWriter);
        this.classDetails = classDetails;
    }

    public void addValueHolder(AttributeDetails attributeDetails) {
        String attribute = attributeDetails.getAttributeName();
        FieldVisitor fv = this.cv.visitField(4, PERSISTENCE_FIELDNAME_PREFIX + attribute + PERSISTENCE_FIELDNAME_POSTFIX, VHI_SIGNATURE, null, null);
        if (attributeDetails.getGetterMethodName() == null || attributeDetails.getGetterMethodName().equals("") || attributeDetails.weaveTransientFieldValueHolders()) {
            fv.visitAnnotation(JPA_TRANSIENT_DESCRIPTION, true).visitEnd();
            if (ClassWeaver.isJAXBOnPath()) {
                fv.visitAnnotation(XML_TRANSIENT_DESCRIPTION, true).visitEnd();
            }
        }
        fv.visitEnd();
    }

    public void addPropertyChangeListener(boolean attributeAccess) {
        this.cv.visitField(132, "_persistence_listener", PCL_SIGNATURE, null, null);
    }

    public void addGetPropertyChangeListener(ClassDetails classDetails) {
        MethodVisitor cv_getPCL = this.cv.visitMethod(1, "_persistence_getPropertyChangeListener", "()Ljava/beans/PropertyChangeListener;", null, null);
        cv_getPCL.visitVarInsn(25, 0);
        cv_getPCL.visitFieldInsn(180, classDetails.getClassName(), "_persistence_listener", PCL_SIGNATURE);
        cv_getPCL.visitInsn(176);
        cv_getPCL.visitMaxs(0, 0);
    }

    public void addSetPropertyChangeListener(ClassDetails classDetails) {
        MethodVisitor cv_setPCL = this.cv.visitMethod(1, "_persistence_setPropertyChangeListener", "(Ljava/beans/PropertyChangeListener;)V", null, null);
        cv_setPCL.visitVarInsn(25, 0);
        cv_setPCL.visitVarInsn(25, 1);
        cv_setPCL.visitFieldInsn(181, classDetails.getClassName(), "_persistence_listener", PCL_SIGNATURE);
        cv_setPCL.visitInsn(177);
        cv_setPCL.visitMaxs(0, 0);
    }

    public void addPropertyChange(ClassDetails classDetails) {
        MethodVisitor cv_addPC = this.cv.visitMethod(1, "_persistence_propertyChange", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V", null, null);
        cv_addPC.visitVarInsn(25, 0);
        cv_addPC.visitFieldInsn(180, classDetails.getClassName(), "_persistence_listener", PCL_SIGNATURE);
        Label l0 = new Label();
        cv_addPC.visitJumpInsn(198, l0);
        cv_addPC.visitVarInsn(25, 2);
        cv_addPC.visitVarInsn(25, 3);
        cv_addPC.visitJumpInsn(165, l0);
        cv_addPC.visitVarInsn(25, 0);
        cv_addPC.visitFieldInsn(180, classDetails.getClassName(), "_persistence_listener", PCL_SIGNATURE);
        cv_addPC.visitTypeInsn(187, PCE_SHORT_SIGNATURE);
        cv_addPC.visitInsn(89);
        cv_addPC.visitVarInsn(25, 0);
        cv_addPC.visitVarInsn(25, 1);
        cv_addPC.visitVarInsn(25, 2);
        cv_addPC.visitVarInsn(25, 3);
        cv_addPC.visitMethodInsn(183, PCE_SHORT_SIGNATURE, "<init>", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V", false);
        cv_addPC.visitMethodInsn(185, PCL_SHORT_SIGNATURE, "propertyChange", "(Ljava/beans/PropertyChangeEvent;)V", true);
        cv_addPC.visitLabel(l0);
        cv_addPC.visitInsn(177);
        cv_addPC.visitMaxs(0, 0);
    }

    public void addInitializerForValueHolder(ClassDetails classDetails, AttributeDetails attributeDetails) {
        String attribute = attributeDetails.getAttributeName();
        String className = classDetails.getClassName();
        MethodVisitor cv_init_VH = this.cv.visitMethod(4, "_persistence_initialize_" + attribute + PERSISTENCE_FIELDNAME_POSTFIX, "()V", null, null);
        cv_init_VH.visitVarInsn(25, 0);
        cv_init_VH.visitFieldInsn(180, className, PERSISTENCE_FIELDNAME_PREFIX + attribute + PERSISTENCE_FIELDNAME_POSTFIX, VHI_SIGNATURE);
        Label l0 = new Label();
        cv_init_VH.visitJumpInsn(199, l0);
        cv_init_VH.visitVarInsn(25, 0);
        cv_init_VH.visitTypeInsn(187, VH_SHORT_SIGNATURE);
        cv_init_VH.visitInsn(89);
        if (attributeDetails.hasField()) {
            cv_init_VH.visitVarInsn(25, 0);
            cv_init_VH.visitFieldInsn(180, className, attribute, attributeDetails.getReferenceClassType().getDescriptor());
            cv_init_VH.visitMethodInsn(183, VH_SHORT_SIGNATURE, "<init>", "(Ljava/lang/Object;)V", false);
        } else {
            cv_init_VH.visitMethodInsn(183, VH_SHORT_SIGNATURE, "<init>", "()V", false);
        }
        cv_init_VH.visitFieldInsn(181, className, PERSISTENCE_FIELDNAME_PREFIX + attribute + PERSISTENCE_FIELDNAME_POSTFIX, VHI_SIGNATURE);
        cv_init_VH.visitVarInsn(25, 0);
        cv_init_VH.visitFieldInsn(180, className, PERSISTENCE_FIELDNAME_PREFIX + attribute + PERSISTENCE_FIELDNAME_POSTFIX, VHI_SIGNATURE);
        cv_init_VH.visitInsn(4);
        cv_init_VH.visitMethodInsn(185, VHI_SHORT_SIGNATURE, "setIsNewlyWeavedValueHolder", "(Z)V", true);
        cv_init_VH.visitLabel(l0);
        cv_init_VH.visitInsn(177);
        cv_init_VH.visitMaxs(0, 0);
    }

    public void addGetterMethodForValueHolder(ClassDetails classDetails, AttributeDetails attributeDetails) {
        String attribute = attributeDetails.getAttributeName();
        String className = classDetails.getClassName();
        MethodVisitor cv_get_VH = this.cv.visitMethod(1, PERSISTENCE_GET + attribute + PERSISTENCE_FIELDNAME_POSTFIX, "()Lorg/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface;", null, null);
        cv_get_VH.visitVarInsn(25, 0);
        cv_get_VH.visitMethodInsn(182, classDetails.getClassName(), "_persistence_initialize_" + attributeDetails.getAttributeName() + PERSISTENCE_FIELDNAME_POSTFIX, "()V", false);
        cv_get_VH.visitVarInsn(25, 0);
        cv_get_VH.visitFieldInsn(180, classDetails.getClassName(), PERSISTENCE_FIELDNAME_PREFIX + attribute + PERSISTENCE_FIELDNAME_POSTFIX, VHI_SIGNATURE);
        cv_get_VH.visitMethodInsn(185, VHI_SHORT_SIGNATURE, "isCoordinatedWithProperty", "()Z", true);
        Label l0 = new Label();
        cv_get_VH.visitJumpInsn(154, l0);
        cv_get_VH.visitVarInsn(25, 0);
        cv_get_VH.visitFieldInsn(180, classDetails.getClassName(), PERSISTENCE_FIELDNAME_PREFIX + attribute + PERSISTENCE_FIELDNAME_POSTFIX, VHI_SIGNATURE);
        cv_get_VH.visitMethodInsn(185, VHI_SHORT_SIGNATURE, "isNewlyWeavedValueHolder", "()Z", true);
        Label l1 = new Label();
        cv_get_VH.visitJumpInsn(153, l1);
        cv_get_VH.visitLabel(l0);
        cv_get_VH.visitVarInsn(25, 0);
        if (attributeDetails.getGetterMethodName() != null) {
            cv_get_VH.visitMethodInsn(182, classDetails.getClassName(), attributeDetails.getGetterMethodName(), "()L" + attributeDetails.getReferenceClassName().replace('.', '/') + ";", false);
            cv_get_VH.visitTypeInsn(192, attributeDetails.getReferenceClassName().replace('.', '/'));
        } else {
            cv_get_VH.visitMethodInsn(182, classDetails.getClassName(), PERSISTENCE_GET + attributeDetails.attributeName, "()L" + attributeDetails.getReferenceClassName().replace('.', '/') + ";", false);
        }
        cv_get_VH.visitVarInsn(58, 1);
        cv_get_VH.visitVarInsn(25, 1);
        cv_get_VH.visitVarInsn(25, 0);
        cv_get_VH.visitFieldInsn(180, classDetails.getClassName(), PERSISTENCE_FIELDNAME_PREFIX + attribute + PERSISTENCE_FIELDNAME_POSTFIX, VHI_SIGNATURE);
        cv_get_VH.visitMethodInsn(185, VHI_SHORT_SIGNATURE, "getValue", "()Ljava/lang/Object;", true);
        cv_get_VH.visitJumpInsn(165, l1);
        cv_get_VH.visitVarInsn(25, 0);
        cv_get_VH.visitVarInsn(25, 1);
        if (attributeDetails.getSetterMethodName() != null) {
            cv_get_VH.visitMethodInsn(182, classDetails.getClassName(), attributeDetails.getSetterMethodName(), "(L" + attributeDetails.getReferenceClassName().replace('.', '/') + ";)V", false);
        } else {
            cv_get_VH.visitMethodInsn(182, classDetails.getClassName(), PERSISTENCE_SET + attributeDetails.getAttributeName(), "(L" + attributeDetails.getReferenceClassName().replace('.', '/') + ";)V", false);
        }
        cv_get_VH.visitLabel(l1);
        cv_get_VH.visitVarInsn(25, 0);
        cv_get_VH.visitFieldInsn(180, className, PERSISTENCE_FIELDNAME_PREFIX + attribute + PERSISTENCE_FIELDNAME_POSTFIX, VHI_SIGNATURE);
        cv_get_VH.visitInsn(176);
        cv_get_VH.visitMaxs(0, 0);
    }

    public void addSetterMethodForValueHolder(ClassDetails classDetails, AttributeDetails attributeDetails) {
        String attribute = attributeDetails.getAttributeName();
        String className = classDetails.getClassName();
        MethodVisitor cv_set_value = this.cv.visitMethod(1, PERSISTENCE_SET + attribute + PERSISTENCE_FIELDNAME_POSTFIX, "(Lorg/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface;)V", null, null);
        cv_set_value.visitVarInsn(25, 0);
        cv_set_value.visitVarInsn(25, 1);
        cv_set_value.visitFieldInsn(181, className, PERSISTENCE_FIELDNAME_PREFIX + attribute + PERSISTENCE_FIELDNAME_POSTFIX, VHI_SIGNATURE);
        cv_set_value.visitVarInsn(25, 1);
        cv_set_value.visitMethodInsn(185, VHI_SHORT_SIGNATURE, "isInstantiated", "()Z", true);
        Label l0 = new Label();
        cv_set_value.visitJumpInsn(153, l0);
        cv_set_value.visitVarInsn(25, 0);
        if (attributeDetails.getGetterMethodName() != null) {
            cv_set_value.visitMethodInsn(182, className, attributeDetails.getGetterMethodName(), "()L" + attributeDetails.getReferenceClassName().replace('.', '/') + ";", false);
        } else {
            cv_set_value.visitMethodInsn(182, className, PERSISTENCE_GET + attributeDetails.attributeName, "()L" + attributeDetails.getReferenceClassName().replace('.', '/') + ";", false);
        }
        cv_set_value.visitVarInsn(58, 2);
        cv_set_value.visitVarInsn(25, 1);
        cv_set_value.visitMethodInsn(185, VHI_SHORT_SIGNATURE, "getValue", "()Ljava/lang/Object;", true);
        cv_set_value.visitVarInsn(58, 3);
        cv_set_value.visitVarInsn(25, 2);
        cv_set_value.visitVarInsn(25, 3);
        if (attributeDetails.getSetterMethodName() != null) {
            cv_set_value.visitJumpInsn(165, l0);
            cv_set_value.visitVarInsn(25, 0);
            cv_set_value.visitVarInsn(25, 3);
            cv_set_value.visitTypeInsn(192, attributeDetails.getReferenceClassName().replace('.', '/'));
            cv_set_value.visitMethodInsn(182, className, attributeDetails.getSetterMethodName(), "(L" + attributeDetails.getReferenceClassName().replace('.', '/') + ";)V", false);
            cv_set_value.visitLabel(l0);
        } else {
            Label l1 = new Label();
            cv_set_value.visitJumpInsn(165, l1);
            cv_set_value.visitVarInsn(25, 0);
            cv_set_value.visitVarInsn(25, 3);
            cv_set_value.visitTypeInsn(192, attributeDetails.getReferenceClassName().replace('.', '/'));
            cv_set_value.visitMethodInsn(182, className, PERSISTENCE_SET + attributeDetails.getAttributeName(), "(L" + attributeDetails.getReferenceClassName().replace('.', '/') + ";)V", false);
            cv_set_value.visitLabel(l1);
            cv_set_value.visitFrame(3, 0, null, 0, null);
            Label l2 = new Label();
            cv_set_value.visitJumpInsn(167, l2);
            cv_set_value.visitLabel(l0);
            cv_set_value.visitFrame(3, 0, null, 0, null);
            cv_set_value.visitVarInsn(25, 0);
            cv_set_value.visitInsn(1);
            cv_set_value.visitFieldInsn(181, className, attributeDetails.attributeName, attributeDetails.getReferenceClassType().getDescriptor());
            cv_set_value.visitLabel(l2);
            cv_set_value.visitFrame(3, 0, null, 0, null);
        }
        cv_set_value.visitInsn(177);
        cv_set_value.visitMaxs(0, 0);
    }

    public void addSetterMethodForFieldAccess(ClassDetails classDetails, AttributeDetails attributeDetails) {
        String attribute = attributeDetails.getAttributeName();
        MethodVisitor cv_set = this.cv.visitMethod(1, PERSISTENCE_SET + attribute, "(" + attributeDetails.getReferenceClassType().getDescriptor() + ")V", null, null);
        int opcode = attributeDetails.getReferenceClassType().getOpcode(21);
        if (classDetails.shouldWeaveFetchGroups()) {
            cv_set.visitVarInsn(25, 0);
            cv_set.visitLdcInsn(attribute);
            cv_set.visitMethodInsn(182, classDetails.getClassName(), "_persistence_checkFetchedForSet", "(Ljava/lang/String;)V", false);
        }
        if (classDetails.shouldWeaveChangeTracking()) {
            if (attributeDetails.weaveValueHolders()) {
                cv_set.visitVarInsn(25, 0);
                cv_set.visitMethodInsn(182, classDetails.getClassName(), "_persistence_initialize_" + attributeDetails.getAttributeName() + PERSISTENCE_FIELDNAME_POSTFIX, "()V", false);
                cv_set.visitVarInsn(25, 0);
                cv_set.visitVarInsn(25, 0);
                cv_set.visitFieldInsn(180, classDetails.getClassName(), PERSISTENCE_FIELDNAME_PREFIX + attribute + PERSISTENCE_FIELDNAME_POSTFIX, VHI_SIGNATURE);
                cv_set.visitMethodInsn(185, VHI_SHORT_SIGNATURE, "getValue", "()Ljava/lang/Object;", true);
                cv_set.visitTypeInsn(192, attributeDetails.getReferenceClassName().replace('.', '/'));
                cv_set.visitFieldInsn(181, classDetails.getClassName(), attribute, attributeDetails.getReferenceClassType().getDescriptor());
            }
            cv_set.visitVarInsn(25, 0);
            cv_set.visitLdcInsn(attribute);
            String wrapper = ClassWeaver.wrapperFor(attributeDetails.getReferenceClassType().getSort());
            if (wrapper != null) {
                cv_set.visitTypeInsn(187, wrapper);
                cv_set.visitInsn(89);
            }
            cv_set.visitVarInsn(25, 0);
            cv_set.visitFieldInsn(180, classDetails.getClassName(), attribute, attributeDetails.getReferenceClassType().getDescriptor());
            if (wrapper != null) {
                cv_set.visitMethodInsn(183, wrapper, "<init>", "(" + attributeDetails.getReferenceClassType().getDescriptor() + ")V", false);
                cv_set.visitTypeInsn(187, wrapper);
                cv_set.visitInsn(89);
                cv_set.visitVarInsn(opcode, 1);
                cv_set.visitMethodInsn(183, wrapper, "<init>", "(" + attributeDetails.getReferenceClassType().getDescriptor() + ")V", false);
            } else {
                cv_set.visitVarInsn(25, 1);
            }
            cv_set.visitMethodInsn(182, classDetails.getClassName(), "_persistence_propertyChange", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V", false);
        } else if (attributeDetails.weaveValueHolders()) {
            cv_set.visitVarInsn(25, 0);
            cv_set.visitMethodInsn(182, classDetails.getClassName(), "_persistence_initialize_" + attributeDetails.getAttributeName() + PERSISTENCE_FIELDNAME_POSTFIX, "()V", false);
            cv_set.visitVarInsn(25, 0);
            cv_set.visitVarInsn(25, 0);
            cv_set.visitFieldInsn(180, classDetails.getClassName(), PERSISTENCE_FIELDNAME_PREFIX + attribute + PERSISTENCE_FIELDNAME_POSTFIX, VHI_SIGNATURE);
            cv_set.visitMethodInsn(185, VHI_SHORT_SIGNATURE, "getValue", "()Ljava/lang/Object;", true);
            cv_set.visitTypeInsn(192, attributeDetails.getReferenceClassName().replace('.', '/'));
            cv_set.visitFieldInsn(181, classDetails.getClassName(), attribute, attributeDetails.getReferenceClassType().getDescriptor());
        }
        cv_set.visitVarInsn(25, 0);
        cv_set.visitVarInsn(opcode, 1);
        cv_set.visitFieldInsn(181, classDetails.getClassName(), attribute, attributeDetails.getReferenceClassType().getDescriptor());
        if (attributeDetails.weaveValueHolders()) {
            cv_set.visitVarInsn(25, 0);
            cv_set.visitFieldInsn(180, classDetails.getClassName(), PERSISTENCE_FIELDNAME_PREFIX + attribute + PERSISTENCE_FIELDNAME_POSTFIX, VHI_SIGNATURE);
            cv_set.visitVarInsn(25, 1);
            cv_set.visitMethodInsn(185, VHI_SHORT_SIGNATURE, "setValue", "(Ljava/lang/Object;)V", true);
        }
        cv_set.visitInsn(177);
        cv_set.visitMaxs(0, 0);
    }

    public void addGetterMethodForFieldAccess(ClassDetails classDetails, AttributeDetails attributeDetails) {
        String attribute = attributeDetails.getAttributeName();
        MethodVisitor cv_get = this.cv.visitMethod(1, PERSISTENCE_GET + attribute, "()" + attributeDetails.getReferenceClassType().getDescriptor(), null, null);
        if (classDetails.shouldWeaveFetchGroups()) {
            cv_get.visitVarInsn(25, 0);
            cv_get.visitLdcInsn(attribute);
            cv_get.visitMethodInsn(182, classDetails.getClassName(), "_persistence_checkFetched", "(Ljava/lang/String;)V", false);
        }
        if (attributeDetails.weaveValueHolders()) {
            cv_get.visitVarInsn(25, 0);
            cv_get.visitMethodInsn(182, classDetails.getClassName(), "_persistence_initialize_" + attributeDetails.getAttributeName() + PERSISTENCE_FIELDNAME_POSTFIX, "()V", false);
            cv_get.visitVarInsn(25, 0);
            cv_get.visitVarInsn(25, 0);
            cv_get.visitFieldInsn(180, classDetails.getClassName(), PERSISTENCE_FIELDNAME_PREFIX + attribute + PERSISTENCE_FIELDNAME_POSTFIX, VHI_SIGNATURE);
            cv_get.visitMethodInsn(185, VHI_SHORT_SIGNATURE, "getValue", "()Ljava/lang/Object;", true);
            cv_get.visitTypeInsn(192, attributeDetails.getReferenceClassName().replace('.', '/'));
            cv_get.visitFieldInsn(181, classDetails.getClassName(), attribute, attributeDetails.getReferenceClassType().getDescriptor());
        }
        cv_get.visitVarInsn(25, 0);
        cv_get.visitFieldInsn(180, classDetails.getClassName(), attribute, attributeDetails.getReferenceClassType().getDescriptor());
        int opcode = attributeDetails.getReferenceClassType().getOpcode(172);
        cv_get.visitInsn(opcode);
        cv_get.visitMaxs(0, 0);
    }

    public void addPersistenceEntityVariables() {
        this.cv.visitField(132, "_persistence_primaryKey", OBJECT_SIGNATURE, null, null);
        this.cv.visitField(132, "_persistence_cacheKey", CACHEKEY_SIGNATURE, null, null);
    }

    public void addPersistencePostClone(ClassDetails classDetails) {
        MethodVisitor cv_clone = this.cv.visitMethod(1, "_persistence_post_clone", "()Ljava/lang/Object;", null, null);
        if (classDetails.getSuperClassDetails() != null && classDetails.getSuperClassDetails().shouldWeaveInternal()) {
            cv_clone.visitVarInsn(25, 0);
            cv_clone.visitMethodInsn(183, classDetails.getSuperClassName(), "_persistence_post_clone", "()Ljava/lang/Object;", false);
        }
        if (classDetails.shouldWeaveValueHolders()) {
            for (AttributeDetails attributeDetails : classDetails.getAttributesMap().values()) {
                if (!attributeDetails.weaveValueHolders()) continue;
                cv_clone.visitVarInsn(25, 0);
                cv_clone.visitFieldInsn(180, classDetails.getClassName(), PERSISTENCE_FIELDNAME_PREFIX + attributeDetails.getAttributeName() + PERSISTENCE_FIELDNAME_POSTFIX, VHI_SIGNATURE);
                Label label = new Label();
                cv_clone.visitJumpInsn(198, label);
                cv_clone.visitVarInsn(25, 0);
                cv_clone.visitVarInsn(25, 0);
                cv_clone.visitFieldInsn(180, classDetails.getClassName(), PERSISTENCE_FIELDNAME_PREFIX + attributeDetails.getAttributeName() + PERSISTENCE_FIELDNAME_POSTFIX, VHI_SIGNATURE);
                cv_clone.visitMethodInsn(185, VHI_SHORT_SIGNATURE, "clone", "()Ljava/lang/Object;", true);
                cv_clone.visitTypeInsn(192, VHI_SHORT_SIGNATURE);
                cv_clone.visitFieldInsn(181, classDetails.getClassName(), PERSISTENCE_FIELDNAME_PREFIX + attributeDetails.getAttributeName() + PERSISTENCE_FIELDNAME_POSTFIX, VHI_SIGNATURE);
                cv_clone.visitLabel(label);
            }
        }
        if (classDetails.shouldWeaveChangeTracking()) {
            cv_clone.visitVarInsn(25, 0);
            cv_clone.visitInsn(1);
            cv_clone.visitFieldInsn(181, classDetails.getClassName(), "_persistence_listener", PCL_SIGNATURE);
        }
        if (classDetails.shouldWeaveFetchGroups()) {
            cv_clone.visitVarInsn(25, 0);
            cv_clone.visitInsn(1);
            cv_clone.visitFieldInsn(181, classDetails.getClassName(), "_persistence_fetchGroup", FETCHGROUP_SIGNATURE);
            cv_clone.visitVarInsn(25, 0);
            cv_clone.visitInsn(1);
            cv_clone.visitFieldInsn(181, classDetails.getClassName(), "_persistence_session", SESSION_SIGNATURE);
        }
        if (!classDetails.isEmbedable()) {
            cv_clone.visitVarInsn(25, 0);
            cv_clone.visitInsn(1);
            cv_clone.visitFieldInsn(181, classDetails.getClassName(), "_persistence_primaryKey", OBJECT_SIGNATURE);
        }
        cv_clone.visitVarInsn(25, 0);
        cv_clone.visitInsn(176);
        cv_clone.visitMaxs(0, 0);
    }

    public void addPersistenceRestMethods(ClassDetails classDetails) {
        MethodVisitor cv_getPKVector = this.cv.visitMethod(1, "_persistence_getRelationships", "()Ljava/util/List;", null, null);
        cv_getPKVector.visitVarInsn(25, 0);
        cv_getPKVector.visitFieldInsn(180, classDetails.getClassName(), "_persistence_relationshipInfo", LIST_RELATIONSHIP_INFO_SIGNATURE);
        cv_getPKVector.visitInsn(176);
        cv_getPKVector.visitMaxs(0, 0);
        MethodVisitor cv_setPKVector = this.cv.visitMethod(1, "_persistence_setRelationships", "(Ljava/util/List;)V", null, null);
        cv_setPKVector.visitVarInsn(25, 0);
        cv_setPKVector.visitVarInsn(25, 1);
        cv_setPKVector.visitFieldInsn(181, classDetails.getClassName(), "_persistence_relationshipInfo", LIST_RELATIONSHIP_INFO_SIGNATURE);
        cv_setPKVector.visitInsn(177);
        cv_setPKVector.visitMaxs(0, 0);
        MethodVisitor cv_getHref = this.cv.visitMethod(1, "_persistence_getHref", "()Lorg/eclipse/persistence/internal/jpa/rs/metadata/model/Link;", null, null);
        cv_getHref.visitVarInsn(25, 0);
        cv_getHref.visitFieldInsn(180, classDetails.getClassName(), "_persistence_href", LINK_SIGNATURE);
        cv_getHref.visitInsn(176);
        cv_getHref.visitMaxs(0, 0);
        MethodVisitor cv_setHref = this.cv.visitMethod(1, "_persistence_setHref", "(Lorg/eclipse/persistence/internal/jpa/rs/metadata/model/Link;)V", null, null);
        cv_setHref.visitVarInsn(25, 0);
        cv_setHref.visitVarInsn(25, 1);
        cv_setHref.visitFieldInsn(181, classDetails.getClassName(), "_persistence_href", LINK_SIGNATURE);
        cv_setHref.visitInsn(177);
        cv_setHref.visitMaxs(0, 0);
        MethodVisitor cv_getLinks = this.cv.visitMethod(1, "_persistence_getLinks", "()Lorg/eclipse/persistence/internal/jpa/rs/metadata/model/ItemLinks;", null, null);
        cv_getLinks.visitVarInsn(25, 0);
        cv_getLinks.visitFieldInsn(180, classDetails.getClassName(), "_persistence_links", ITEM_LINKS_SIGNATURE);
        cv_getLinks.visitInsn(176);
        cv_getLinks.visitMaxs(0, 0);
        MethodVisitor cv_setLinks = this.cv.visitMethod(1, "_persistence_setLinks", "(Lorg/eclipse/persistence/internal/jpa/rs/metadata/model/ItemLinks;)V", null, null);
        cv_setLinks.visitVarInsn(25, 0);
        cv_setLinks.visitVarInsn(25, 1);
        cv_setLinks.visitFieldInsn(181, classDetails.getClassName(), "_persistence_links", ITEM_LINKS_SIGNATURE);
        cv_setLinks.visitInsn(177);
        cv_setLinks.visitMaxs(0, 0);
    }

    public void addPersistenceRestVariables() {
        this.cv.visitField(132, "_persistence_relationshipInfo", LIST_RELATIONSHIP_INFO_SIGNATURE, null, null);
        this.cv.visitField(132, "_persistence_href", LINK_SIGNATURE, null, null);
        this.cv.visitField(132, "_persistence_links", ITEM_LINKS_SIGNATURE, null, null);
    }

    public void addShallowClone(ClassDetails classDetails) {
        MethodVisitor cv_clone = this.cv.visitMethod(1, "_persistence_shallow_clone", "()Ljava/lang/Object;", null, null);
        cv_clone.visitVarInsn(25, 0);
        cv_clone.visitMethodInsn(183, "java/lang/Object", "clone", "()Ljava/lang/Object;", false);
        cv_clone.visitInsn(176);
        cv_clone.visitMaxs(0, 0);
    }

    public void addPersistenceNew(ClassDetails classDetails) {
        MethodVisitor cv_new = this.cv.visitMethod(1, "_persistence_new", "(Lorg/eclipse/persistence/internal/descriptors/PersistenceObject;)Ljava/lang/Object;", null, null);
        cv_new.visitTypeInsn(187, classDetails.getClassName());
        cv_new.visitInsn(89);
        if (!classDetails.canWeaveConstructorOptimization()) {
            cv_new.visitMethodInsn(183, classDetails.getClassName(), "<init>", "()V", false);
            cv_new.visitInsn(176);
            cv_new.visitMaxs(0, 0);
            return;
        }
        cv_new.visitVarInsn(25, 1);
        cv_new.visitMethodInsn(183, classDetails.getClassName(), "<init>", "(Lorg/eclipse/persistence/internal/descriptors/PersistenceObject;)V", false);
        cv_new.visitInsn(176);
        cv_new.visitMaxs(0, 0);
        MethodVisitor cv_constructor = this.cv.visitMethod(1, "<init>", "(Lorg/eclipse/persistence/internal/descriptors/PersistenceObject;)V", null, null);
        cv_constructor.visitVarInsn(25, 0);
        if (classDetails.getSuperClassDetails() == null) {
            cv_constructor.visitMethodInsn(183, classDetails.getSuperClassName(), "<init>", "()V", false);
        } else {
            cv_constructor.visitVarInsn(25, 1);
            cv_constructor.visitMethodInsn(183, classDetails.getSuperClassName(), "<init>", "(Lorg/eclipse/persistence/internal/descriptors/PersistenceObject;)V", false);
        }
        cv_constructor.visitInsn(177);
        cv_constructor.visitMaxs(0, 0);
    }

    public void addPersistenceGetSet(ClassDetails classDetails) {
        MethodVisitor cv_get = this.cv.visitMethod(1, "_persistence_get", VIRTUAL_GETTER_SIGNATURE, null, null);
        Label label = null;
        for (AttributeDetails attributeDetails : classDetails.getAttributesMap().values()) {
            if (attributeDetails.isAttributeOnSuperClass() || attributeDetails.isVirtualProperty()) continue;
            if (label != null) {
                cv_get.visitLabel(label);
            }
            cv_get.visitVarInsn(25, 1);
            cv_get.visitLdcInsn(attributeDetails.getAttributeName().intern());
            label = new Label();
            cv_get.visitJumpInsn(166, label);
            cv_get.visitVarInsn(25, 0);
            cv_get.visitFieldInsn(180, classDetails.getClassName(), attributeDetails.getAttributeName(), attributeDetails.getReferenceClassType().getDescriptor());
            String wrapper = ClassWeaver.wrapperFor(attributeDetails.getReferenceClassType().getSort());
            if (wrapper != null) {
                cv_get.visitMethodInsn(184, wrapper, "valueOf", "(" + attributeDetails.getReferenceClassType().getDescriptor() + ")L" + wrapper + ";", false);
            }
            cv_get.visitInsn(176);
        }
        if (label != null) {
            cv_get.visitLabel(label);
        }
        if (classDetails.getSuperClassDetails() == null) {
            cv_get.visitInsn(1);
        } else {
            cv_get.visitVarInsn(25, 0);
            cv_get.visitVarInsn(25, 1);
            cv_get.visitMethodInsn(183, classDetails.getSuperClassName(), "_persistence_get", VIRTUAL_GETTER_SIGNATURE, false);
        }
        cv_get.visitInsn(176);
        cv_get.visitMaxs(0, 0);
        MethodVisitor cv_set = this.cv.visitMethod(1, "_persistence_set", "(Ljava/lang/String;Ljava/lang/Object;)V", null, null);
        label = null;
        for (AttributeDetails attribute : classDetails.getAttributesMap().values()) {
            if (attribute.isAttributeOnSuperClass() || attribute.isVirtualProperty()) continue;
            if (label != null) {
                cv_set.visitLabel(label);
            }
            cv_set.visitVarInsn(25, 1);
            cv_set.visitLdcInsn(attribute.getAttributeName().intern());
            label = new Label();
            cv_set.visitJumpInsn(166, label);
            cv_set.visitVarInsn(25, 0);
            cv_set.visitVarInsn(25, 2);
            String wrapper = ClassWeaver.wrapperFor(attribute.getReferenceClassType().getSort());
            if (wrapper == null) {
                wrapper = attribute.getReferenceClassName().replace('.', '/');
            }
            cv_set.visitTypeInsn(192, wrapper);
            ClassWeaver.unwrapPrimitive(attribute, cv_set);
            cv_set.visitFieldInsn(181, classDetails.getClassName(), attribute.getAttributeName(), attribute.getReferenceClassType().getDescriptor());
            cv_set.visitInsn(177);
        }
        if (label != null) {
            cv_set.visitLabel(label);
        }
        if (classDetails.getSuperClassDetails() != null) {
            cv_set.visitVarInsn(25, 0);
            cv_set.visitVarInsn(25, 1);
            cv_set.visitVarInsn(25, 2);
            cv_set.visitMethodInsn(183, classDetails.getSuperClassName(), "_persistence_set", "(Ljava/lang/String;Ljava/lang/Object;)V", false);
        }
        cv_set.visitInsn(177);
        cv_set.visitMaxs(0, 0);
    }

    public void addPersistenceEntityMethods(ClassDetails classDetails) {
        MethodVisitor cv_getPKVector = this.cv.visitMethod(1, "_persistence_getId", "()Ljava/lang/Object;", null, null);
        cv_getPKVector.visitVarInsn(25, 0);
        cv_getPKVector.visitFieldInsn(180, classDetails.getClassName(), "_persistence_primaryKey", OBJECT_SIGNATURE);
        cv_getPKVector.visitInsn(176);
        cv_getPKVector.visitMaxs(0, 0);
        MethodVisitor cv_setPKVector = this.cv.visitMethod(1, "_persistence_setId", "(Ljava/lang/Object;)V", null, null);
        cv_setPKVector.visitVarInsn(25, 0);
        cv_setPKVector.visitVarInsn(25, 1);
        cv_setPKVector.visitFieldInsn(181, classDetails.getClassName(), "_persistence_primaryKey", OBJECT_SIGNATURE);
        cv_setPKVector.visitInsn(177);
        cv_setPKVector.visitMaxs(0, 0);
        MethodVisitor cv_getCacheKey = this.cv.visitMethod(1, "_persistence_getCacheKey", "()Lorg/eclipse/persistence/internal/identitymaps/CacheKey;", null, null);
        cv_getCacheKey.visitVarInsn(25, 0);
        cv_getCacheKey.visitFieldInsn(180, classDetails.getClassName(), "_persistence_cacheKey", CACHEKEY_SIGNATURE);
        cv_getCacheKey.visitInsn(176);
        cv_getCacheKey.visitMaxs(0, 0);
        MethodVisitor cv_setCacheKey = this.cv.visitMethod(1, "_persistence_setCacheKey", "(Lorg/eclipse/persistence/internal/identitymaps/CacheKey;)V", null, null);
        cv_setCacheKey.visitVarInsn(25, 0);
        cv_setCacheKey.visitVarInsn(25, 1);
        cv_setCacheKey.visitFieldInsn(181, classDetails.getClassName(), "_persistence_cacheKey", CACHEKEY_SIGNATURE);
        cv_setCacheKey.visitInsn(177);
        cv_setCacheKey.visitMaxs(0, 0);
    }

    public void addFetchGroupVariables() {
        FieldVisitor fv = this.cv.visitField(4, "_persistence_fetchGroup", FETCHGROUP_SIGNATURE, null, null);
        if (this.classDetails.usesAttributeAccess()) {
            fv.visitAnnotation(JPA_TRANSIENT_DESCRIPTION, true).visitEnd();
        }
        if (ClassWeaver.isJAXBOnPath()) {
            fv.visitAnnotation(XML_TRANSIENT_DESCRIPTION, true).visitEnd();
        }
        fv.visitEnd();
        this.cv.visitField(132, "_persistence_shouldRefreshFetchGroup", PBOOLEAN_SIGNATURE, null, null).visitEnd();
        this.cv.visitField(132, "_persistence_session", SESSION_SIGNATURE, null, null).visitEnd();
    }

    public void addFetchGroupMethods(ClassDetails classDetails) {
        MethodVisitor cv_getSession = this.cv.visitMethod(1, "_persistence_getSession", "()Lorg/eclipse/persistence/sessions/Session;", null, null);
        cv_getSession.visitVarInsn(25, 0);
        cv_getSession.visitFieldInsn(180, classDetails.getClassName(), "_persistence_session", SESSION_SIGNATURE);
        cv_getSession.visitInsn(176);
        cv_getSession.visitMaxs(0, 0);
        MethodVisitor cv_setSession = this.cv.visitMethod(1, "_persistence_setSession", "(Lorg/eclipse/persistence/sessions/Session;)V", null, null);
        cv_setSession.visitVarInsn(25, 0);
        cv_setSession.visitVarInsn(25, 1);
        cv_setSession.visitFieldInsn(181, classDetails.getClassName(), "_persistence_session", SESSION_SIGNATURE);
        cv_setSession.visitInsn(177);
        cv_setSession.visitMaxs(0, 0);
        MethodVisitor cv_getFetchGroup = this.cv.visitMethod(1, "_persistence_getFetchGroup", "()Lorg/eclipse/persistence/queries/FetchGroup;", null, null);
        cv_getFetchGroup.visitVarInsn(25, 0);
        cv_getFetchGroup.visitFieldInsn(180, classDetails.getClassName(), "_persistence_fetchGroup", FETCHGROUP_SIGNATURE);
        cv_getFetchGroup.visitInsn(176);
        cv_getFetchGroup.visitMaxs(0, 0);
        MethodVisitor cv_setFetchGroup = this.cv.visitMethod(1, "_persistence_setFetchGroup", "(Lorg/eclipse/persistence/queries/FetchGroup;)V", null, null);
        cv_setFetchGroup.visitVarInsn(25, 0);
        cv_setFetchGroup.visitVarInsn(25, 1);
        cv_setFetchGroup.visitFieldInsn(181, classDetails.getClassName(), "_persistence_fetchGroup", FETCHGROUP_SIGNATURE);
        cv_setFetchGroup.visitInsn(177);
        cv_setFetchGroup.visitMaxs(0, 0);
        MethodVisitor cv_shouldRefreshFetchGroup = this.cv.visitMethod(1, "_persistence_shouldRefreshFetchGroup", "()Z", null, null);
        cv_shouldRefreshFetchGroup.visitVarInsn(25, 0);
        cv_shouldRefreshFetchGroup.visitFieldInsn(180, classDetails.getClassName(), "_persistence_shouldRefreshFetchGroup", PBOOLEAN_SIGNATURE);
        cv_shouldRefreshFetchGroup.visitInsn(172);
        cv_shouldRefreshFetchGroup.visitMaxs(0, 0);
        MethodVisitor cv_setShouldRefreshFetchGroup = this.cv.visitMethod(1, "_persistence_setShouldRefreshFetchGroup", "(Z)V", null, null);
        cv_setShouldRefreshFetchGroup.visitVarInsn(25, 0);
        cv_setShouldRefreshFetchGroup.visitVarInsn(21, 1);
        cv_setShouldRefreshFetchGroup.visitFieldInsn(181, classDetails.getClassName(), "_persistence_shouldRefreshFetchGroup", PBOOLEAN_SIGNATURE);
        cv_setShouldRefreshFetchGroup.visitInsn(177);
        cv_setShouldRefreshFetchGroup.visitMaxs(0, 0);
        MethodVisitor cv_resetFetchGroup = this.cv.visitMethod(1, "_persistence_resetFetchGroup", "()V", null, null);
        cv_resetFetchGroup.visitInsn(177);
        cv_resetFetchGroup.visitMaxs(0, 0);
        MethodVisitor cv_isAttributeFetched = this.cv.visitMethod(1, "_persistence_isAttributeFetched", "(Ljava/lang/String;)Z", null, null);
        cv_isAttributeFetched.visitVarInsn(25, 0);
        cv_isAttributeFetched.visitFieldInsn(180, classDetails.getClassName(), "_persistence_fetchGroup", FETCHGROUP_SIGNATURE);
        Label gotoTrue = new Label();
        cv_isAttributeFetched.visitJumpInsn(198, gotoTrue);
        cv_isAttributeFetched.visitVarInsn(25, 0);
        cv_isAttributeFetched.visitFieldInsn(180, classDetails.getClassName(), "_persistence_fetchGroup", FETCHGROUP_SIGNATURE);
        cv_isAttributeFetched.visitVarInsn(25, 1);
        cv_isAttributeFetched.visitMethodInsn(182, FETCHGROUP_SHORT_SIGNATURE, "containsAttributeInternal", "(Ljava/lang/String;)Z", false);
        Label gotoFalse = new Label();
        cv_isAttributeFetched.visitJumpInsn(153, gotoFalse);
        cv_isAttributeFetched.visitLabel(gotoTrue);
        cv_isAttributeFetched.visitInsn(4);
        Label gotoReturn = new Label();
        cv_isAttributeFetched.visitJumpInsn(167, gotoReturn);
        cv_isAttributeFetched.visitLabel(gotoFalse);
        cv_isAttributeFetched.visitInsn(3);
        cv_isAttributeFetched.visitLabel(gotoReturn);
        cv_isAttributeFetched.visitInsn(172);
        cv_isAttributeFetched.visitMaxs(0, 0);
        MethodVisitor cv_checkFetched = this.cv.visitMethod(1, "_persistence_checkFetched", "(Ljava/lang/String;)V", null, null);
        cv_checkFetched.visitVarInsn(25, 0);
        cv_checkFetched.visitVarInsn(25, 1);
        cv_checkFetched.visitMethodInsn(182, classDetails.getClassName(), "_persistence_isAttributeFetched", "(Ljava/lang/String;)Z", false);
        gotoReturn = new Label();
        cv_checkFetched.visitJumpInsn(154, gotoReturn);
        cv_checkFetched.visitVarInsn(25, 0);
        cv_checkFetched.visitTypeInsn(192, FETCHGROUP_TRACKER_SHORT_SIGNATURE);
        cv_checkFetched.visitVarInsn(25, 1);
        cv_checkFetched.visitMethodInsn(184, ENTITY_MANAGER_IMPL_SHORT_SIGNATURE, "processUnfetchedAttribute", "(Lorg/eclipse/persistence/queries/FetchGroupTracker;Ljava/lang/String;)V", false);
        cv_checkFetched.visitLabel(gotoReturn);
        cv_checkFetched.visitInsn(177);
        cv_checkFetched.visitMaxs(0, 0);
        MethodVisitor cv_checkFetchedForSet = this.cv.visitMethod(1, "_persistence_checkFetchedForSet", "(Ljava/lang/String;)V", null, null);
        cv_checkFetchedForSet.visitVarInsn(25, 0);
        cv_checkFetchedForSet.visitVarInsn(25, 1);
        cv_checkFetchedForSet.visitMethodInsn(182, classDetails.getClassName(), "_persistence_isAttributeFetched", "(Ljava/lang/String;)Z", false);
        gotoReturn = new Label();
        cv_checkFetchedForSet.visitJumpInsn(154, gotoReturn);
        cv_checkFetchedForSet.visitVarInsn(25, 0);
        cv_checkFetchedForSet.visitTypeInsn(192, FETCHGROUP_TRACKER_SHORT_SIGNATURE);
        cv_checkFetchedForSet.visitVarInsn(25, 1);
        cv_checkFetchedForSet.visitMethodInsn(184, ENTITY_MANAGER_IMPL_SHORT_SIGNATURE, "processUnfetchedAttributeForSet", "(Lorg/eclipse/persistence/queries/FetchGroupTracker;Ljava/lang/String;)V", false);
        cv_checkFetchedForSet.visitLabel(gotoReturn);
        cv_checkFetchedForSet.visitInsn(177);
        cv_checkFetchedForSet.visitMaxs(0, 0);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        boolean weaveRest;
        boolean fetchGroupTracker;
        boolean persistenceEntity;
        boolean weaveCloneable = true;
        int index = 0;
        while (index < interfaces.length) {
            String existingInterface = interfaces[index];
            if (PERSISTENCE_WEAVED_SHORT_SIGNATURE.equals(existingInterface)) {
                this.alreadyWeaved = true;
                super.visit(version, access, name, signature, superName, interfaces);
                return;
            }
            if (CT_SHORT_SIGNATURE.equals(existingInterface)) {
                this.classDetails.setShouldWeaveChangeTracking(false);
            } else if (CLONEABLE_SHORT_SIGNATURE.equals(existingInterface)) {
                weaveCloneable = false;
            }
            ++index;
        }
        int newInterfacesLength = interfaces.length;
        int cloneableIndex = 0;
        boolean bl = weaveCloneable = this.classDetails.shouldWeaveInternal() && weaveCloneable && this.classDetails.getSuperClassDetails() == null;
        if (weaveCloneable) {
            cloneableIndex = newInterfacesLength++;
        }
        int persistenceWeavedIndex = newInterfacesLength++;
        int persistenceEntityIndex = 0;
        boolean bl2 = persistenceEntity = this.classDetails.shouldWeaveInternal() && this.classDetails.getSuperClassDetails() == null && !this.classDetails.isEmbedable();
        if (persistenceEntity) {
            persistenceEntityIndex = newInterfacesLength++;
        }
        int persistenceObjectIndex = 0;
        boolean persistenceObject = this.classDetails.shouldWeaveInternal();
        if (persistenceObject) {
            persistenceObjectIndex = newInterfacesLength++;
        }
        int fetchGroupTrackerIndex = 0;
        boolean bl3 = fetchGroupTracker = this.classDetails.shouldWeaveFetchGroups() && this.classDetails.getSuperClassDetails() == null;
        if (fetchGroupTracker) {
            fetchGroupTrackerIndex = newInterfacesLength++;
        }
        int persistenceWeavedFetchGroupsIndex = 0;
        if (this.classDetails.shouldWeaveFetchGroups()) {
            persistenceWeavedFetchGroupsIndex = newInterfacesLength++;
        }
        int persistenceWeavedLazyIndex = 0;
        if (this.classDetails.shouldWeaveValueHolders()) {
            persistenceWeavedLazyIndex = newInterfacesLength++;
        }
        boolean changeTracker = !this.classDetails.doesSuperclassWeaveChangeTracking() && this.classDetails.shouldWeaveChangeTracking();
        int persistenceWeavedChangeTrackingIndex = 0;
        int changeTrackerIndex = 0;
        if (changeTracker) {
            changeTrackerIndex = newInterfacesLength++;
        }
        if (this.classDetails.shouldWeaveChangeTracking()) {
            persistenceWeavedChangeTrackingIndex = newInterfacesLength++;
        }
        int persistenceWeavedRestIndex = 0;
        boolean bl4 = weaveRest = this.classDetails.shouldWeaveREST() && this.classDetails.getSuperClassDetails() == null;
        if (weaveRest) {
            persistenceWeavedRestIndex = newInterfacesLength++;
        }
        String[] newInterfaces = new String[newInterfacesLength];
        System.arraycopy(interfaces, 0, newInterfaces, 0, interfaces.length);
        newInterfaces[persistenceWeavedIndex] = PERSISTENCE_WEAVED_SHORT_SIGNATURE;
        this.weaved = true;
        if (weaveCloneable) {
            newInterfaces[cloneableIndex] = CLONEABLE_SHORT_SIGNATURE;
        }
        if (persistenceEntity) {
            newInterfaces[persistenceEntityIndex] = PERSISTENCE_ENTITY_SHORT_SIGNATURE;
        }
        if (persistenceObject) {
            newInterfaces[persistenceObjectIndex] = PERSISTENCE_OBJECT_SHORT_SIGNATURE;
        }
        if (fetchGroupTracker) {
            newInterfaces[fetchGroupTrackerIndex] = FETCHGROUP_TRACKER_SHORT_SIGNATURE;
        }
        if (this.classDetails.shouldWeaveFetchGroups()) {
            newInterfaces[persistenceWeavedFetchGroupsIndex] = WEAVED_FETCHGROUPS_SHORT_SIGNATURE;
        }
        if (this.classDetails.shouldWeaveValueHolders()) {
            newInterfaces[persistenceWeavedLazyIndex] = TW_LAZY_SHORT_SIGNATURE;
        }
        if (changeTracker) {
            newInterfaces[changeTrackerIndex] = CT_SHORT_SIGNATURE;
        }
        if (this.classDetails.shouldWeaveChangeTracking()) {
            newInterfaces[persistenceWeavedChangeTrackingIndex] = TW_CT_SHORT_SIGNATURE;
        }
        if (weaveRest) {
            newInterfaces[persistenceWeavedRestIndex] = WEAVED_REST_LAZY_SHORT_SIGNATURE;
        }
        String newSignature = null;
        if (signature != null) {
            StringBuffer newSignatureBuf = new StringBuffer();
            newSignatureBuf.append(signature);
            int i = interfaces.length;
            while (i < newInterfaces.length) {
                newSignatureBuf.append("L" + newInterfaces[i] + ";");
                ++i;
            }
            newSignature = newSignatureBuf.toString();
        }
        this.cv.visit(version, access, name, newSignature, superName, newInterfaces);
    }

    @Override
    public MethodVisitor visitMethod(int access, String methodName, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, methodName, desc, signature, exceptions);
        if (!(this.alreadyWeaved || "<init>".equals(methodName) || "<cinit>".equals(methodName))) {
            mv = new MethodWeaver(this, methodName, desc, mv);
        }
        return mv;
    }

    @Override
    public void visitEnd() {
        if (!this.alreadyWeaved) {
            if (this.classDetails.shouldWeaveInternal()) {
                this.addPersistencePostClone(this.classDetails);
                if (this.classDetails.getSuperClassDetails() == null) {
                    this.addShallowClone(this.classDetails);
                    if (!this.classDetails.isEmbedable()) {
                        this.addPersistenceEntityVariables();
                        this.addPersistenceEntityMethods(this.classDetails);
                        this.weavedPersistenceEntity = true;
                    }
                }
                this.addPersistenceNew(this.classDetails);
                this.addPersistenceGetSet(this.classDetails);
            }
            boolean attributeAccess = false;
            for (AttributeDetails attributeDetails : this.classDetails.getAttributesMap().values()) {
                if (attributeDetails.isAttributeOnSuperClass()) continue;
                if (attributeDetails.weaveValueHolders() && !attributeDetails.isAttributeOnSuperClass()) {
                    this.weaved = true;
                    this.weavedLazy = true;
                    this.addValueHolder(attributeDetails);
                    this.addInitializerForValueHolder(this.classDetails, attributeDetails);
                    this.addGetterMethodForValueHolder(this.classDetails, attributeDetails);
                    this.addSetterMethodForValueHolder(this.classDetails, attributeDetails);
                }
                if (!this.classDetails.shouldWeaveChangeTracking() && !this.classDetails.shouldWeaveFetchGroups() && !attributeDetails.weaveValueHolders() || !attributeDetails.hasField()) continue;
                this.weaved = true;
                this.addGetterMethodForFieldAccess(this.classDetails, attributeDetails);
                this.addSetterMethodForFieldAccess(this.classDetails, attributeDetails);
                attributeAccess = true;
            }
            if (this.classDetails.shouldWeaveChangeTracking()) {
                this.weaved = true;
                this.weavedChangeTracker = true;
                if (this.classDetails.getSuperClassDetails() == null || !this.classDetails.doesSuperclassWeaveChangeTracking()) {
                    this.addPropertyChangeListener(attributeAccess);
                    this.addGetPropertyChangeListener(this.classDetails);
                    this.addSetPropertyChangeListener(this.classDetails);
                    this.addPropertyChange(this.classDetails);
                }
            }
            if (this.classDetails.shouldWeaveFetchGroups()) {
                this.weaved = true;
                this.weavedFetchGroups = true;
                if (this.classDetails.getSuperClassDetails() == null) {
                    this.addFetchGroupVariables();
                    this.addFetchGroupMethods(this.classDetails);
                }
            }
        }
        if (this.classDetails.shouldWeaveREST() && this.classDetails.getSuperClassDetails() == null) {
            this.weavedRest = true;
            this.addPersistenceRestVariables();
            this.addPersistenceRestMethods(this.classDetails);
        }
        this.cv.visitEnd();
    }
}

