/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.features.paging;

import java.lang.reflect.Field;
import javax.ws.rs.core.UriInfo;
import org.eclipse.persistence.jpa.rs.annotations.RestPageable;
import org.eclipse.persistence.jpa.rs.exceptions.JPARSException;
import org.eclipse.persistence.jpa.rs.features.paging.AbstractPagingValidator;

public final class PageableFieldValidator
extends AbstractPagingValidator {
    private final Class entityClass;
    private final String fieldName;

    public PageableFieldValidator(Class entityClass, String fieldName, UriInfo uri) {
        super(uri);
        this.entityClass = entityClass;
        this.fieldName = fieldName;
    }

    @Override
    public boolean isFeatureApplicable() throws JPARSException {
        RestPageable paginationData = this.getPaginationData();
        if (paginationData != null) {
            this.checkParameters(paginationData.limit());
            return true;
        }
        if (this.queryParameters.containsKey("limit") || this.queryParameters.containsKey("offset")) {
            throw JPARSException.paginationParameterForNotPageableResource();
        }
        return false;
    }

    private RestPageable getPaginationData() {
        try {
            Field fld = this.entityClass.getDeclaredField(this.fieldName);
            if (fld.isAnnotationPresent(RestPageable.class)) {
                return fld.getAnnotation(RestPageable.class);
            }
            return null;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }
}

