/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence;

import org.eclipse.persistence.internal.helper.JavaSEPlatform;

public class Version {
    private static final String CopyrightString = "Copyright (c) 1998, 2014 Oracle.  All rights reserved.";
    private static String product = "Eclipse Persistence Services";
    private static final String version = "2.6.5";
    private static final String qualifier = "v20170523-818b57c";
    private static final String buildDate = "20170523";
    private static final String buildTime = "0014";
    private static final String buildRevision = "NA";
    private static final String buildType = "SNAPSHOT";
    private static final char SEPARATOR = '.';
    @Deprecated
    public static final int JDK_VERSION_NOT_SET = 0;
    @Deprecated
    public static final int JDK_1_5 = 1;
    @Deprecated
    public static final int JDK_1_6 = 2;
    @Deprecated
    public static final int JDK_1_7 = 3;
    @Deprecated
    public static final int JDK_1_8 = 4;
    @Deprecated
    public static final int JDK_1_9 = 5;
    @Deprecated
    public static int JDK_VERSION = 0;

    public static String getVersionString() {
        StringBuilder sb = new StringBuilder(version.length() + 1 + qualifier.length());
        sb.append(version);
        sb.append('.');
        sb.append(qualifier);
        return sb.toString();
    }

    public static String getProduct() {
        return product;
    }

    public static void setProduct(String ProductName) {
        product = ProductName;
    }

    public static String getVersion() {
        return version;
    }

    public static String getQualifier() {
        return qualifier;
    }

    public static String getBuildNumber() {
        return Version.getBuildDate();
    }

    public static String getBuildDate() {
        return buildDate;
    }

    public static String getBuildTime() {
        return buildTime;
    }

    public static String getBuildRevision() {
        return buildRevision;
    }

    public static String getBuildType() {
        return buildType;
    }

    @Deprecated
    public static int getJDKVersion() {
        switch (JavaSEPlatform.CURRENT) {
            case v1_7: {
                JDK_VERSION = 3;
                break;
            }
            case v1_8: {
                JDK_VERSION = 4;
                break;
            }
            case v1_9: 
            case v9_0: {
                JDK_VERSION = 5;
                break;
            }
            default: {
                throw new IllegalStateException("Running on unsupported Java SE: " + JavaSEPlatform.CURRENT.toString());
            }
        }
        return JDK_VERSION;
    }

    @Deprecated
    public static void useJDK15() {
        throw new UnsupportedOperationException("Java SE 1.5 is not supported by current EclipseLink.");
    }

    @Deprecated
    public static void useJDK16() {
        throw new UnsupportedOperationException("Java SE 1.6 is not supported by current EclipseLink.");
    }

    public static boolean isJDK15() {
        return JavaSEPlatform.is(JavaSEPlatform.v1_5);
    }

    public static boolean isJDK16() {
        return JavaSEPlatform.is(JavaSEPlatform.v1_6);
    }

    public static boolean isJDK17() {
        return JavaSEPlatform.is(JavaSEPlatform.v1_7);
    }

    public static boolean isJDK18() {
        return JavaSEPlatform.is(JavaSEPlatform.v1_8);
    }

    public static boolean isJDK19() {
        return JavaSEPlatform.is(JavaSEPlatform.v9_0) || JavaSEPlatform.is(JavaSEPlatform.v1_9);
    }

    public static void printVersion() {
        System.out.println(Version.getVersionString());
    }

    public static void main(String[] args) {
        System.out.println("\n" + Version.getProduct() + " (EclipseLink)" + "\n   Build Version:   " + Version.getVersionString() + "\n   Build Qualifier: " + Version.getQualifier() + "\n   Build Date:      " + Version.getBuildDate() + "\n   Build Time:      " + Version.getBuildTime() + "\n   SVN Revision:    " + Version.getBuildRevision());
    }
}

