/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.client.transport;

import io.netty.channel.Channel;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.eclipse.milo.opcua.stack.client.UaStackClientConfig;
import org.eclipse.milo.opcua.stack.client.transport.UaTransport;
import org.eclipse.milo.opcua.stack.client.transport.UaTransportRequest;
import org.eclipse.milo.opcua.stack.core.Stack;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTransport
implements UaTransport {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final HashedWheelTimer wheelTimer;
    private final UaStackClientConfig config;

    public AbstractTransport(UaStackClientConfig config) {
        this.config = config;
        this.wheelTimer = config.getWheelTimer();
    }

    public UaStackClientConfig getConfig() {
        return this.config;
    }

    public abstract CompletableFuture<Channel> channel();

    @Override
    public CompletableFuture<UaResponseMessage> sendRequest(UaRequestMessage request) {
        return this.channel().thenCompose(channel -> this.sendRequest(request, (Channel)channel, true));
    }

    protected CompletableFuture<UaResponseMessage> sendRequest(UaRequestMessage request, Channel channel, boolean firstAttempt) {
        UaTransportRequest transportRequest = new UaTransportRequest(request);
        this.scheduleRequestTimeout(transportRequest);
        transportRequest.getFuture().whenComplete((response, ex) -> this.cancelRequestTimeout(transportRequest));
        channel.writeAndFlush((Object)transportRequest).addListener(f -> {
            if (!f.isSuccess()) {
                Throwable cause = f.cause();
                if (cause instanceof ClosedChannelException && firstAttempt) {
                    this.logger.debug("Write failed, channel closed; retrying...");
                    Stack.sharedScheduledExecutor().schedule(() -> this.config.getExecutor().execute(() -> {
                        CompletionStage sendAgain = this.channel().thenCompose(ch -> this.sendRequest(request, (Channel)ch, false));
                        ((CompletableFuture)sendAgain).whenComplete((r, ex) -> {
                            if (r != null) {
                                transportRequest.getFuture().complete((UaResponseMessage)r);
                            } else {
                                transportRequest.getFuture().completeExceptionally((Throwable)ex);
                            }
                        });
                    }), 1L, TimeUnit.SECONDS);
                } else {
                    transportRequest.getFuture().completeExceptionally(cause);
                    this.logger.debug("Write failed, request={}, requestHandle={}", (Object)request.getClass().getSimpleName(), (Object)request.getRequestHeader().getRequestHandle());
                }
            } else if (this.logger.isTraceEnabled()) {
                this.logger.trace("Write succeeded for request={}, requestHandle={}", (Object)request.getClass().getSimpleName(), (Object)request.getRequestHeader().getRequestHandle());
            }
        });
        return transportRequest.getFuture();
    }

    private void scheduleRequestTimeout(UaTransportRequest transportRequest) {
        long timeoutHint;
        RequestHeader requestHeader = transportRequest.getRequest().getRequestHeader();
        long l = timeoutHint = requestHeader.getTimeoutHint() != null ? requestHeader.getTimeoutHint().longValue() : 0L;
        if (timeoutHint > 0L) {
            Timeout timeout = this.wheelTimer.newTimeout(t -> {
                UaException exception = new UaException(0x800A0000L, String.format("requestId=%s timed out after %sms", requestHeader.getRequestHandle(), timeoutHint));
                transportRequest.getFuture().completeExceptionally(exception);
            }, timeoutHint, TimeUnit.MILLISECONDS);
            transportRequest.setTimeout(timeout);
        }
    }

    private void cancelRequestTimeout(UaTransportRequest transportRequest) {
        Timeout timeout = transportRequest.getTimeout();
        if (timeout != null) {
            timeout.cancel();
        }
    }
}

