/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.server.transport.uasc;

import com.google.common.primitives.Ints;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.AttributeKey;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.milo.opcua.stack.core.Stack;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.channel.ChannelParameters;
import org.eclipse.milo.opcua.stack.core.channel.EncodingLimits;
import org.eclipse.milo.opcua.stack.core.channel.ExceptionHandler;
import org.eclipse.milo.opcua.stack.core.channel.SerializationQueue;
import org.eclipse.milo.opcua.stack.core.channel.headers.HeaderDecoder;
import org.eclipse.milo.opcua.stack.core.channel.messages.AcknowledgeMessage;
import org.eclipse.milo.opcua.stack.core.channel.messages.ErrorMessage;
import org.eclipse.milo.opcua.stack.core.channel.messages.HelloMessage;
import org.eclipse.milo.opcua.stack.core.channel.messages.MessageType;
import org.eclipse.milo.opcua.stack.core.channel.messages.TcpMessageDecoder;
import org.eclipse.milo.opcua.stack.core.channel.messages.TcpMessageEncoder;
import org.eclipse.milo.opcua.stack.core.transport.TransportProfile;
import org.eclipse.milo.opcua.stack.core.util.EndpointUtil;
import org.eclipse.milo.opcua.stack.server.UaStackServer;
import org.eclipse.milo.opcua.stack.server.transport.uasc.UascServerAsymmetricHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UascServerHelloHandler
extends ByteToMessageDecoder
implements HeaderDecoder {
    static final AttributeKey<String> ENDPOINT_URL_KEY = AttributeKey.valueOf("endpoint-url");
    public static final AtomicLong CUMULATIVE_DEADLINES_MISSED = new AtomicLong(0L);
    private static final int MAX_HELLO_MESSAGE_SIZE = 4128;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile boolean receivedHello = false;
    private final UaStackServer stackServer;
    private final TransportProfile transportProfile;

    public UascServerHelloHandler(UaStackServer stackServer, TransportProfile transportProfile) {
        if (transportProfile != TransportProfile.TCP_UASC_UABINARY && transportProfile != TransportProfile.WSS_UASC_UABINARY) {
            throw new IllegalArgumentException("transportProfile: " + (Object)((Object)transportProfile));
        }
        this.stackServer = stackServer;
        this.transportProfile = transportProfile;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        int helloDeadlineMs = Stack.ConnectionLimits.HELLO_DEADLINE_MS;
        this.logger.debug("Scheduling Hello deadline for +" + helloDeadlineMs + "ms");
        ctx.executor().schedule(() -> {
            if (!this.receivedHello) {
                long cumulativeDeadlinesMissed = CUMULATIVE_DEADLINES_MISSED.incrementAndGet();
                this.logger.debug("No Hello received after " + helloDeadlineMs + "ms; closing channel. cumulativeDeadlinesMissed=" + cumulativeDeadlinesMissed);
                ctx.close();
            }
        }, (long)helloDeadlineMs, TimeUnit.MILLISECONDS);
        super.channelActive(ctx);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        if (buffer.readableBytes() >= 8) {
            int messageLength = this.getMessageLength(buffer, 4128);
            if (buffer.readableBytes() >= messageLength) {
                MessageType messageType = MessageType.fromMediumInt(buffer.getMediumLE(buffer.readerIndex()));
                if (messageType == MessageType.Hello) {
                    this.onHello(ctx, buffer.readSlice(messageLength));
                } else {
                    throw new UaException(2155741184L, "unexpected MessageType: " + (Object)((Object)messageType));
                }
            }
        }
    }

    private void onHello(ChannelHandlerContext ctx, ByteBuf buffer) throws UaException {
        boolean endpointMatch;
        this.logger.debug("[remote={}] Received Hello message.", (Object)ctx.channel().remoteAddress());
        this.receivedHello = true;
        HelloMessage hello = TcpMessageDecoder.decodeHello(buffer);
        String endpointUrl = hello.getEndpointUrl();
        boolean bl = endpointMatch = endpointUrl != null && this.stackServer.getEndpointDescriptions().stream().anyMatch(endpoint -> Objects.equals(EndpointUtil.getPath(endpointUrl), EndpointUtil.getPath(endpoint.getEndpointUrl())));
        if (!endpointMatch) {
            throw new UaException(0x80830000L, "unrecognized endpoint url: " + endpointUrl);
        }
        ctx.channel().attr(ENDPOINT_URL_KEY).set(endpointUrl);
        long remoteProtocolVersion = hello.getProtocolVersion();
        long remoteReceiveBufferSize = hello.getReceiveBufferSize();
        long remoteSendBufferSize = hello.getSendBufferSize();
        long remoteMaxMessageSize = hello.getMaxMessageSize();
        long remoteMaxChunkCount = hello.getMaxChunkCount();
        if (remoteProtocolVersion < 0L) {
            throw new UaException(2159935488L, "unsupported protocol version: " + remoteProtocolVersion);
        }
        EncodingLimits config = this.stackServer.getConfig().getEncodingLimits();
        long localReceiveBufferSize = Math.min(remoteSendBufferSize, (long)config.getMaxChunkSize());
        long localSendBufferSize = Math.min(remoteReceiveBufferSize, (long)config.getMaxChunkSize());
        long localMaxChunkCount = config.getMaxChunkCount();
        long localMaxMessageSize = Math.min(localReceiveBufferSize * localMaxChunkCount, (long)config.getMaxMessageSize());
        ChannelParameters parameters = new ChannelParameters(Ints.saturatedCast(localMaxMessageSize), Ints.saturatedCast(localReceiveBufferSize), Ints.saturatedCast(localSendBufferSize), Ints.saturatedCast(localMaxChunkCount), Ints.saturatedCast(remoteMaxMessageSize), Ints.saturatedCast(remoteReceiveBufferSize), Ints.saturatedCast(remoteSendBufferSize), Ints.saturatedCast(remoteMaxChunkCount));
        SerializationQueue serializationQueue = new SerializationQueue(this.stackServer.getConfig().getExecutor(), parameters, this.stackServer.getSerializationContext());
        ctx.pipeline().addLast(new UascServerAsymmetricHandler(this.stackServer, this.transportProfile, serializationQueue));
        ctx.pipeline().remove(this);
        this.logger.debug("[remote={}] Removed HelloHandler, added AsymmetricHandler.", (Object)ctx.channel().remoteAddress());
        AcknowledgeMessage acknowledge = new AcknowledgeMessage(0L, localReceiveBufferSize, localSendBufferSize, localMaxMessageSize, localMaxChunkCount);
        ByteBuf messageBuffer = TcpMessageEncoder.encode(acknowledge);
        ctx.executor().execute(() -> ctx.writeAndFlush(messageBuffer));
        this.logger.debug("[remote={}] Sent Acknowledge message.", (Object)ctx.channel().remoteAddress());
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof IOException) {
            ctx.close();
            this.logger.debug("[remote={}] IOException caught; channel closed", (Object)ctx.channel().remoteAddress(), (Object)cause);
        } else {
            ErrorMessage errorMessage = ExceptionHandler.sendErrorMessage(ctx, cause);
            if (cause instanceof UaException) {
                this.logger.debug("[remote={}] UaException caught; sent {}", ctx.channel().remoteAddress(), errorMessage, cause);
            } else {
                this.logger.error("[remote={}] Exception caught; sent {}", ctx.channel().remoteAddress(), errorMessage, cause);
            }
        }
    }
}

