/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.server.transport.tcp;

import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import org.eclipse.milo.opcua.stack.core.transport.TransportProfile;
import org.eclipse.milo.opcua.stack.server.UaStackServer;
import org.eclipse.milo.opcua.stack.server.transport.RateLimitingHandler;
import org.eclipse.milo.opcua.stack.server.transport.uasc.UascServerHelloHandler;

public class OpcServerTcpChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private final UaStackServer stackServer;

    public OpcServerTcpChannelInitializer(UaStackServer stackServer) {
        this.stackServer = stackServer;
    }

    @Override
    protected void initChannel(SocketChannel channel) {
        this.stackServer.registerConnectedChannel(channel);
        channel.closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> this.stackServer.unregisterConnectedChannel(channel)));
        channel.pipeline().addLast(RateLimitingHandler.getInstance());
        channel.pipeline().addLast(new UascServerHelloHandler(this.stackServer, TransportProfile.TCP_UASC_UABINARY));
    }
}

