/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.server.transport;

import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ipfilter.AbstractRemoteAddressFilter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.milo.opcua.stack.core.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class RateLimitingHandler
extends AbstractRemoteAddressFilter<InetSocketAddress> {
    public static final AtomicLong CUMULATIVE_CONNECTIONS_REJECTED = new AtomicLong(0L);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Multiset<InetAddress> connections = ConcurrentHashMultiset.create();
    private final ConcurrentMap<InetAddress, LinkedList<Long>> timestamps = Maps.newConcurrentMap();
    private final boolean enabled;
    private final int maxAttempts;
    private final int rateLimitWindowMs;
    private final int maxConnections;
    private final int maxConnectionsPerAddress;

    public static RateLimitingHandler getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private RateLimitingHandler(boolean enabled, int maxAttempts, int rateLimitWindowMs, int maxConnections, int maxConnectionsPerAddress) {
        this.enabled = enabled;
        this.maxAttempts = maxAttempts;
        this.rateLimitWindowMs = rateLimitWindowMs;
        this.maxConnections = maxConnections;
        this.maxConnectionsPerAddress = maxConnectionsPerAddress;
        this.logger.debug(String.format("enabled=%s, maxAttempts=%s, rateLimitWindowMs=%s, maxConnections=%s, maxConnectionsPerAddress=%s", enabled, maxAttempts, rateLimitWindowMs, maxConnections, maxConnectionsPerAddress));
    }

    @Override
    protected synchronized boolean accept(ChannelHandlerContext ctx, InetSocketAddress isa) {
        InetAddress address = isa.getAddress();
        if (!this.enabled || address.isLoopbackAddress()) {
            return true;
        }
        LinkedList attempts = this.timestamps.computeIfAbsent(address, ia -> new LinkedList());
        long now = System.currentTimeMillis();
        if (attempts.size() >= this.maxAttempts) {
            boolean accept;
            int attemptsInWindow = 0;
            for (Long ts : attempts) {
                if (now - ts >= (long)this.rateLimitWindowMs) continue;
                ++attemptsInWindow;
            }
            attempts.addLast(now);
            while (attempts.size() > this.maxAttempts) {
                attempts.removeFirst();
            }
            int connectionsTotal = this.connections.size();
            int connectionsFromAddress = this.connections.count(address);
            boolean bl = accept = attemptsInWindow < this.maxAttempts && connectionsTotal < this.maxConnections && connectionsFromAddress < this.maxConnectionsPerAddress;
            if (accept) {
                this.logger.debug(String.format("Accepting connection from %s. window=%sms, attemptsInWindow=%s, connectionsTotal=%s, connectionsFromAddress=%s", isa, this.rateLimitWindowMs, attemptsInWindow, connectionsTotal, connectionsFromAddress));
            } else {
                this.logger.debug(String.format("Rejecting connection from %s. window=%sms, attemptsInWindow=%s, connectionsTotal=%s, connectionsFromAddress=%s", isa, this.rateLimitWindowMs, attemptsInWindow, connectionsTotal, connectionsFromAddress));
                long cumulativeConnectionsRejected = CUMULATIVE_CONNECTIONS_REJECTED.incrementAndGet();
                this.logger.debug("cumulativeConnectionsRejected=" + cumulativeConnectionsRejected);
            }
            return accept;
        }
        attempts.addLast(now);
        return true;
    }

    @Override
    protected void channelAccepted(ChannelHandlerContext ctx, InetSocketAddress remoteAddress) {
        InetAddress address = remoteAddress.getAddress();
        if (!this.enabled || address.isLoopbackAddress()) {
            return;
        }
        this.connections.add(address);
        ctx.channel().closeFuture().addListener(future -> {
            this.connections.remove(address);
            if (this.connections.count(address) == 0) {
                this.logger.debug("Scheduling timestamp removal for " + address);
                ctx.executor().schedule(() -> {
                    if (this.connections.count(address) == 0) {
                        this.timestamps.remove(address);
                        this.logger.debug("Removed timestamps for " + address);
                    }
                }, (long)this.rateLimitWindowMs, TimeUnit.MILLISECONDS);
            }
        });
    }

    private static class InstanceHolder {
        private static final RateLimitingHandler INSTANCE = new RateLimitingHandler(Stack.ConnectionLimits.RATE_LIMIT_ENABLED, Stack.ConnectionLimits.RATE_LIMIT_MAX_ATTEMPTS, Stack.ConnectionLimits.RATE_LIMIT_WINDOW_MS, Stack.ConnectionLimits.RATE_LIMIT_MAX_CONNECTIONS, Stack.ConnectionLimits.RATE_LIMIT_MAX_CONNECTIONS_PER_ADDRESS);

        private InstanceHolder() {
        }
    }
}

