/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.server.security;

import com.google.common.collect.ImmutableSet;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.security.TrustListManager;
import org.eclipse.milo.opcua.stack.core.util.validation.CertificateValidationUtil;
import org.eclipse.milo.opcua.stack.core.util.validation.ValidationCheck;
import org.eclipse.milo.opcua.stack.server.security.ServerCertificateValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServerCertificateValidator
implements ServerCertificateValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultServerCertificateValidator.class);
    private final TrustListManager trustListManager;
    private final ImmutableSet<ValidationCheck> validationChecks;

    public DefaultServerCertificateValidator(TrustListManager trustListManager) {
        this(trustListManager, ValidationCheck.NO_OPTIONAL_CHECKS);
    }

    public DefaultServerCertificateValidator(TrustListManager trustListManager, Set<ValidationCheck> validationChecks) {
        this.trustListManager = trustListManager;
        this.validationChecks = ImmutableSet.copyOf(validationChecks);
    }

    @Override
    public void validateCertificateChain(List<X509Certificate> certificateChain) throws UaException {
        PKIXCertPathBuilderResult certPathResult;
        try {
            certPathResult = CertificateValidationUtil.buildTrustedCertPath(certificateChain, this.trustListManager.getTrustedCertificates(), this.trustListManager.getIssuerCertificates());
        }
        catch (UaException e) {
            certificateChain.forEach(this.trustListManager::addRejectedCertificate);
            long statusCode = e.getStatusCode().getValue();
            LOGGER.debug("validateCertificateChain failed, underlying status: {}", (Object)statusCode, (Object)e);
            if (statusCode == 2149187584L) {
                throw new UaException(2148728832L);
            }
            throw new UaException(e.getStatusCode());
        }
        try {
            ArrayList<X509CRL> crls = new ArrayList<X509CRL>();
            crls.addAll(this.trustListManager.getTrustedCrls());
            crls.addAll(this.trustListManager.getIssuerCrls());
            CertificateValidationUtil.validateTrustedCertPath(certPathResult.getCertPath(), certPathResult.getTrustAnchor(), crls, this.validationChecks, true);
        }
        catch (UaException e) {
            long statusCode = e.getStatusCode().getValue();
            LOGGER.debug("validateCertificateChain failed, underlying status: {}", (Object)statusCode, (Object)e);
            if (statusCode == 2149384192L || statusCode == 2149449728L) {
                throw new UaException(2148728832L);
            }
            throw new UaException(e.getStatusCode());
        }
    }

    @Override
    public void validateCertificateChain(List<X509Certificate> certificateChain, String applicationUri) throws UaException {
        this.validateCertificateChain(certificateChain);
        X509Certificate certificate = certificateChain.get(0);
        try {
            CertificateValidationUtil.checkApplicationUri(certificate, applicationUri);
        }
        catch (UaException e) {
            if (this.validationChecks.contains((Object)ValidationCheck.APPLICATION_URI)) {
                throw e;
            }
            LOGGER.warn("check suppressed: certificate failed application uri check: {} != {}", (Object)applicationUri, (Object)CertificateValidationUtil.getSubjectAltNameUri(certificate));
        }
    }
}

