/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.util;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import org.slf4j.LoggerFactory;

public class SecureXmlUtil {
    public static final DocumentBuilderFactory SHARED_DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    public static final TransformerFactory SHARED_TRANSFORMER_FACTORY = TransformerFactory.newInstance();

    private SecureXmlUtil() {
    }

    private static void trySetFeature(String feature, boolean value) {
        try {
            SHARED_DOCUMENT_BUILDER_FACTORY.setFeature(feature, value);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(SecureXmlUtil.class).warn("Error configuring feature: " + feature + "=" + value, e);
        }
    }

    private static void trySetAttribute(String attribute, Object value) {
        try {
            SHARED_TRANSFORMER_FACTORY.setAttribute(attribute, value);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(SecureXmlUtil.class).warn("Error configuring attribute: " + attribute + "=" + value, e);
        }
    }

    static {
        SHARED_DOCUMENT_BUILDER_FACTORY.setCoalescing(true);
        SHARED_DOCUMENT_BUILDER_FACTORY.setNamespaceAware(true);
        SHARED_DOCUMENT_BUILDER_FACTORY.setExpandEntityReferences(false);
        SHARED_DOCUMENT_BUILDER_FACTORY.setXIncludeAware(false);
        SecureXmlUtil.trySetFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        SecureXmlUtil.trySetFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        SecureXmlUtil.trySetFeature("http://xml.org/sax/features/external-general-entities", false);
        SecureXmlUtil.trySetFeature("http://xml.org/sax/features/external-parameter-entities", false);
        SecureXmlUtil.trySetFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        SecureXmlUtil.trySetAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        SecureXmlUtil.trySetAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
    }
}

