/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.util;

import java.security.SecureRandom;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.bouncycastle.util.Arrays;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.slf4j.LoggerFactory;

public class NonceUtil {
    public static final int MINIMUM_NONCE_LENGTH = 32;
    private static volatile boolean SECURE_RANDOM_ENABLED = true;
    private static final CompletableFuture<Void> SEED_FUTURE = new CompletableFuture();
    private static final AtomicReference<SecureRandom> SECURE_RANDOM = new AtomicReference();

    public static void blockUntilSecureRandomSeeded() throws ExecutionException, InterruptedException {
        SEED_FUTURE.get();
    }

    public static void blockUntilSecureRandomSeeded(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        SEED_FUTURE.get(timeout, unit);
    }

    public static CompletionStage<Void> secureRandomSeeded() {
        return SEED_FUTURE;
    }

    public static void enableSecureRandom() {
        SECURE_RANDOM_ENABLED = true;
    }

    public static void disableSecureRandom() {
        SECURE_RANDOM_ENABLED = false;
    }

    public static boolean isSecureRandomEnabled() {
        return SECURE_RANDOM_ENABLED;
    }

    public static boolean isSecureRandomSeeded() {
        return SECURE_RANDOM.get() != null;
    }

    public static ByteString generateNonce(int length) {
        if (length == 0) {
            return ByteString.NULL_VALUE;
        }
        byte[] bs = new byte[length];
        Random random = null;
        if (SECURE_RANDOM_ENABLED) {
            random = SECURE_RANDOM.get();
        }
        if (random == null) {
            random = ThreadLocalRandom.current();
        }
        random.nextBytes(bs);
        return new ByteString(bs);
    }

    public static ByteString generateNonce(SecurityPolicy securityPolicy) {
        return NonceUtil.generateNonce(NonceUtil.getNonceLength(securityPolicy));
    }

    private static int getNonceLength(SecurityPolicy securityPolicy) {
        switch (securityPolicy) {
            case Basic128Rsa15: {
                return 16;
            }
            case Basic256: 
            case Basic256Sha256: 
            case Aes128_Sha256_RsaOaep: 
            case Aes256_Sha256_RsaPss: {
                return 32;
            }
        }
        return 0;
    }

    public static void validateNonce(ByteString nonce, SecurityPolicy securityPolicy) throws UaException {
        NonceUtil.validateNonce(nonce, NonceUtil.getNonceLength(securityPolicy));
    }

    public static void validateNonce(ByteString nonce) throws UaException {
        NonceUtil.validateNonce(nonce, 32);
    }

    public static void validateNonce(ByteString nonce, int minimumLength) throws UaException {
        byte[] bs = nonce.bytesOrEmpty();
        if (bs.length < minimumLength) {
            throw new UaException(2149842944L, "nonce must be at least " + minimumLength + " bytes");
        }
        if (bs.length > 0 && Arrays.areAllZeroes(bs, 0, bs.length)) {
            throw new UaException(2149842944L, "nonce must be non-zero");
        }
    }

    static {
        new Thread(() -> {
            long start = System.nanoTime();
            SecureRandom sr = new SecureRandom();
            sr.nextBytes(new byte[32]);
            SECURE_RANDOM.set(sr);
            long delta = System.nanoTime() - start;
            LoggerFactory.getLogger(NonceUtil.class).info("SecureRandom seeded in {}ms.", (Object)TimeUnit.MILLISECONDS.convert(delta, TimeUnit.NANOSECONDS));
            SEED_FUTURE.complete(null);
        }, "milo-nonce-util-secure-random").start();
    }
}

