/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.builtin;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.util.ArrayUtil;
import org.eclipse.milo.opcua.stack.core.util.TypeUtil;
import org.jetbrains.annotations.Nullable;

public final class Variant {
    public static final Variant NULL_VALUE = new Variant(null);
    private final Object value;

    public Variant(@Nullable Object value) {
        if (value != null) {
            boolean clazzIsArray = value.getClass().isArray();
            Class<?> componentClazz = clazzIsArray ? ArrayUtil.getType(value) : value.getClass();
            Preconditions.checkArgument(clazzIsArray || !Variant.class.equals(componentClazz), "Variant cannot contain Variant");
            Preconditions.checkArgument(!DiagnosticInfo.class.equals(componentClazz), "Variant cannot contain DiagnosticInfo");
        }
        this.value = value;
    }

    public Optional<ExpandedNodeId> getDataType() {
        if (this.value == null) {
            return Optional.empty();
        }
        if (this.value instanceof UaStructure) {
            return Optional.of(((UaStructure)this.value).getTypeId());
        }
        if (this.value instanceof UaEnumeration) {
            return Optional.of(Identifiers.Int32.expanded());
        }
        Class<?> clazz = this.value.getClass().isArray() ? ArrayUtil.getType(this.value) : this.value.getClass();
        int typeId = TypeUtil.getBuiltinTypeId(clazz);
        return typeId == -1 ? Optional.empty() : Optional.of(new NodeId(0, typeId).expanded());
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean isNotNull() {
        return !this.isNull();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Variant variant = (Variant)o;
        return Objects.deepEquals(this.value, variant.value);
    }

    public int hashCode() {
        return Objects.hash(this.valueHash());
    }

    private int valueHash() {
        if (this.value instanceof Object[]) {
            return Arrays.deepHashCode((Object[])this.value);
        }
        if (this.value instanceof boolean[]) {
            return Arrays.hashCode((boolean[])this.value);
        }
        if (this.value instanceof byte[]) {
            return Arrays.hashCode((byte[])this.value);
        }
        if (this.value instanceof short[]) {
            return Arrays.hashCode((short[])this.value);
        }
        if (this.value instanceof int[]) {
            return Arrays.hashCode((int[])this.value);
        }
        if (this.value instanceof long[]) {
            return Arrays.hashCode((long[])this.value);
        }
        if (this.value instanceof float[]) {
            return Arrays.hashCode((float[])this.value);
        }
        if (this.value instanceof double[]) {
            return Arrays.hashCode((double[])this.value);
        }
        return Objects.hashCode(this.value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(this);
        helper.add("value", this.value);
        return helper.toString();
    }
}

