/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.builtin;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class QualifiedName {
    public static final QualifiedName NULL_VALUE = new QualifiedName(Unsigned.ushort(0), null);
    private final UShort namespaceIndex;
    private final String name;

    public QualifiedName(int namespaceIndex, @Nullable String name) {
        this(Unsigned.ushort(namespaceIndex), name);
    }

    public QualifiedName(@NotNull UShort namespaceIndex, @Nullable String name) {
        Preconditions.checkNotNull(namespaceIndex);
        Preconditions.checkArgument(name == null || name.length() <= 512, "name");
        this.namespaceIndex = namespaceIndex;
        this.name = name;
    }

    public UShort getNamespaceIndex() {
        return this.namespaceIndex;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public boolean isNull() {
        return this.name == null;
    }

    public boolean isNotNull() {
        return !this.isNull();
    }

    public QualifiedName reindex(NamespaceTable namespaceTable, String namespaceUri) {
        UShort namespaceIndex = namespaceTable.getIndex(namespaceUri);
        if (namespaceIndex != null && !namespaceIndex.equals(this.getNamespaceIndex())) {
            return this.withNamespaceIndex(namespaceIndex);
        }
        return this;
    }

    public QualifiedName withName(@Nullable String name) {
        return new QualifiedName(this.namespaceIndex, name);
    }

    public QualifiedName withNamespaceIndex(@NotNull UShort namespaceIndex) {
        return new QualifiedName(namespaceIndex, this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QualifiedName that = (QualifiedName)o;
        return !(this.name == null ? that.name != null : !this.name.equals(that.name)) && this.namespaceIndex.equals(that.namespaceIndex);
    }

    public int hashCode() {
        int result = this.namespaceIndex.hashCode();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("namespaceIndex", this.namespaceIndex).toString();
    }

    public String toParseableString() {
        return String.format("%s:%s", this.namespaceIndex.intValue(), this.name);
    }

    public static QualifiedName parse(String s) {
        String[] ss = s.split(":", 2);
        int namespaceIndex = 0;
        String name = s;
        if (ss.length > 1) {
            try {
                namespaceIndex = Short.parseShort(ss[0]);
            }
            catch (NumberFormatException ignored) {
                namespaceIndex = 0;
            }
            name = ss[1];
        }
        return new QualifiedName(Unsigned.ushort(namespaceIndex), name);
    }
}

