/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.services;

import java.util.List;
import org.eclipse.milo.opcua.sdk.server.DiagnosticsContext;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.api.services.NodeManagementServices;
import org.eclipse.milo.opcua.sdk.server.services.ServiceAttributes;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.AddNodesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.AddNodesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.AddNodesResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.AddNodesResult;
import org.eclipse.milo.opcua.stack.core.types.structured.AddReferencesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.AddReferencesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.AddReferencesResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteNodesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteNodesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteNodesResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteReferencesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteReferencesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteReferencesResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.server.services.NodeManagementServiceSet;
import org.eclipse.milo.opcua.stack.server.services.ServiceRequest;

public class DefaultNodeManagementServiceSet
implements NodeManagementServiceSet {
    @Override
    public void onAddNodes(ServiceRequest service) {
        OpcUaServer server = service.attr(ServiceAttributes.SERVER_KEY).get();
        Session session = service.attr(ServiceAttributes.SESSION_KEY).get();
        AddNodesRequest request = (AddNodesRequest)service.getRequest();
        List<AddNodesItem> nodesToAdd = ConversionUtil.l(request.getNodesToAdd());
        if (nodesToAdd.isEmpty()) {
            service.setServiceFault(0x800F0000L);
            return;
        }
        if ((long)nodesToAdd.size() > server.getConfig().getLimits().getMaxNodesPerNodeManagement().longValue()) {
            service.setServiceFault(0x80100000L);
            return;
        }
        NodeManagementServices.AddNodesContext context = new NodeManagementServices.AddNodesContext(server, session, new DiagnosticsContext<AddNodesItem>());
        server.getAddressSpaceManager().addNodes(context, nodesToAdd);
        context.getFuture().thenAccept(results -> {
            ResponseHeader header = service.createResponseHeader();
            AddNodesResponse response = new AddNodesResponse(header, ConversionUtil.a(results, AddNodesResult.class), new DiagnosticInfo[0]);
            service.setResponse(response);
        });
    }

    @Override
    public void onDeleteNodes(ServiceRequest service) {
        OpcUaServer server = service.attr(ServiceAttributes.SERVER_KEY).get();
        Session session = service.attr(ServiceAttributes.SESSION_KEY).get();
        DeleteNodesRequest request = (DeleteNodesRequest)service.getRequest();
        List<DeleteNodesItem> nodesToDelete = ConversionUtil.l(request.getNodesToDelete());
        if (nodesToDelete.isEmpty()) {
            service.setServiceFault(0x800F0000L);
            return;
        }
        if ((long)nodesToDelete.size() > server.getConfig().getLimits().getMaxNodesPerNodeManagement().longValue()) {
            service.setServiceFault(0x80100000L);
            return;
        }
        NodeManagementServices.DeleteNodesContext context = new NodeManagementServices.DeleteNodesContext(server, session, new DiagnosticsContext<DeleteNodesItem>());
        server.getAddressSpaceManager().deleteNodes(context, nodesToDelete);
        context.getFuture().thenAccept(results -> {
            ResponseHeader header = service.createResponseHeader();
            DeleteNodesResponse response = new DeleteNodesResponse(header, ConversionUtil.a(results, StatusCode.class), new DiagnosticInfo[0]);
            service.setResponse(response);
        });
    }

    @Override
    public void onAddReferences(ServiceRequest service) {
        OpcUaServer server = service.attr(ServiceAttributes.SERVER_KEY).get();
        Session session = service.attr(ServiceAttributes.SESSION_KEY).get();
        AddReferencesRequest request = (AddReferencesRequest)service.getRequest();
        List<AddReferencesItem> referencesToAdd = ConversionUtil.l(request.getReferencesToAdd());
        if (referencesToAdd.isEmpty()) {
            service.setServiceFault(0x800F0000L);
            return;
        }
        if ((long)referencesToAdd.size() > server.getConfig().getLimits().getMaxNodesPerNodeManagement().longValue()) {
            service.setServiceFault(0x80100000L);
            return;
        }
        NodeManagementServices.AddReferencesContext context = new NodeManagementServices.AddReferencesContext(server, session, new DiagnosticsContext<AddReferencesItem>());
        server.getAddressSpaceManager().addReferences(context, referencesToAdd);
        context.getFuture().thenAccept(results -> {
            ResponseHeader header = service.createResponseHeader();
            AddReferencesResponse response = new AddReferencesResponse(header, ConversionUtil.a(results, StatusCode.class), new DiagnosticInfo[0]);
            service.setResponse(response);
        });
    }

    @Override
    public void onDeleteReferences(ServiceRequest service) {
        OpcUaServer server = service.attr(ServiceAttributes.SERVER_KEY).get();
        Session session = service.attr(ServiceAttributes.SESSION_KEY).get();
        DeleteReferencesRequest request = (DeleteReferencesRequest)service.getRequest();
        List<DeleteReferencesItem> referencesToDelete = ConversionUtil.l(request.getReferencesToDelete());
        if (referencesToDelete.isEmpty()) {
            service.setServiceFault(0x800F0000L);
            return;
        }
        if ((long)referencesToDelete.size() > server.getConfig().getLimits().getMaxNodesPerNodeManagement().longValue()) {
            service.setServiceFault(0x80100000L);
            return;
        }
        NodeManagementServices.DeleteReferencesContext context = new NodeManagementServices.DeleteReferencesContext(server, session, new DiagnosticsContext<DeleteReferencesItem>());
        server.getAddressSpaceManager().deleteReferences(context, referencesToDelete);
        context.getFuture().thenAccept(results -> {
            ResponseHeader header = service.createResponseHeader();
            DeleteReferencesResponse response = new DeleteReferencesResponse(header, ConversionUtil.a(results, StatusCode.class), new DiagnosticInfo[0]);
            service.setResponse(response);
        });
    }
}

