/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.services;

import org.eclipse.milo.opcua.sdk.server.services.ServiceCounter;
import org.eclipse.milo.opcua.sdk.server.subscriptions.SubscriptionManager;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.server.services.MonitoredItemServiceSet;
import org.eclipse.milo.opcua.stack.server.services.ServiceRequest;

public class DefaultMonitoredItemServiceSet
implements MonitoredItemServiceSet {
    private final ServiceCounter createMonitoredItemsMetric = new ServiceCounter();
    private final ServiceCounter modifyMonitoredItemsMetric = new ServiceCounter();
    private final ServiceCounter deleteMonitoredItemsMetric = new ServiceCounter();
    private final ServiceCounter setMonitoringModeMetric = new ServiceCounter();
    private final ServiceCounter setTriggeringMetric = new ServiceCounter();
    private final SubscriptionManager subscriptionManager;

    public DefaultMonitoredItemServiceSet(SubscriptionManager subscriptionManager) {
        this.subscriptionManager = subscriptionManager;
    }

    @Override
    public void onCreateMonitoredItems(ServiceRequest service) throws UaException {
        this.createMonitoredItemsMetric.record(service);
        this.subscriptionManager.createMonitoredItems(service);
    }

    @Override
    public void onModifyMonitoredItems(ServiceRequest service) throws UaException {
        this.modifyMonitoredItemsMetric.record(service);
        this.subscriptionManager.modifyMonitoredItems(service);
    }

    @Override
    public void onDeleteMonitoredItems(ServiceRequest service) throws UaException {
        this.deleteMonitoredItemsMetric.record(service);
        this.subscriptionManager.deleteMonitoredItems(service);
    }

    @Override
    public void onSetMonitoringMode(ServiceRequest service) {
        this.setMonitoringModeMetric.record(service);
        this.subscriptionManager.setMonitoringMode(service);
    }

    @Override
    public void onSetTriggering(ServiceRequest service) {
        this.setTriggeringMetric.record(service);
        this.subscriptionManager.setTriggering(service);
    }
}

