/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes.delegates;

import org.eclipse.milo.opcua.sdk.core.nodes.ViewNode;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaViewNode;
import org.eclipse.milo.opcua.sdk.server.nodes.delegates.GetSetBase;
import org.eclipse.milo.opcua.sdk.server.util.AttributeUtil;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;

public interface GetSetViewNode
extends GetSetBase {
    default public DataValue getViewAttribute(AttributeContext context, UaViewNode node, AttributeId attributeId) throws UaException {
        switch (attributeId) {
            case ContainsNoLoops: {
                return AttributeUtil.dv(this.getContainsNoLoops(context, node));
            }
            case EventNotifier: {
                return AttributeUtil.dv(this.getEventNotifier(context, node));
            }
        }
        return this.getBaseAttribute(context, node, attributeId);
    }

    default public void setViewAttribute(AttributeContext context, UaViewNode node, AttributeId attributeId, DataValue value) throws UaException {
        switch (attributeId) {
            case ContainsNoLoops: {
                this.setContainsNoLoops(context, node, (Boolean)AttributeUtil.extract(value));
                break;
            }
            case EventNotifier: {
                this.setEventNotifier(context, node, (UByte)AttributeUtil.extract(value));
                break;
            }
            default: {
                this.setBaseAttribute(context, node, attributeId, value);
            }
        }
    }

    default public Boolean getContainsNoLoops(AttributeContext context, ViewNode node) throws UaException {
        return (Boolean)((UaNode)((Object)node)).getFilterChain().getAttribute(context.getSession().orElse(null), (UaNode)((Object)node), AttributeId.ContainsNoLoops);
    }

    default public UByte getEventNotifier(AttributeContext context, ViewNode node) throws UaException {
        return (UByte)((UaNode)((Object)node)).getFilterChain().getAttribute(context.getSession().orElse(null), (UaNode)((Object)node), AttributeId.EventNotifier);
    }

    default public void setContainsNoLoops(AttributeContext context, ViewNode node, Boolean containsNoLoops) throws UaException {
        ((UaNode)((Object)node)).getFilterChain().setAttribute(context.getSession().orElse(null), (UaNode)((Object)node), AttributeId.ContainsNoLoops, containsNoLoops);
    }

    default public void setEventNotifier(AttributeContext context, ViewNode node, UByte eventNotifier) throws UaException {
        ((UaNode)((Object)node)).getFilterChain().setAttribute(context.getSession().orElse(null), (UaNode)((Object)node), AttributeId.EventNotifier, eventNotifier);
    }
}

