/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes.delegates;

import org.eclipse.milo.opcua.sdk.core.nodes.MethodNode;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.delegates.GetSetBase;
import org.eclipse.milo.opcua.sdk.server.util.AttributeUtil;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;

public interface GetSetMethodNode
extends GetSetBase {
    default public DataValue getMethodAttribute(AttributeContext context, UaMethodNode node, AttributeId attributeId) throws UaException {
        switch (attributeId) {
            case Executable: {
                return AttributeUtil.dv(this.isExecutable(context, node));
            }
            case UserExecutable: {
                return AttributeUtil.dv(this.isUserExecutable(context, node));
            }
        }
        return this.getBaseAttribute(context, node, attributeId);
    }

    default public void setMethodAttribute(AttributeContext context, UaMethodNode node, AttributeId attributeId, DataValue value) throws UaException {
        switch (attributeId) {
            case Executable: {
                this.setExecutable(context, node, (Boolean)AttributeUtil.extract(value));
                break;
            }
            case UserExecutable: {
                this.setUserExecutable(context, node, (Boolean)AttributeUtil.extract(value));
                break;
            }
            default: {
                this.setBaseAttribute(context, node, attributeId, value);
            }
        }
    }

    default public Boolean isExecutable(AttributeContext context, MethodNode node) throws UaException {
        return (Boolean)((UaNode)((Object)node)).getFilterChain().getAttribute(context.getSession().orElse(null), (UaNode)((Object)node), AttributeId.Executable);
    }

    default public Boolean isUserExecutable(AttributeContext context, MethodNode node) throws UaException {
        return (Boolean)((UaNode)((Object)node)).getFilterChain().getAttribute(context.getSession().orElse(null), (UaNode)((Object)node), AttributeId.UserExecutable);
    }

    default public void setExecutable(AttributeContext context, MethodNode node, Boolean executable) throws UaException {
        ((UaNode)((Object)node)).getFilterChain().setAttribute(context.getSession().orElse(null), (UaNode)((Object)node), AttributeId.Executable, executable);
    }

    default public void setUserExecutable(AttributeContext context, MethodNode node, Boolean userExecutable) throws UaException {
        ((UaNode)((Object)node)).getFilterChain().setAttribute(context.getSession().orElse(null), (UaNode)((Object)node), AttributeId.UserExecutable, userExecutable);
    }
}

