/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.diagnostics.variables;

import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.milo.opcua.sdk.server.AbstractLifecycle;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.diagnostics.variables.Util;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.ServerDiagnosticsTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.ServerDiagnosticsSummaryTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeObserver;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;

public class ServerDiagnosticsSummaryVariable
extends AbstractLifecycle {
    private final AtomicBoolean diagnosticsEnabled = new AtomicBoolean(false);
    private AttributeObserver attributeObserver;
    private final OpcUaServer server;
    private final ServerDiagnosticsSummaryTypeNode node;

    public ServerDiagnosticsSummaryVariable(ServerDiagnosticsSummaryTypeNode node) {
        this.node = node;
        this.server = node.getNodeContext().getServer();
    }

    @Override
    protected void onStartup() {
        ServerDiagnosticsTypeNode diagnosticsNode = (ServerDiagnosticsTypeNode)this.server.getAddressSpaceManager().getManagedNode(Identifiers.Server_ServerDiagnostics).orElseThrow(() -> new NoSuchElementException("NodeId: " + Identifiers.Server_ServerDiagnostics));
        this.diagnosticsEnabled.set(diagnosticsNode.getEnabledFlag());
        this.attributeObserver = (node, attributeId, value) -> {
            DataValue dataValue;
            Object o;
            if (attributeId == AttributeId.Value && (o = (dataValue = (DataValue)value).getValue().getValue()) instanceof Boolean) {
                this.diagnosticsEnabled.set((Boolean)o);
            }
        };
        diagnosticsNode.getEnabledFlagNode().addAttributeObserver(this.attributeObserver);
        this.node.getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject xo = ExtensionObject.encode(this.server.getSerializationContext(), this.server.getDiagnosticsSummary().getServerDiagnosticsSummaryDataType());
            return new DataValue(new Variant(xo));
        }));
        this.node.getServerViewCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = Unsigned.uint(this.server.getDiagnosticsSummary().getCurrentViewCount().longValue());
            return new DataValue(new Variant(value));
        }));
        this.node.getCurrentSessionCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = Unsigned.uint(this.server.getDiagnosticsSummary().getCurrentSessionCount().longValue());
            return new DataValue(new Variant(value));
        }));
        this.node.getCumulatedSessionCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = Unsigned.uint(this.server.getDiagnosticsSummary().getCumulatedSessionCount().longValue());
            return new DataValue(new Variant(value));
        }));
        this.node.getSecurityRejectedSessionCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = Unsigned.uint(this.server.getDiagnosticsSummary().getSecurityRejectedSessionCount().longValue());
            return new DataValue(new Variant(value));
        }));
        this.node.getRejectedSessionCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = Unsigned.uint(this.server.getDiagnosticsSummary().getRejectedSessionCount().longValue());
            return new DataValue(new Variant(value));
        }));
        this.node.getSessionTimeoutCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = Unsigned.uint(this.server.getDiagnosticsSummary().getSessionTimeoutCount().longValue());
            return new DataValue(new Variant(value));
        }));
        this.node.getSessionAbortCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = Unsigned.uint(this.server.getDiagnosticsSummary().getSessionAbortCount().longValue());
            return new DataValue(new Variant(value));
        }));
        this.node.getPublishingIntervalCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = Unsigned.uint(this.server.getDiagnosticsSummary().getPublishingIntervalCount().longValue());
            return new DataValue(new Variant(value));
        }));
        this.node.getCurrentSubscriptionCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = Unsigned.uint(this.server.getDiagnosticsSummary().getCurrentSubscriptionCount().longValue());
            return new DataValue(new Variant(value));
        }));
        this.node.getCumulatedSubscriptionCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = Unsigned.uint(this.server.getDiagnosticsSummary().getCumulatedSubscriptionCount().longValue());
            return new DataValue(new Variant(value));
        }));
        this.node.getSecurityRejectedRequestsCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = this.server.getDiagnosticsSummary().getSecurityRejectedRequestCount();
            return new DataValue(new Variant(value));
        }));
        this.node.getRejectedRequestsCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = this.server.getDiagnosticsSummary().getRejectedRequestCount();
            return new DataValue(new Variant(value));
        }));
    }

    @Override
    protected void onShutdown() {
        AttributeObserver observer = this.attributeObserver;
        if (observer != null) {
            ServerDiagnosticsTypeNode diagnosticsNode = (ServerDiagnosticsTypeNode)this.server.getAddressSpaceManager().getManagedNode(Identifiers.Server_ServerDiagnostics).orElseThrow(() -> new NoSuchElementException("NodeId: " + Identifiers.Server_ServerDiagnostics));
            diagnosticsNode.getEnabledFlagNode().removeAttributeObserver(observer);
            this.attributeObserver = null;
        }
        this.node.delete();
    }
}

