/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.diagnostics;

import java.util.concurrent.atomic.LongAdder;
import org.eclipse.milo.opcua.sdk.server.subscriptions.Subscription;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.structured.SubscriptionDiagnosticsDataType;

public class SubscriptionDiagnostics {
    private final LongAdder modifyCount = new LongAdder();
    private final LongAdder enableCount = new LongAdder();
    private final LongAdder disableCount = new LongAdder();
    private final LongAdder republishRequestCount = new LongAdder();
    private final LongAdder republishMessageRequestCount = new LongAdder();
    private final LongAdder republishMessageCount = new LongAdder();
    private final LongAdder transferRequestCount = new LongAdder();
    private final LongAdder transferredToAltClientCount = new LongAdder();
    private final LongAdder transferredToSameClientCount = new LongAdder();
    private final LongAdder publishRequestCount = new LongAdder();
    private final LongAdder dataChangeNotificationsCount = new LongAdder();
    private final LongAdder eventNotificationsCount = new LongAdder();
    private final LongAdder notificationsCount = new LongAdder();
    private final LongAdder latePublishRequestCount = new LongAdder();
    private final LongAdder discardedMessageCount = new LongAdder();
    private final LongAdder monitoringQueueOverflowCount = new LongAdder();
    private final LongAdder eventQueueOverflowCount = new LongAdder();
    private final Subscription subscription;

    public SubscriptionDiagnostics(Subscription subscription) {
        this.subscription = subscription;
    }

    public NodeId getSessionId() {
        return this.subscription.getSession().getSessionId();
    }

    public UInteger getSubscriptionId() {
        return this.subscription.getId();
    }

    public UByte getPriority() {
        return Unsigned.ubyte(this.subscription.getPriority());
    }

    public double getPublishingInterval() {
        return this.subscription.getPublishingInterval();
    }

    public UInteger getMaxKeepAliveCount() {
        return Unsigned.uint(this.subscription.getMaxKeepAliveCount());
    }

    public UInteger getMaxLifetimeCount() {
        return Unsigned.uint(this.subscription.getLifetimeCount());
    }

    public UInteger getMaxNotificationsPerPublish() {
        return Unsigned.uint(this.subscription.getMaxNotificationsPerPublish());
    }

    public boolean isPublishingEnabled() {
        return this.subscription.isPublishingEnabled();
    }

    public LongAdder getModifyCount() {
        return this.modifyCount;
    }

    public LongAdder getEnableCount() {
        return this.enableCount;
    }

    public LongAdder getDisableCount() {
        return this.disableCount;
    }

    public LongAdder getRepublishRequestCount() {
        return this.republishRequestCount;
    }

    public LongAdder getRepublishMessageRequestCount() {
        return this.republishMessageRequestCount;
    }

    public LongAdder getRepublishMessageCount() {
        return this.republishMessageCount;
    }

    public LongAdder getTransferRequestCount() {
        return this.transferRequestCount;
    }

    public LongAdder getTransferredToAltClientCount() {
        return this.transferredToAltClientCount;
    }

    public LongAdder getTransferredToSameClientCount() {
        return this.transferredToSameClientCount;
    }

    public LongAdder getPublishRequestCount() {
        return this.publishRequestCount;
    }

    public LongAdder getDataChangeNotificationsCount() {
        return this.dataChangeNotificationsCount;
    }

    public LongAdder getEventNotificationsCount() {
        return this.eventNotificationsCount;
    }

    public LongAdder getNotificationsCount() {
        return this.notificationsCount;
    }

    public LongAdder getLatePublishRequestCount() {
        return this.latePublishRequestCount;
    }

    public UInteger getCurrentKeepAliveCount() {
        return Unsigned.uint(this.subscription.getKeepAliveCounter());
    }

    public UInteger getCurrentLifetimeCount() {
        return Unsigned.uint(this.subscription.getLifetimeCounter());
    }

    public UInteger getUnacknowledgedMessageCount() {
        return this.subscription.getUnacknowledgeMessageCount();
    }

    public LongAdder getDiscardedMessageCount() {
        return this.discardedMessageCount;
    }

    public UInteger getMonitoredItemCount() {
        return this.subscription.getMonitoredItemCount();
    }

    public UInteger getDisabledMonitoredItemCount() {
        return this.subscription.getDisabledMonitoredItemCount();
    }

    public LongAdder getMonitoringQueueOverflowCount() {
        return this.monitoringQueueOverflowCount;
    }

    public UInteger getNextSequenceNumber() {
        return this.subscription.getNextSequenceNumber();
    }

    public LongAdder getEventQueueOverflowCount() {
        return this.eventQueueOverflowCount;
    }

    public SubscriptionDiagnosticsDataType getSubscriptionDiagnosticsDataType() {
        return new SubscriptionDiagnosticsDataType(this.getSessionId(), this.getSubscriptionId(), this.getPriority(), this.getPublishingInterval(), this.getMaxKeepAliveCount(), this.getMaxLifetimeCount(), this.getMaxNotificationsPerPublish(), this.isPublishingEnabled(), Unsigned.uint(this.getModifyCount().sum()), Unsigned.uint(this.getEnableCount().sum()), Unsigned.uint(this.getDisableCount().sum()), Unsigned.uint(this.getRepublishRequestCount().sum()), Unsigned.uint(this.getRepublishMessageRequestCount().sum()), Unsigned.uint(this.getRepublishRequestCount().sum()), Unsigned.uint(this.getTransferRequestCount().sum()), Unsigned.uint(this.getTransferredToAltClientCount().sum()), Unsigned.uint(this.getTransferredToSameClientCount().sum()), Unsigned.uint(this.getPublishRequestCount().sum()), Unsigned.uint(this.getDataChangeNotificationsCount().sum()), Unsigned.uint(this.getEventNotificationsCount().sum()), Unsigned.uint(this.getNotificationsCount().sum()), Unsigned.uint(this.getLatePublishRequestCount().sum()), this.getCurrentKeepAliveCount(), this.getCurrentLifetimeCount(), this.getUnacknowledgedMessageCount(), Unsigned.uint(this.getDiscardedMessageCount().sum()), this.getMonitoredItemCount(), this.getDisabledMonitoredItemCount(), Unsigned.uint(this.getMonitoringQueueOverflowCount().sum()), this.getNextSequenceNumber(), Unsigned.uint(this.getEventQueueOverflowCount().sum()));
    }
}

