/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.core;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.milo.opcua.stack.core.UaRuntimeException;

public class ServerTable {
    private final BiMap<Integer, String> uriTable = HashBiMap.create();

    public synchronized int addUri(String uri) {
        int index = 1;
        while (this.uriTable.containsKey(index)) {
            if (++index != 65535) continue;
            throw new UaRuntimeException(0x80020000L, "uri table full");
        }
        this.uriTable.put(index, uri);
        return index;
    }

    public synchronized void putUri(String uri, int index) {
        this.uriTable.put(index, uri);
    }

    public synchronized String getUri(int index) {
        return (String)this.uriTable.get(index);
    }

    public synchronized int getIndex(String uri) {
        return (Integer)this.uriTable.inverse().get(uri);
    }

    public synchronized String[] toArray() {
        return (String[])this.uriTable.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getKey)).map(Map.Entry::getValue).toArray(String[]::new);
    }
}

