/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.examples.server;

import com.google.common.collect.Lists;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.eclipse.milo.examples.server.ExampleNamespace;
import org.eclipse.milo.examples.server.KeyStoreLoader;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.api.config.OpcUaServerConfig;
import org.eclipse.milo.opcua.sdk.server.api.config.OpcUaServerConfigBuilder;
import org.eclipse.milo.opcua.sdk.server.identity.CompositeValidator;
import org.eclipse.milo.opcua.sdk.server.identity.UsernameIdentityValidator;
import org.eclipse.milo.opcua.sdk.server.identity.X509IdentityValidator;
import org.eclipse.milo.opcua.sdk.server.util.HostnameUtil;
import org.eclipse.milo.opcua.stack.core.UaRuntimeException;
import org.eclipse.milo.opcua.stack.core.security.DefaultCertificateManager;
import org.eclipse.milo.opcua.stack.core.security.DefaultTrustListManager;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.transport.TransportProfile;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.types.structured.BuildInfo;
import org.eclipse.milo.opcua.stack.core.util.CertificateUtil;
import org.eclipse.milo.opcua.stack.core.util.NonceUtil;
import org.eclipse.milo.opcua.stack.core.util.SelfSignedCertificateGenerator;
import org.eclipse.milo.opcua.stack.core.util.SelfSignedHttpsCertificateBuilder;
import org.eclipse.milo.opcua.stack.server.EndpointConfiguration;
import org.eclipse.milo.opcua.stack.server.security.DefaultServerCertificateValidator;
import org.slf4j.LoggerFactory;

public class ExampleServer {
    private static final int TCP_BIND_PORT = 12686;
    private static final int HTTPS_BIND_PORT = 8443;
    private final OpcUaServer server;
    private final ExampleNamespace exampleNamespace;

    public static void main(String[] args) throws Exception {
        ExampleServer server = new ExampleServer();
        server.startup().get();
        CompletableFuture future = new CompletableFuture();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> future.complete(null)));
        future.get();
    }

    public ExampleServer() throws Exception {
        Path securityTempDir = Paths.get(System.getProperty("java.io.tmpdir"), "server", "security");
        Files.createDirectories(securityTempDir, new FileAttribute[0]);
        if (!Files.exists(securityTempDir, new LinkOption[0])) {
            throw new Exception("unable to create security temp dir: " + securityTempDir);
        }
        File pkiDir = securityTempDir.resolve("pki").toFile();
        LoggerFactory.getLogger(this.getClass()).info("security dir: {}", (Object)securityTempDir.toAbsolutePath());
        LoggerFactory.getLogger(this.getClass()).info("security pki dir: {}", (Object)pkiDir.getAbsolutePath());
        KeyStoreLoader loader = new KeyStoreLoader().load(securityTempDir);
        DefaultCertificateManager certificateManager = new DefaultCertificateManager(loader.getServerKeyPair(), loader.getServerCertificateChain());
        DefaultTrustListManager trustListManager = new DefaultTrustListManager(pkiDir);
        DefaultServerCertificateValidator certificateValidator = new DefaultServerCertificateValidator(trustListManager);
        KeyPair httpsKeyPair = SelfSignedCertificateGenerator.generateRsaKeyPair(2048);
        SelfSignedHttpsCertificateBuilder httpsCertificateBuilder = new SelfSignedHttpsCertificateBuilder(httpsKeyPair);
        httpsCertificateBuilder.setCommonName(HostnameUtil.getHostname());
        HostnameUtil.getHostnames("0.0.0.0").forEach(httpsCertificateBuilder::addDnsName);
        X509Certificate httpsCertificate = httpsCertificateBuilder.build();
        UsernameIdentityValidator identityValidator = new UsernameIdentityValidator(true, authChallenge -> {
            String username = authChallenge.getUsername();
            String password = authChallenge.getPassword();
            boolean userOk = "user".equals(username) && "password1".equals(password);
            boolean adminOk = "admin".equals(username) && "password2".equals(password);
            return userOk || adminOk;
        });
        X509IdentityValidator x509IdentityValidator = new X509IdentityValidator(c -> true);
        X509Certificate certificate = (X509Certificate)certificateManager.getCertificates().stream().findFirst().orElseThrow(() -> new UaRuntimeException(0x80890000L, "no certificate found"));
        String applicationUri = CertificateUtil.getSanUri(certificate).orElseThrow(() -> new UaRuntimeException(0x80890000L, "certificate is missing the application URI"));
        Set<EndpointConfiguration> endpointConfigurations = this.createEndpointConfigurations(certificate);
        OpcUaServerConfig serverConfig = ((OpcUaServerConfigBuilder)OpcUaServerConfig.builder().setApplicationUri(applicationUri).setApplicationName(LocalizedText.english("Eclipse Milo OPC UA Example Server")).setEndpoints((Set)endpointConfigurations)).setBuildInfo(new BuildInfo("urn:eclipse:milo:example-server", "eclipse", "eclipse milo example server", OpcUaServer.SDK_VERSION, "", DateTime.now())).setCertificateManager(certificateManager).setTrustListManager(trustListManager).setCertificateValidator(certificateValidator).setHttpsKeyPair(httpsKeyPair).setHttpsCertificateChain(new X509Certificate[]{httpsCertificate}).setIdentityValidator(new CompositeValidator(identityValidator, x509IdentityValidator)).setProductUri("urn:eclipse:milo:example-server").build();
        this.server = new OpcUaServer(serverConfig);
        this.exampleNamespace = new ExampleNamespace(this.server);
        this.exampleNamespace.startup();
    }

    private Set<EndpointConfiguration> createEndpointConfigurations(X509Certificate certificate) {
        LinkedHashSet<EndpointConfiguration> endpointConfigurations = new LinkedHashSet<EndpointConfiguration>();
        ArrayList<String> bindAddresses = Lists.newArrayList();
        bindAddresses.add("0.0.0.0");
        LinkedHashSet<String> hostnames = new LinkedHashSet<String>();
        hostnames.add(HostnameUtil.getHostname());
        hostnames.addAll(HostnameUtil.getHostnames("0.0.0.0"));
        for (String bindAddress : bindAddresses) {
            for (String hostname : hostnames) {
                EndpointConfiguration.Builder builder = EndpointConfiguration.newBuilder().setBindAddress(bindAddress).setHostname(hostname).setPath("/milo").setCertificate(certificate).addTokenPolicies(OpcUaServerConfig.USER_TOKEN_POLICY_ANONYMOUS, OpcUaServerConfig.USER_TOKEN_POLICY_USERNAME, OpcUaServerConfig.USER_TOKEN_POLICY_X509);
                EndpointConfiguration.Builder noSecurityBuilder = builder.copy().setSecurityPolicy(SecurityPolicy.None).setSecurityMode(MessageSecurityMode.None);
                endpointConfigurations.add(ExampleServer.buildTcpEndpoint(noSecurityBuilder));
                endpointConfigurations.add(ExampleServer.buildHttpsEndpoint(noSecurityBuilder));
                endpointConfigurations.add(ExampleServer.buildTcpEndpoint(builder.copy().setSecurityPolicy(SecurityPolicy.Basic256Sha256).setSecurityMode(MessageSecurityMode.SignAndEncrypt)));
                endpointConfigurations.add(ExampleServer.buildHttpsEndpoint(builder.copy().setSecurityPolicy(SecurityPolicy.Basic256Sha256).setSecurityMode(MessageSecurityMode.Sign)));
                EndpointConfiguration.Builder discoveryBuilder = builder.copy().setPath("/milo/discovery").setSecurityPolicy(SecurityPolicy.None).setSecurityMode(MessageSecurityMode.None);
                endpointConfigurations.add(ExampleServer.buildTcpEndpoint(discoveryBuilder));
                endpointConfigurations.add(ExampleServer.buildHttpsEndpoint(discoveryBuilder));
            }
        }
        return endpointConfigurations;
    }

    private static EndpointConfiguration buildTcpEndpoint(EndpointConfiguration.Builder base) {
        return base.copy().setTransportProfile(TransportProfile.TCP_UASC_UABINARY).setBindPort(12686).build();
    }

    private static EndpointConfiguration buildHttpsEndpoint(EndpointConfiguration.Builder base) {
        return base.copy().setTransportProfile(TransportProfile.HTTPS_UABINARY).setBindPort(8443).build();
    }

    public OpcUaServer getServer() {
        return this.server;
    }

    public CompletableFuture<OpcUaServer> startup() {
        return this.server.startup();
    }

    public CompletableFuture<OpcUaServer> shutdown() {
        this.exampleNamespace.shutdown();
        return this.server.shutdown();
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
        try {
            NonceUtil.blockUntilSecureRandomSeeded(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

