/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.examples.server;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.eclipse.milo.examples.server.AttributeLoggingFilter;
import org.eclipse.milo.examples.server.RestrictedAccessFilter;
import org.eclipse.milo.examples.server.methods.GenerateEventMethod;
import org.eclipse.milo.examples.server.methods.SqrtMethod;
import org.eclipse.milo.examples.server.types.CustomEnumType;
import org.eclipse.milo.examples.server.types.CustomStructType;
import org.eclipse.milo.examples.server.types.CustomUnionType;
import org.eclipse.milo.opcua.sdk.core.AccessLevel;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.ValueRank;
import org.eclipse.milo.opcua.sdk.server.Lifecycle;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.api.DataItem;
import org.eclipse.milo.opcua.sdk.server.api.ManagedNamespaceWithLifecycle;
import org.eclipse.milo.opcua.sdk.server.api.MonitoredItem;
import org.eclipse.milo.opcua.sdk.server.dtd.DataTypeDictionaryManager;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.BaseEventTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.ServerTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.AnalogItemTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaDataTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaFolderNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaObjectNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaObjectTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaVariableNode;
import org.eclipse.milo.opcua.sdk.server.nodes.factories.NodeFactory;
import org.eclipse.milo.opcua.sdk.server.nodes.filters.AttributeFilter;
import org.eclipse.milo.opcua.sdk.server.nodes.filters.AttributeFilters;
import org.eclipse.milo.opcua.sdk.server.util.SubscriptionModel;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.XmlElement;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.StructureType;
import org.eclipse.milo.opcua.stack.core.types.structured.EnumDefinition;
import org.eclipse.milo.opcua.stack.core.types.structured.EnumDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.EnumField;
import org.eclipse.milo.opcua.stack.core.types.structured.Range;
import org.eclipse.milo.opcua.stack.core.types.structured.StructureDefinition;
import org.eclipse.milo.opcua.stack.core.types.structured.StructureDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.StructureField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExampleNamespace
extends ManagedNamespaceWithLifecycle {
    public static final String NAMESPACE_URI = "urn:eclipse:milo:hello-world";
    private static final Object[][] STATIC_SCALAR_NODES = new Object[][]{{"Boolean", Identifiers.Boolean, new Variant(false)}, {"Byte", Identifiers.Byte, new Variant(Unsigned.ubyte(0))}, {"SByte", Identifiers.SByte, new Variant((byte)0)}, {"Integer", Identifiers.Integer, new Variant(32)}, {"Int16", Identifiers.Int16, new Variant((short)16)}, {"Int32", Identifiers.Int32, new Variant(32)}, {"Int64", Identifiers.Int64, new Variant(64L)}, {"UInteger", Identifiers.UInteger, new Variant(Unsigned.uint(32))}, {"UInt16", Identifiers.UInt16, new Variant(Unsigned.ushort(16))}, {"UInt32", Identifiers.UInt32, new Variant(Unsigned.uint(32))}, {"UInt64", Identifiers.UInt64, new Variant(Unsigned.ulong(64L))}, {"Float", Identifiers.Float, new Variant(Float.valueOf(3.14f))}, {"Double", Identifiers.Double, new Variant(3.14)}, {"String", Identifiers.String, new Variant("string value")}, {"DateTime", Identifiers.DateTime, new Variant(DateTime.now())}, {"Guid", Identifiers.Guid, new Variant(UUID.randomUUID())}, {"ByteString", Identifiers.ByteString, new Variant(new ByteString(new byte[]{1, 2, 3, 4}))}, {"XmlElement", Identifiers.XmlElement, new Variant(new XmlElement("<a>hello</a>"))}, {"LocalizedText", Identifiers.LocalizedText, new Variant(LocalizedText.english("localized text"))}, {"QualifiedName", Identifiers.QualifiedName, new Variant(new QualifiedName(1234, "defg"))}, {"NodeId", Identifiers.NodeId, new Variant(new NodeId(1234, "abcd"))}, {"Variant", Identifiers.BaseDataType, new Variant(32)}, {"Duration", Identifiers.Duration, new Variant(1.0)}, {"UtcTime", Identifiers.UtcTime, new Variant(DateTime.now())}};
    private static final Object[][] STATIC_ARRAY_NODES = new Object[][]{{"BooleanArray", Identifiers.Boolean, false}, {"ByteArray", Identifiers.Byte, Unsigned.ubyte(0)}, {"SByteArray", Identifiers.SByte, (byte)0}, {"Int16Array", Identifiers.Int16, (short)16}, {"Int32Array", Identifiers.Int32, 32}, {"Int64Array", Identifiers.Int64, 64L}, {"UInt16Array", Identifiers.UInt16, Unsigned.ushort(16)}, {"UInt32Array", Identifiers.UInt32, Unsigned.uint(32)}, {"UInt64Array", Identifiers.UInt64, Unsigned.ulong(64L)}, {"FloatArray", Identifiers.Float, Float.valueOf(3.14f)}, {"DoubleArray", Identifiers.Double, 3.14}, {"StringArray", Identifiers.String, "string value"}, {"DateTimeArray", Identifiers.DateTime, DateTime.now()}, {"GuidArray", Identifiers.Guid, UUID.randomUUID()}, {"ByteStringArray", Identifiers.ByteString, new ByteString(new byte[]{1, 2, 3, 4})}, {"XmlElementArray", Identifiers.XmlElement, new XmlElement("<a>hello</a>")}, {"LocalizedTextArray", Identifiers.LocalizedText, LocalizedText.english("localized text")}, {"QualifiedNameArray", Identifiers.QualifiedName, new QualifiedName(1234, "defg")}, {"NodeIdArray", Identifiers.NodeId, new NodeId(1234, "abcd")}};
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile Thread eventThread;
    private volatile boolean keepPostingEvents = true;
    private final Random random = new Random();
    private final DataTypeDictionaryManager dictionaryManager;
    private final SubscriptionModel subscriptionModel;

    ExampleNamespace(OpcUaServer server) {
        super(server, NAMESPACE_URI);
        this.subscriptionModel = new SubscriptionModel(server, this);
        this.dictionaryManager = new DataTypeDictionaryManager(this.getNodeContext(), NAMESPACE_URI);
        this.getLifecycleManager().addLifecycle(this.dictionaryManager);
        this.getLifecycleManager().addLifecycle(this.subscriptionModel);
        this.getLifecycleManager().addStartupTask(this::createAndAddNodes);
        this.getLifecycleManager().addLifecycle(new Lifecycle(){

            @Override
            public void startup() {
                ExampleNamespace.this.startBogusEventNotifier();
            }

            @Override
            public void shutdown() {
                try {
                    ExampleNamespace.this.keepPostingEvents = false;
                    ExampleNamespace.this.eventThread.interrupt();
                    ExampleNamespace.this.eventThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
    }

    private void createAndAddNodes() {
        NodeId folderNodeId = this.newNodeId("HelloWorld");
        UaFolderNode folderNode = new UaFolderNode(this.getNodeContext(), folderNodeId, this.newQualifiedName("HelloWorld"), LocalizedText.english("HelloWorld"));
        this.getNodeManager().addNode(folderNode);
        folderNode.addReference(new Reference(folderNode.getNodeId(), Identifiers.Organizes, Identifiers.ObjectsFolder.expanded(), false));
        this.addVariableNodes(folderNode);
        this.addSqrtMethod(folderNode);
        this.addGenerateEventMethod(folderNode);
        try {
            this.registerCustomEnumType();
            this.addCustomEnumTypeVariable(folderNode);
        }
        catch (Exception e) {
            this.logger.warn("Failed to register custom enum type", e);
        }
        try {
            this.registerCustomStructType();
            this.addCustomStructTypeVariable(folderNode);
        }
        catch (Exception e) {
            this.logger.warn("Failed to register custom struct type", e);
        }
        try {
            this.registerCustomUnionType();
            this.addCustomUnionTypeVariable(folderNode);
        }
        catch (Exception e) {
            this.logger.warn("Failed to register custom struct type", e);
        }
        this.addCustomObjectTypeAndInstance(folderNode);
    }

    private void startBogusEventNotifier() {
        UaNode serverNode = this.getServer().getAddressSpaceManager().getManagedNode(Identifiers.Server).orElse(null);
        if (serverNode instanceof ServerTypeNode) {
            ((ServerTypeNode)serverNode).setEventNotifier(Unsigned.ubyte(1));
            this.eventThread = new Thread(() -> {
                while (this.keepPostingEvents) {
                    try {
                        BaseEventTypeNode eventNode = this.getServer().getEventFactory().createEvent(this.newNodeId(UUID.randomUUID()), Identifiers.BaseEventType);
                        eventNode.setBrowseName(new QualifiedName(1, "foo"));
                        eventNode.setDisplayName(LocalizedText.english("foo"));
                        eventNode.setEventId(ByteString.of(new byte[]{0, 1, 2, 3}));
                        eventNode.setEventType(Identifiers.BaseEventType);
                        eventNode.setSourceNode(serverNode.getNodeId());
                        eventNode.setSourceName(serverNode.getDisplayName().getText());
                        eventNode.setTime(DateTime.now());
                        eventNode.setReceiveTime(DateTime.NULL_VALUE);
                        eventNode.setMessage(LocalizedText.english("event message!"));
                        eventNode.setSeverity(Unsigned.ushort(2));
                        this.getServer().getEventBus().post(eventNode);
                        eventNode.delete();
                    }
                    catch (Throwable e) {
                        this.logger.error("Error creating EventNode: {}", (Object)e.getMessage(), (Object)e);
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }, "bogus-event-poster");
            this.eventThread.start();
        }
    }

    private void addVariableNodes(UaFolderNode rootNode) {
        this.addArrayNodes(rootNode);
        this.addScalarNodes(rootNode);
        this.addAdminReadableNodes(rootNode);
        this.addAdminWritableNodes(rootNode);
        this.addDynamicNodes(rootNode);
        this.addDataAccessNodes(rootNode);
        this.addWriteOnlyNodes(rootNode);
    }

    private void addArrayNodes(UaFolderNode rootNode) {
        UaFolderNode arrayTypesFolder = new UaFolderNode(this.getNodeContext(), this.newNodeId("HelloWorld/ArrayTypes"), this.newQualifiedName("ArrayTypes"), LocalizedText.english("ArrayTypes"));
        this.getNodeManager().addNode(arrayTypesFolder);
        rootNode.addOrganizes(arrayTypesFolder);
        for (Object[] os : STATIC_ARRAY_NODES) {
            String name = (String)os[0];
            NodeId typeId = (NodeId)os[1];
            Object value = os[2];
            Object array = Array.newInstance(value.getClass(), 5);
            for (int i = 0; i < 5; ++i) {
                Array.set(array, i, value);
            }
            Variant variant = new Variant(array);
            UaVariableNode.build(this.getNodeContext(), builder -> {
                builder.setNodeId(this.newNodeId("HelloWorld/ArrayTypes/" + name));
                builder.setAccessLevel(AccessLevel.READ_WRITE);
                builder.setUserAccessLevel(AccessLevel.READ_WRITE);
                builder.setBrowseName(this.newQualifiedName(name));
                builder.setDisplayName(LocalizedText.english(name));
                builder.setDataType(typeId);
                builder.setTypeDefinition(Identifiers.BaseDataVariableType);
                builder.setValueRank(ValueRank.OneDimension.getValue());
                builder.setArrayDimensions(new UInteger[]{Unsigned.uint(0)});
                builder.setValue(new DataValue(variant));
                builder.addAttributeFilter(new AttributeLoggingFilter(AttributeId.Value::equals));
                builder.addReference(new Reference(builder.getNodeId(), Identifiers.Organizes, arrayTypesFolder.getNodeId().expanded(), Reference.Direction.INVERSE));
                return builder.buildAndAdd();
            });
        }
    }

    private void addScalarNodes(UaFolderNode rootNode) {
        UaFolderNode scalarTypesFolder = new UaFolderNode(this.getNodeContext(), this.newNodeId("HelloWorld/ScalarTypes"), this.newQualifiedName("ScalarTypes"), LocalizedText.english("ScalarTypes"));
        this.getNodeManager().addNode(scalarTypesFolder);
        rootNode.addOrganizes(scalarTypesFolder);
        for (Object[] os : STATIC_SCALAR_NODES) {
            String name = (String)os[0];
            NodeId typeId = (NodeId)os[1];
            Variant variant = (Variant)os[2];
            UaVariableNode node = new UaVariableNode.UaVariableNodeBuilder(this.getNodeContext()).setNodeId(this.newNodeId("HelloWorld/ScalarTypes/" + name)).setAccessLevel(AccessLevel.READ_WRITE).setUserAccessLevel(AccessLevel.READ_WRITE).setBrowseName(this.newQualifiedName(name)).setDisplayName(LocalizedText.english(name)).setDataType(typeId).setTypeDefinition(Identifiers.BaseDataVariableType).build();
            node.setValue(new DataValue(variant));
            node.getFilterChain().addLast((AttributeFilter)new AttributeLoggingFilter(AttributeId.Value::equals));
            this.getNodeManager().addNode(node);
            scalarTypesFolder.addOrganizes(node);
        }
    }

    private void addWriteOnlyNodes(UaFolderNode rootNode) {
        UaFolderNode writeOnlyFolder = new UaFolderNode(this.getNodeContext(), this.newNodeId("HelloWorld/WriteOnly"), this.newQualifiedName("WriteOnly"), LocalizedText.english("WriteOnly"));
        this.getNodeManager().addNode(writeOnlyFolder);
        rootNode.addOrganizes(writeOnlyFolder);
        String name = "String";
        UaVariableNode node = new UaVariableNode.UaVariableNodeBuilder(this.getNodeContext()).setNodeId(this.newNodeId("HelloWorld/WriteOnly/" + name)).setAccessLevel(AccessLevel.WRITE_ONLY).setUserAccessLevel(AccessLevel.WRITE_ONLY).setBrowseName(this.newQualifiedName(name)).setDisplayName(LocalizedText.english(name)).setDataType(Identifiers.String).setTypeDefinition(Identifiers.BaseDataVariableType).build();
        node.setValue(new DataValue(new Variant("can't read this")));
        this.getNodeManager().addNode(node);
        writeOnlyFolder.addOrganizes(node);
    }

    private void addAdminReadableNodes(UaFolderNode rootNode) {
        UaFolderNode adminFolder = new UaFolderNode(this.getNodeContext(), this.newNodeId("HelloWorld/OnlyAdminCanRead"), this.newQualifiedName("OnlyAdminCanRead"), LocalizedText.english("OnlyAdminCanRead"));
        this.getNodeManager().addNode(adminFolder);
        rootNode.addOrganizes(adminFolder);
        String name = "String";
        UaVariableNode node = new UaVariableNode.UaVariableNodeBuilder(this.getNodeContext()).setNodeId(this.newNodeId("HelloWorld/OnlyAdminCanRead/" + name)).setAccessLevel(AccessLevel.READ_WRITE).setBrowseName(this.newQualifiedName(name)).setDisplayName(LocalizedText.english(name)).setDataType(Identifiers.String).setTypeDefinition(Identifiers.BaseDataVariableType).build();
        node.setValue(new DataValue(new Variant("shh... don't tell the lusers")));
        node.getFilterChain().addLast((AttributeFilter)new RestrictedAccessFilter(identity -> {
            if ("admin".equals(identity)) {
                return AccessLevel.READ_WRITE;
            }
            return AccessLevel.NONE;
        }));
        this.getNodeManager().addNode(node);
        adminFolder.addOrganizes(node);
    }

    private void addAdminWritableNodes(UaFolderNode rootNode) {
        UaFolderNode adminFolder = new UaFolderNode(this.getNodeContext(), this.newNodeId("HelloWorld/OnlyAdminCanWrite"), this.newQualifiedName("OnlyAdminCanWrite"), LocalizedText.english("OnlyAdminCanWrite"));
        this.getNodeManager().addNode(adminFolder);
        rootNode.addOrganizes(adminFolder);
        String name = "String";
        UaVariableNode node = new UaVariableNode.UaVariableNodeBuilder(this.getNodeContext()).setNodeId(this.newNodeId("HelloWorld/OnlyAdminCanWrite/" + name)).setAccessLevel(AccessLevel.READ_WRITE).setBrowseName(this.newQualifiedName(name)).setDisplayName(LocalizedText.english(name)).setDataType(Identifiers.String).setTypeDefinition(Identifiers.BaseDataVariableType).build();
        node.setValue(new DataValue(new Variant("admin was here")));
        node.getFilterChain().addLast((AttributeFilter)new RestrictedAccessFilter(identity -> {
            if ("admin".equals(identity)) {
                return AccessLevel.READ_WRITE;
            }
            return AccessLevel.READ_ONLY;
        }));
        this.getNodeManager().addNode(node);
        adminFolder.addOrganizes(node);
    }

    private void addDynamicNodes(UaFolderNode rootNode) {
        UaFolderNode dynamicFolder = new UaFolderNode(this.getNodeContext(), this.newNodeId("HelloWorld/Dynamic"), this.newQualifiedName("Dynamic"), LocalizedText.english("Dynamic"));
        this.getNodeManager().addNode(dynamicFolder);
        rootNode.addOrganizes(dynamicFolder);
        String name = "Boolean";
        NodeId typeId = Identifiers.Boolean;
        Variant variant = new Variant(false);
        UaVariableNode node = new UaVariableNode.UaVariableNodeBuilder(this.getNodeContext()).setNodeId(this.newNodeId("HelloWorld/Dynamic/" + name)).setAccessLevel(AccessLevel.READ_WRITE).setBrowseName(this.newQualifiedName(name)).setDisplayName(LocalizedText.english(name)).setDataType(typeId).setTypeDefinition(Identifiers.BaseDataVariableType).build();
        node.setValue(new DataValue(variant));
        node.getFilterChain().addLast(new AttributeLoggingFilter(), AttributeFilters.getValue(ctx -> new DataValue(new Variant(this.random.nextBoolean()))));
        this.getNodeManager().addNode(node);
        dynamicFolder.addOrganizes(node);
        name = "Int32";
        typeId = Identifiers.Int32;
        variant = new Variant(0);
        node = new UaVariableNode.UaVariableNodeBuilder(this.getNodeContext()).setNodeId(this.newNodeId("HelloWorld/Dynamic/" + name)).setAccessLevel(AccessLevel.READ_WRITE).setBrowseName(this.newQualifiedName(name)).setDisplayName(LocalizedText.english(name)).setDataType(typeId).setTypeDefinition(Identifiers.BaseDataVariableType).build();
        node.setValue(new DataValue(variant));
        node.getFilterChain().addLast(new AttributeLoggingFilter(), AttributeFilters.getValue(ctx -> new DataValue(new Variant(this.random.nextInt()))));
        this.getNodeManager().addNode(node);
        dynamicFolder.addOrganizes(node);
        name = "Double";
        typeId = Identifiers.Double;
        variant = new Variant(0.0);
        node = new UaVariableNode.UaVariableNodeBuilder(this.getNodeContext()).setNodeId(this.newNodeId("HelloWorld/Dynamic/" + name)).setAccessLevel(AccessLevel.READ_WRITE).setBrowseName(this.newQualifiedName(name)).setDisplayName(LocalizedText.english(name)).setDataType(typeId).setTypeDefinition(Identifiers.BaseDataVariableType).build();
        node.setValue(new DataValue(variant));
        node.getFilterChain().addLast(new AttributeLoggingFilter(), AttributeFilters.getValue(ctx -> new DataValue(new Variant(this.random.nextDouble()))));
        this.getNodeManager().addNode(node);
        dynamicFolder.addOrganizes(node);
    }

    private void addDataAccessNodes(UaFolderNode rootNode) {
        UaFolderNode dataAccessFolder = new UaFolderNode(this.getNodeContext(), this.newNodeId("HelloWorld/DataAccess"), this.newQualifiedName("DataAccess"), LocalizedText.english("DataAccess"));
        this.getNodeManager().addNode(dataAccessFolder);
        rootNode.addOrganizes(dataAccessFolder);
        try {
            AnalogItemTypeNode node = (AnalogItemTypeNode)this.getNodeFactory().createNode(this.newNodeId("HelloWorld/DataAccess/AnalogValue"), Identifiers.AnalogItemType, new NodeFactory.InstantiationCallback(){

                @Override
                public boolean includeOptionalNode(NodeId typeDefinitionId, QualifiedName browseName) {
                    return true;
                }
            });
            node.setBrowseName(this.newQualifiedName("AnalogValue"));
            node.setDisplayName(LocalizedText.english("AnalogValue"));
            node.setDataType(Identifiers.Double);
            node.setValue(new DataValue(new Variant(3.14)));
            node.setEURange(new Range(0.0, 100.0));
            this.getNodeManager().addNode(node);
            dataAccessFolder.addOrganizes(node);
        }
        catch (UaException e) {
            this.logger.error("Error creating AnalogItemType instance: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void addSqrtMethod(UaFolderNode folderNode) {
        UaMethodNode methodNode = UaMethodNode.builder(this.getNodeContext()).setNodeId(this.newNodeId("HelloWorld/sqrt(x)")).setBrowseName(this.newQualifiedName("sqrt(x)")).setDisplayName(new LocalizedText(null, "sqrt(x)")).setDescription(LocalizedText.english("Returns the correctly rounded positive square root of a double value.")).build();
        SqrtMethod sqrtMethod = new SqrtMethod(methodNode);
        methodNode.setInputArguments(sqrtMethod.getInputArguments());
        methodNode.setOutputArguments(sqrtMethod.getOutputArguments());
        methodNode.setInvocationHandler(sqrtMethod);
        this.getNodeManager().addNode(methodNode);
        methodNode.addReference(new Reference(methodNode.getNodeId(), Identifiers.HasComponent, folderNode.getNodeId().expanded(), false));
    }

    private void addGenerateEventMethod(UaFolderNode folderNode) {
        UaMethodNode methodNode = UaMethodNode.builder(this.getNodeContext()).setNodeId(this.newNodeId("HelloWorld/generateEvent(eventTypeId)")).setBrowseName(this.newQualifiedName("generateEvent(eventTypeId)")).setDisplayName(new LocalizedText(null, "generateEvent(eventTypeId)")).setDescription(LocalizedText.english("Generate an Event with the TypeDefinition indicated by eventTypeId.")).build();
        GenerateEventMethod generateEventMethod = new GenerateEventMethod(methodNode);
        methodNode.setInputArguments(generateEventMethod.getInputArguments());
        methodNode.setOutputArguments(generateEventMethod.getOutputArguments());
        methodNode.setInvocationHandler(generateEventMethod);
        this.getNodeManager().addNode(methodNode);
        methodNode.addReference(new Reference(methodNode.getNodeId(), Identifiers.HasComponent, folderNode.getNodeId().expanded(), false));
    }

    private void addCustomObjectTypeAndInstance(UaFolderNode rootFolder) {
        UaObjectTypeNode objectTypeNode = UaObjectTypeNode.builder(this.getNodeContext()).setNodeId(this.newNodeId("ObjectTypes/MyObjectType")).setBrowseName(this.newQualifiedName("MyObjectType")).setDisplayName(LocalizedText.english("MyObjectType")).setIsAbstract(false).build();
        UaVariableNode foo = UaVariableNode.builder(this.getNodeContext()).setNodeId(this.newNodeId("ObjectTypes/MyObjectType.Foo")).setAccessLevel(AccessLevel.READ_WRITE).setBrowseName(this.newQualifiedName("Foo")).setDisplayName(LocalizedText.english("Foo")).setDataType(Identifiers.Int16).setTypeDefinition(Identifiers.BaseDataVariableType).build();
        foo.addReference(new Reference(foo.getNodeId(), Identifiers.HasModellingRule, Identifiers.ModellingRule_Mandatory.expanded(), true));
        foo.setValue(new DataValue(new Variant(0)));
        objectTypeNode.addComponent(foo);
        UaVariableNode bar = UaVariableNode.builder(this.getNodeContext()).setNodeId(this.newNodeId("ObjectTypes/MyObjectType.Bar")).setAccessLevel(AccessLevel.READ_WRITE).setBrowseName(this.newQualifiedName("Bar")).setDisplayName(LocalizedText.english("Bar")).setDataType(Identifiers.String).setTypeDefinition(Identifiers.BaseDataVariableType).build();
        bar.addReference(new Reference(bar.getNodeId(), Identifiers.HasModellingRule, Identifiers.ModellingRule_Mandatory.expanded(), true));
        bar.setValue(new DataValue(new Variant("bar")));
        objectTypeNode.addComponent(bar);
        this.getServer().getObjectTypeManager().registerObjectType(objectTypeNode.getNodeId(), UaObjectNode.class, UaObjectNode::new);
        objectTypeNode.addReference(new Reference(objectTypeNode.getNodeId(), Identifiers.HasSubtype, Identifiers.BaseObjectType.expanded(), false));
        this.getNodeManager().addNode(objectTypeNode);
        this.getNodeManager().addNode(foo);
        this.getNodeManager().addNode(bar);
        try {
            UaObjectNode myObject = (UaObjectNode)this.getNodeFactory().createNode(this.newNodeId("HelloWorld/MyObject"), objectTypeNode.getNodeId());
            myObject.setBrowseName(this.newQualifiedName("MyObject"));
            myObject.setDisplayName(LocalizedText.english("MyObject"));
            rootFolder.addOrganizes(myObject);
            myObject.addReference(new Reference(myObject.getNodeId(), Identifiers.Organizes, rootFolder.getNodeId().expanded(), false));
        }
        catch (UaException e) {
            this.logger.error("Error creating MyObjectType instance: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void registerCustomEnumType() throws Exception {
        NodeId dataTypeId = CustomEnumType.TYPE_ID.toNodeIdOrThrow(this.getServer().getNamespaceTable());
        this.dictionaryManager.registerEnumCodec(new CustomEnumType.Codec().asBinaryCodec(), "CustomEnumType", dataTypeId);
        UaNode node = (UaNode)this.getNodeManager().get(dataTypeId);
        if (node instanceof UaDataTypeNode) {
            UaDataTypeNode dataTypeNode = (UaDataTypeNode)node;
            dataTypeNode.setEnumStrings(new LocalizedText[]{LocalizedText.english("Field0"), LocalizedText.english("Field1"), LocalizedText.english("Field2")});
        }
        EnumField[] fields = new EnumField[]{new EnumField(0L, LocalizedText.english("Field0"), LocalizedText.NULL_VALUE, "Field0"), new EnumField(1L, LocalizedText.english("Field1"), LocalizedText.NULL_VALUE, "Field1"), new EnumField(2L, LocalizedText.english("Field2"), LocalizedText.NULL_VALUE, "Field2")};
        EnumDefinition definition = new EnumDefinition(fields);
        EnumDescription description = new EnumDescription(dataTypeId, new QualifiedName(this.getNamespaceIndex(), "CustomEnumType"), definition, Unsigned.ubyte(BuiltinDataType.Int32.getTypeId()));
        this.dictionaryManager.registerEnumDescription(description);
    }

    private void registerCustomStructType() throws Exception {
        NodeId dataTypeId = CustomStructType.TYPE_ID.toNodeIdOrThrow(this.getServer().getNamespaceTable());
        NodeId binaryEncodingId = CustomStructType.BINARY_ENCODING_ID.toNodeIdOrThrow(this.getServer().getNamespaceTable());
        this.dictionaryManager.registerStructureCodec(new CustomStructType.Codec().asBinaryCodec(), "CustomStructType", dataTypeId, binaryEncodingId);
        StructureField[] fields = new StructureField[]{new StructureField("foo", LocalizedText.NULL_VALUE, Identifiers.String, -1, null, this.getServer().getConfig().getLimits().getMaxStringLength(), false), new StructureField("bar", LocalizedText.NULL_VALUE, Identifiers.UInt32, -1, null, Unsigned.uint(0), false), new StructureField("baz", LocalizedText.NULL_VALUE, Identifiers.Boolean, -1, null, Unsigned.uint(0), false), new StructureField("customEnumType", LocalizedText.NULL_VALUE, CustomEnumType.TYPE_ID.toNodeIdOrThrow(this.getServer().getNamespaceTable()), -1, null, Unsigned.uint(0), false)};
        StructureDefinition definition = new StructureDefinition(binaryEncodingId, Identifiers.Structure, StructureType.Structure, fields);
        StructureDescription description = new StructureDescription(dataTypeId, new QualifiedName(this.getNamespaceIndex(), "CustomStructType"), definition);
        this.dictionaryManager.registerStructureDescription(description, binaryEncodingId);
    }

    private void registerCustomUnionType() throws Exception {
        NodeId dataTypeId = CustomUnionType.TYPE_ID.toNodeIdOrThrow(this.getServer().getNamespaceTable());
        NodeId binaryEncodingId = CustomUnionType.BINARY_ENCODING_ID.toNodeIdOrThrow(this.getServer().getNamespaceTable());
        this.dictionaryManager.registerUnionCodec(new CustomUnionType.Codec().asBinaryCodec(), "CustomUnionType", dataTypeId, binaryEncodingId);
        StructureField[] fields = new StructureField[]{new StructureField("foo", LocalizedText.NULL_VALUE, Identifiers.UInt32, -1, null, this.getServer().getConfig().getLimits().getMaxStringLength(), false), new StructureField("bar", LocalizedText.NULL_VALUE, Identifiers.String, -1, null, Unsigned.uint(0), false)};
        StructureDefinition definition = new StructureDefinition(binaryEncodingId, Identifiers.Structure, StructureType.Union, fields);
        StructureDescription description = new StructureDescription(dataTypeId, new QualifiedName(this.getNamespaceIndex(), "CustomUnionType"), definition);
        this.dictionaryManager.registerStructureDescription(description, binaryEncodingId);
    }

    private void addCustomEnumTypeVariable(UaFolderNode rootFolder) throws Exception {
        NodeId dataTypeId = CustomEnumType.TYPE_ID.toNodeIdOrThrow(this.getServer().getNamespaceTable());
        UaVariableNode customEnumTypeVariable = UaVariableNode.builder(this.getNodeContext()).setNodeId(this.newNodeId("HelloWorld/CustomEnumTypeVariable")).setAccessLevel(AccessLevel.READ_WRITE).setUserAccessLevel(AccessLevel.READ_WRITE).setBrowseName(this.newQualifiedName("CustomEnumTypeVariable")).setDisplayName(LocalizedText.english("CustomEnumTypeVariable")).setDataType(dataTypeId).setTypeDefinition(Identifiers.BaseDataVariableType).build();
        customEnumTypeVariable.setValue(new DataValue(new Variant(CustomEnumType.Field1)));
        this.getNodeManager().addNode(customEnumTypeVariable);
        customEnumTypeVariable.addReference(new Reference(customEnumTypeVariable.getNodeId(), Identifiers.Organizes, rootFolder.getNodeId().expanded(), false));
    }

    private void addCustomStructTypeVariable(UaFolderNode rootFolder) throws Exception {
        NodeId dataTypeId = CustomStructType.TYPE_ID.toNodeIdOrThrow(this.getServer().getNamespaceTable());
        NodeId binaryEncodingId = CustomStructType.BINARY_ENCODING_ID.toNodeIdOrThrow(this.getServer().getNamespaceTable());
        UaVariableNode customStructTypeVariable = UaVariableNode.builder(this.getNodeContext()).setNodeId(this.newNodeId("HelloWorld/CustomStructTypeVariable")).setAccessLevel(AccessLevel.READ_WRITE).setUserAccessLevel(AccessLevel.READ_WRITE).setBrowseName(this.newQualifiedName("CustomStructTypeVariable")).setDisplayName(LocalizedText.english("CustomStructTypeVariable")).setDataType(dataTypeId).setTypeDefinition(Identifiers.BaseDataVariableType).build();
        CustomStructType value = new CustomStructType("foo", Unsigned.uint(42), true, CustomEnumType.Field0);
        ExtensionObject xo = ExtensionObject.encodeDefaultBinary(this.getServer().getSerializationContext(), value, binaryEncodingId);
        customStructTypeVariable.setValue(new DataValue(new Variant(xo)));
        this.getNodeManager().addNode(customStructTypeVariable);
        customStructTypeVariable.addReference(new Reference(customStructTypeVariable.getNodeId(), Identifiers.Organizes, rootFolder.getNodeId().expanded(), false));
    }

    private void addCustomUnionTypeVariable(UaFolderNode rootFolder) throws Exception {
        NodeId dataTypeId = CustomUnionType.TYPE_ID.toNodeIdOrThrow(this.getServer().getNamespaceTable());
        NodeId binaryEncodingId = CustomUnionType.BINARY_ENCODING_ID.toNodeIdOrThrow(this.getServer().getNamespaceTable());
        UaVariableNode customUnionTypeVariable = UaVariableNode.builder(this.getNodeContext()).setNodeId(this.newNodeId("HelloWorld/CustomUnionTypeVariable")).setAccessLevel(AccessLevel.READ_WRITE).setUserAccessLevel(AccessLevel.READ_WRITE).setBrowseName(this.newQualifiedName("CustomUnionTypeVariable")).setDisplayName(LocalizedText.english("CustomUnionTypeVariable")).setDataType(dataTypeId).setTypeDefinition(Identifiers.BaseDataVariableType).build();
        CustomUnionType value = CustomUnionType.ofBar("hello");
        ExtensionObject xo = ExtensionObject.encodeDefaultBinary(this.getServer().getSerializationContext(), value, binaryEncodingId);
        customUnionTypeVariable.setValue(new DataValue(new Variant(xo)));
        this.getNodeManager().addNode(customUnionTypeVariable);
        customUnionTypeVariable.addReference(new Reference(customUnionTypeVariable.getNodeId(), Identifiers.Organizes, rootFolder.getNodeId().expanded(), false));
    }

    @Override
    public void onDataItemsCreated(List<DataItem> dataItems) {
        this.subscriptionModel.onDataItemsCreated(dataItems);
    }

    @Override
    public void onDataItemsModified(List<DataItem> dataItems) {
        this.subscriptionModel.onDataItemsModified(dataItems);
    }

    @Override
    public void onDataItemsDeleted(List<DataItem> dataItems) {
        this.subscriptionModel.onDataItemsDeleted(dataItems);
    }

    @Override
    public void onMonitoringModeChanged(List<MonitoredItem> monitoredItems) {
        this.subscriptionModel.onMonitoringModeChanged(monitoredItems);
    }
}

