/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.nodes;

import com.google.common.collect.Lists;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.NodeCache;
import org.eclipse.milo.opcua.sdk.client.api.nodes.Node;
import org.eclipse.milo.opcua.sdk.client.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.core.QualifiedProperty;
import org.eclipse.milo.opcua.sdk.core.util.StreamUtil;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseDirection;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseResultMask;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResult;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteValue;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;

public abstract class UaNode
implements Node {
    protected final NodeCache nodeCache;
    protected final OpcUaClient client;
    protected final NodeId nodeId;

    public UaNode(OpcUaClient client, NodeId nodeId) {
        this.client = client;
        this.nodeId = nodeId;
        this.nodeCache = client.getNodeCache();
    }

    protected CompletableFuture<PropertyNode> getPropertyNode(QualifiedProperty<?> property) {
        return property.getQualifiedName(this.client.getNamespaceTable()).map(this::getPropertyNode).orElse(FutureUtils.failedUaFuture((long)2151546880L));
    }

    protected CompletableFuture<PropertyNode> getPropertyNode(QualifiedName browseName) {
        UInteger nodeClassMask = Unsigned.uint((int)NodeClass.Variable.getValue());
        UInteger resultMask = Unsigned.uint((int)BrowseResultMask.BrowseName.getValue());
        CompletableFuture<BrowseResult> future = this.client.browse(new BrowseDescription(this.nodeId, BrowseDirection.Forward, Identifiers.HasProperty, Boolean.valueOf(false), nodeClassMask, resultMask));
        return future.thenCompose(result -> {
            List references = ConversionUtil.l((Object[])result.getReferences());
            Optional node = references.stream().filter(r -> browseName.equals((Object)r.getBrowseName())).flatMap(r -> {
                Optional<PropertyNode> opt = r.getNodeId().local(this.client.getNamespaceTable()).map(id -> new PropertyNode(this.client, (NodeId)id));
                return StreamUtil.opt2stream(opt);
            }).findFirst();
            return node.map(CompletableFuture::completedFuture).orElse(FutureUtils.failedUaFuture((long)2151546880L));
        });
    }

    protected <T> CompletableFuture<T> getProperty(QualifiedProperty<T> property) {
        return ((CompletableFuture)this.getPropertyNode(property).thenCompose(VariableNode::getValue)).thenApply(value -> this.cast(value, property.getJavaType()));
    }

    protected <T> CompletableFuture<StatusCode> setProperty(QualifiedProperty<T> property, T value) {
        return this.getPropertyNode(property).thenCompose(node -> node.setValue(value));
    }

    protected CompletableFuture<DataValue> readProperty(QualifiedProperty<?> property) {
        return this.getPropertyNode(property).thenCompose(VariableNode::readValue);
    }

    protected CompletableFuture<StatusCode> writeProperty(QualifiedProperty<?> property, DataValue value) {
        return this.getPropertyNode(property).thenCompose(node -> node.writeValue(value));
    }

    protected CompletableFuture<DataValue> readAttribute(AttributeId attributeId) {
        Optional<DataValue> opt = AttributeId.BASE_NODE_ATTRIBUTES.contains((Object)attributeId) ? this.nodeCache.getAttribute(this.nodeId, attributeId) : Optional.empty();
        return opt.map(CompletableFuture::completedFuture).orElseGet(() -> {
            ReadValueId readValueId = new ReadValueId(this.nodeId, attributeId.uid(), null, QualifiedName.NULL_VALUE);
            CompletableFuture<ReadResponse> future = this.client.read(0.0, TimestampsToReturn.Both, Lists.newArrayList((Object[])new ReadValueId[]{readValueId}));
            return future.thenApply(response -> {
                DataValue value = (DataValue)ConversionUtil.l((Object[])response.getResults()).get(0);
                if (attributeId != AttributeId.Value) {
                    this.nodeCache.putAttribute(this.nodeId, attributeId, value);
                }
                return value;
            });
        });
    }

    protected CompletableFuture<StatusCode> writeAttribute(AttributeId attributeId, DataValue value) {
        WriteValue writeValue = new WriteValue(this.nodeId, attributeId.uid(), null, value);
        return this.client.write(Lists.newArrayList((Object[])new WriteValue[]{writeValue})).thenApply(response -> {
            StatusCode statusCode = (StatusCode)ConversionUtil.l((Object[])response.getResults()).get(0);
            if (statusCode.isGood()) {
                this.nodeCache.invalidate(this.nodeId, attributeId);
            }
            return statusCode;
        });
    }

    protected <T> CompletableFuture<T> getAttributeOrFail(CompletableFuture<DataValue> readFuture) {
        return readFuture.thenCompose(value -> {
            if (value.getStatusCode().isGood()) {
                try {
                    return CompletableFuture.completedFuture(value.getValue().getValue());
                }
                catch (Throwable t) {
                    return FutureUtils.failedUaFuture((Throwable)t, (long)2155085824L);
                }
            }
            return FutureUtils.failedUaFuture((StatusCode)value.getStatusCode());
        });
    }

    @Override
    public CompletableFuture<NodeId> getNodeId() {
        return this.getAttributeOrFail(this.readNodeId());
    }

    @Override
    public CompletableFuture<NodeClass> getNodeClass() {
        return this.getAttributeOrFail(this.readNodeClass()).thenApply(NodeClass::from);
    }

    @Override
    public CompletableFuture<QualifiedName> getBrowseName() {
        return this.getAttributeOrFail(this.readBrowseName());
    }

    @Override
    public CompletableFuture<LocalizedText> getDisplayName() {
        return this.getAttributeOrFail(this.readDisplayName());
    }

    @Override
    public CompletableFuture<LocalizedText> getDescription() {
        return this.getAttributeOrFail(this.readDescription());
    }

    @Override
    public CompletableFuture<UInteger> getWriteMask() {
        return this.getAttributeOrFail(this.readWriteMask());
    }

    @Override
    public CompletableFuture<UInteger> getUserWriteMask() {
        return this.getAttributeOrFail(this.readUserWriteMask());
    }

    @Override
    public CompletableFuture<StatusCode> setNodeId(NodeId nodeId) {
        return this.writeNodeId(DataValue.valueOnly((Variant)new Variant((Object)nodeId)));
    }

    @Override
    public CompletableFuture<StatusCode> setNodeClass(NodeClass nodeClass) {
        return this.writeNodeClass(DataValue.valueOnly((Variant)new Variant((Object)nodeClass)));
    }

    @Override
    public CompletableFuture<StatusCode> setBrowseName(QualifiedName browseName) {
        return this.writeBrowseName(DataValue.valueOnly((Variant)new Variant((Object)browseName)));
    }

    @Override
    public CompletableFuture<StatusCode> setDisplayName(LocalizedText displayName) {
        return this.writeDisplayName(DataValue.valueOnly((Variant)new Variant((Object)displayName)));
    }

    @Override
    public CompletableFuture<StatusCode> setDescription(LocalizedText description) {
        return this.writeDescription(DataValue.valueOnly((Variant)new Variant((Object)description)));
    }

    @Override
    public CompletableFuture<StatusCode> setWriteMask(UInteger writeMask) {
        return this.writeWriteMask(DataValue.valueOnly((Variant)new Variant((Object)writeMask)));
    }

    @Override
    public CompletableFuture<StatusCode> setUserWriteMask(UInteger userWriteMask) {
        return this.writeUserWriteMask(DataValue.valueOnly((Variant)new Variant((Object)userWriteMask)));
    }

    @Override
    public CompletableFuture<DataValue> readNodeId() {
        return this.readAttribute(AttributeId.NodeId);
    }

    @Override
    public CompletableFuture<DataValue> readNodeClass() {
        return this.readAttribute(AttributeId.NodeClass);
    }

    @Override
    public CompletableFuture<DataValue> readBrowseName() {
        return this.readAttribute(AttributeId.BrowseName);
    }

    @Override
    public CompletableFuture<DataValue> readDisplayName() {
        return this.readAttribute(AttributeId.DisplayName);
    }

    @Override
    public CompletableFuture<DataValue> readDescription() {
        return this.readAttribute(AttributeId.Description);
    }

    @Override
    public CompletableFuture<DataValue> readWriteMask() {
        return this.readAttribute(AttributeId.WriteMask);
    }

    @Override
    public CompletableFuture<DataValue> readUserWriteMask() {
        return this.readAttribute(AttributeId.UserWriteMask);
    }

    @Override
    public CompletableFuture<StatusCode> writeNodeId(DataValue value) {
        return this.writeAttribute(AttributeId.NodeId, value);
    }

    @Override
    public CompletableFuture<StatusCode> writeNodeClass(DataValue value) {
        return this.writeAttribute(AttributeId.NodeClass, value);
    }

    @Override
    public CompletableFuture<StatusCode> writeBrowseName(DataValue value) {
        return this.writeAttribute(AttributeId.BrowseName, value);
    }

    @Override
    public CompletableFuture<StatusCode> writeDisplayName(DataValue value) {
        return this.writeAttribute(AttributeId.DisplayName, value);
    }

    @Override
    public CompletableFuture<StatusCode> writeDescription(DataValue value) {
        return this.writeAttribute(AttributeId.Description, value);
    }

    @Override
    public CompletableFuture<StatusCode> writeWriteMask(DataValue value) {
        return this.writeAttribute(AttributeId.WriteMask, value);
    }

    @Override
    public CompletableFuture<StatusCode> writeUserWriteMask(DataValue value) {
        return this.writeAttribute(AttributeId.UserWriteMask, value);
    }

    protected <T> T cast(Object o, Class<T> clazz) {
        if (UaEnumeration.class.isAssignableFrom(clazz) && o instanceof Integer) {
            try {
                Object enumeration = clazz.getMethod("from", Integer.class).invoke(null, (Integer)o);
                return clazz.cast(enumeration);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                return null;
            }
        }
        if (o instanceof ExtensionObject) {
            ExtensionObject xo = (ExtensionObject)o;
            Object decoded = xo.decode(this.client.getSerializationContext());
            return clazz.cast(decoded);
        }
        if (o instanceof ExtensionObject[]) {
            ExtensionObject[] xos = (ExtensionObject[])o;
            Class<?> componentType = clazz.getComponentType();
            Object array = Array.newInstance(componentType, xos.length);
            for (int i = 0; i < xos.length; ++i) {
                ExtensionObject xo = xos[i];
                Object decoded = xo.decode(this.client.getSerializationContext());
                Array.set(array, i, componentType.cast(decoded));
            }
            return clazz.cast(array);
        }
        return clazz.cast(o);
    }
}

