/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.ExclusiveLimitStateMachineNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.LimitAlarmNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.TwoStateVariableNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.ExclusiveLimitAlarmType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaVariableNode;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;

public class ExclusiveLimitAlarmNode
extends LimitAlarmNode
implements ExclusiveLimitAlarmType {
    public ExclusiveLimitAlarmNode(OpcUaClient client, NodeId nodeId) {
        super(client, nodeId);
    }

    @Override
    public CompletableFuture<TwoStateVariableNode> getActiveStateNode() {
        return this.getVariableComponent("http://opcfoundation.org/UA/", "ActiveState").thenApply(TwoStateVariableNode.class::cast);
    }

    @Override
    public CompletableFuture<LocalizedText> getActiveState() {
        return ((CompletableFuture)this.getActiveStateNode().thenCompose(UaVariableNode::getValue)).thenApply(o -> this.cast(o, LocalizedText.class));
    }

    @Override
    public CompletableFuture<StatusCode> setActiveState(LocalizedText value) {
        return this.getActiveStateNode().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<ExclusiveLimitStateMachineNode> getLimitStateNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "LimitState").thenApply(ExclusiveLimitStateMachineNode.class::cast);
    }
}

