/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.ConditionNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.TwoStateVariableNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.AcknowledgeableConditionType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaVariableNode;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;

public class AcknowledgeableConditionNode
extends ConditionNode
implements AcknowledgeableConditionType {
    public AcknowledgeableConditionNode(OpcUaClient client, NodeId nodeId) {
        super(client, nodeId);
    }

    @Override
    public CompletableFuture<TwoStateVariableNode> getEnabledStateNode() {
        return this.getVariableComponent("http://opcfoundation.org/UA/", "EnabledState").thenApply(TwoStateVariableNode.class::cast);
    }

    @Override
    public CompletableFuture<LocalizedText> getEnabledState() {
        return ((CompletableFuture)this.getEnabledStateNode().thenCompose(UaVariableNode::getValue)).thenApply(o -> this.cast(o, LocalizedText.class));
    }

    @Override
    public CompletableFuture<StatusCode> setEnabledState(LocalizedText value) {
        return this.getEnabledStateNode().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<TwoStateVariableNode> getAckedStateNode() {
        return this.getVariableComponent("http://opcfoundation.org/UA/", "AckedState").thenApply(TwoStateVariableNode.class::cast);
    }

    @Override
    public CompletableFuture<LocalizedText> getAckedState() {
        return ((CompletableFuture)this.getAckedStateNode().thenCompose(UaVariableNode::getValue)).thenApply(o -> this.cast(o, LocalizedText.class));
    }

    @Override
    public CompletableFuture<StatusCode> setAckedState(LocalizedText value) {
        return this.getAckedStateNode().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<TwoStateVariableNode> getConfirmedStateNode() {
        return this.getVariableComponent("http://opcfoundation.org/UA/", "ConfirmedState").thenApply(TwoStateVariableNode.class::cast);
    }

    @Override
    public CompletableFuture<LocalizedText> getConfirmedState() {
        return ((CompletableFuture)this.getConfirmedStateNode().thenCompose(UaVariableNode::getValue)).thenApply(o -> this.cast(o, LocalizedText.class));
    }

    @Override
    public CompletableFuture<StatusCode> setConfirmedState(LocalizedText value) {
        return this.getConfirmedStateNode().thenCompose(node -> node.setValue(value));
    }
}

