/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client;

import com.google.common.collect.Maps;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.nodes.Node;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

public class TypeRegistry {
    private final ConcurrentMap<NodeId, TypeDefinition> typeDefinitions = Maps.newConcurrentMap();

    public void registerType(NodeId typeDefinition, Class<? extends Node> typeClass, Class<? extends UaNode> nodeClass, NodeFactory nodeFactory) {
        this.typeDefinitions.put(typeDefinition, new TypeDefinition(typeClass, nodeClass, nodeFactory));
    }

    public Optional<NodeFactory> getNodeFactory(NodeId typeDefinition) {
        TypeDefinition def = (TypeDefinition)this.typeDefinitions.get(typeDefinition);
        return Optional.ofNullable(def).map(d -> d.nodeFactory);
    }

    public static interface NodeFactory {
        public UaNode apply(OpcUaClient var1, NodeId var2);
    }

    private static class TypeDefinition {
        final Class<? extends Node> typeClass;
        final Class<? extends UaNode> nodeClass;
        final NodeFactory nodeFactory;

        private TypeDefinition(Class<? extends Node> typeClass, Class<? extends UaNode> nodeClass, NodeFactory nodeFactory) {
            this.typeClass = typeClass;
            this.nodeClass = nodeClass;
            this.nodeFactory = nodeFactory;
        }
    }
}

