/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.subscriptions;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaMonitoredItem;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MonitoringMode;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;

public class OpcUaMonitoredItem
implements UaMonitoredItem {
    private volatile BiConsumer<UaMonitoredItem, DataValue> valueConsumer;
    private volatile BiConsumer<UaMonitoredItem, Variant[]> eventConsumer;
    private volatile double requestedSamplingInterval = 0.0;
    private volatile UInteger requestedQueueSize = Unsigned.uint((int)0);
    private volatile StatusCode statusCode;
    private volatile double revisedSamplingInterval = 0.0;
    private volatile UInteger revisedQueueSize = Unsigned.uint((int)0);
    private volatile ExtensionObject filterResult;
    private volatile MonitoringMode monitoringMode = MonitoringMode.Disabled;
    private volatile ExtensionObject monitoringFilter;
    private final UInteger clientHandle;
    private final ReadValueId readValueId;
    private final UInteger monitoredItemId;

    public OpcUaMonitoredItem(UInteger clientHandle, ReadValueId readValueId, UInteger monitoredItemId, StatusCode statusCode, double revisedSamplingInterval, UInteger revisedQueueSize, ExtensionObject filterResult, MonitoringMode monitoringMode, ExtensionObject monitoringFilter) {
        this.clientHandle = clientHandle;
        this.readValueId = readValueId;
        this.monitoredItemId = monitoredItemId;
        this.statusCode = statusCode;
        this.revisedSamplingInterval = revisedSamplingInterval;
        this.revisedQueueSize = revisedQueueSize;
        this.filterResult = filterResult;
        this.monitoringMode = monitoringMode;
        this.monitoringFilter = monitoringFilter;
    }

    @Override
    public UInteger getClientHandle() {
        return this.clientHandle;
    }

    @Override
    public ReadValueId getReadValueId() {
        return this.readValueId;
    }

    @Override
    public UInteger getMonitoredItemId() {
        return this.monitoredItemId;
    }

    @Override
    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    @Override
    public double getRequestedSamplingInterval() {
        return this.requestedSamplingInterval;
    }

    @Override
    public double getRevisedSamplingInterval() {
        return this.revisedSamplingInterval;
    }

    @Override
    public UInteger getRequestedQueueSize() {
        return this.requestedQueueSize;
    }

    @Override
    public UInteger getRevisedQueueSize() {
        return this.revisedQueueSize;
    }

    @Override
    public ExtensionObject getFilterResult() {
        return this.filterResult;
    }

    @Override
    public MonitoringMode getMonitoringMode() {
        return this.monitoringMode;
    }

    @Override
    public ExtensionObject getMonitoringFilter() {
        return this.monitoringFilter;
    }

    @Override
    public void setValueConsumer(Consumer<DataValue> consumer) {
        this.valueConsumer = (item, value) -> consumer.accept((DataValue)value);
    }

    @Override
    public void setValueConsumer(BiConsumer<UaMonitoredItem, DataValue> valueBiConsumer) {
        this.valueConsumer = valueBiConsumer;
    }

    @Override
    public void setEventConsumer(Consumer<Variant[]> consumer) {
        this.eventConsumer = (item, event) -> consumer.accept((Variant[])event);
    }

    @Override
    public void setEventConsumer(BiConsumer<UaMonitoredItem, Variant[]> eventBiConsumer) {
        this.eventConsumer = eventBiConsumer;
    }

    void setStatusCode(StatusCode statusCode) {
        this.statusCode = statusCode;
    }

    void setFilterResult(ExtensionObject filterResult) {
        this.filterResult = filterResult;
    }

    void setRequestedSamplingInterval(double requestedSamplingInterval) {
        this.requestedSamplingInterval = requestedSamplingInterval;
    }

    void setRevisedSamplingInterval(double revisedSamplingInterval) {
        this.revisedSamplingInterval = revisedSamplingInterval;
    }

    void setRequestedQueueSize(UInteger requestedQueueSize) {
        this.requestedQueueSize = requestedQueueSize;
    }

    void setRevisedQueueSize(UInteger revisedQueueSize) {
        this.revisedQueueSize = revisedQueueSize;
    }

    void setMonitoringMode(MonitoringMode monitoringMode) {
        this.monitoringMode = monitoringMode;
    }

    void onValueArrived(DataValue value) {
        BiConsumer<UaMonitoredItem, DataValue> c = this.valueConsumer;
        if (c != null) {
            c.accept(this, value);
        }
    }

    void onEventArrived(Variant[] values) {
        BiConsumer<UaMonitoredItem, Variant[]> c = this.eventConsumer;
        if (c != null) {
            c.accept(this, values);
        }
    }
}

