/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.FiniteStateMachineNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.StateNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.TransitionNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.ShelvedStateMachineType;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;

public class ShelvedStateMachineNode
extends FiniteStateMachineNode
implements ShelvedStateMachineType {
    public ShelvedStateMachineNode(OpcUaClient client, NodeId nodeId) {
        super(client, nodeId);
    }

    public CompletableFuture<PropertyNode> unshelveTime() {
        return this.getPropertyNode(ShelvedStateMachineType.UNSHELVE_TIME.getBrowseName());
    }

    @Override
    public CompletableFuture<Double> getUnshelveTime() {
        return this.getProperty(ShelvedStateMachineType.UNSHELVE_TIME);
    }

    @Override
    public CompletableFuture<StatusCode> setUnshelveTime(Double value) {
        return this.setProperty(ShelvedStateMachineType.UNSHELVE_TIME, value);
    }

    public CompletableFuture<StateNode> unshelved() {
        return this.getObjectComponent(QualifiedName.parse((String)"0:Unshelved")).thenApply(StateNode.class::cast);
    }

    public CompletableFuture<StateNode> timedShelved() {
        return this.getObjectComponent(QualifiedName.parse((String)"0:TimedShelved")).thenApply(StateNode.class::cast);
    }

    public CompletableFuture<StateNode> oneShotShelved() {
        return this.getObjectComponent(QualifiedName.parse((String)"0:OneShotShelved")).thenApply(StateNode.class::cast);
    }

    public CompletableFuture<TransitionNode> unshelvedToTimedShelved() {
        return this.getObjectComponent(QualifiedName.parse((String)"0:UnshelvedToTimedShelved")).thenApply(TransitionNode.class::cast);
    }

    public CompletableFuture<TransitionNode> unshelvedToOneShotShelved() {
        return this.getObjectComponent(QualifiedName.parse((String)"0:UnshelvedToOneShotShelved")).thenApply(TransitionNode.class::cast);
    }

    public CompletableFuture<TransitionNode> timedShelvedToUnshelved() {
        return this.getObjectComponent(QualifiedName.parse((String)"0:TimedShelvedToUnshelved")).thenApply(TransitionNode.class::cast);
    }

    public CompletableFuture<TransitionNode> timedShelvedToOneShotShelved() {
        return this.getObjectComponent(QualifiedName.parse((String)"0:TimedShelvedToOneShotShelved")).thenApply(TransitionNode.class::cast);
    }

    public CompletableFuture<TransitionNode> oneShotShelvedToUnshelved() {
        return this.getObjectComponent(QualifiedName.parse((String)"0:OneShotShelvedToUnshelved")).thenApply(TransitionNode.class::cast);
    }

    public CompletableFuture<TransitionNode> oneShotShelvedToTimedShelved() {
        return this.getObjectComponent(QualifiedName.parse((String)"0:OneShotShelvedToTimedShelved")).thenApply(TransitionNode.class::cast);
    }
}

