/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.AddressSpaceFileNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.BaseObjectNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.NamespaceMetadataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.IdType;

public class NamespaceMetadataNode
extends BaseObjectNode
implements NamespaceMetadataType {
    public NamespaceMetadataNode(OpcUaClient client, NodeId nodeId) {
        super(client, nodeId);
    }

    public CompletableFuture<PropertyNode> namespaceUri() {
        return this.getPropertyNode(NamespaceMetadataType.NAMESPACE_URI.getBrowseName());
    }

    @Override
    public CompletableFuture<String> getNamespaceUri() {
        return this.getProperty(NamespaceMetadataType.NAMESPACE_URI);
    }

    @Override
    public CompletableFuture<StatusCode> setNamespaceUri(String value) {
        return this.setProperty(NamespaceMetadataType.NAMESPACE_URI, value);
    }

    public CompletableFuture<PropertyNode> namespaceVersion() {
        return this.getPropertyNode(NamespaceMetadataType.NAMESPACE_VERSION.getBrowseName());
    }

    @Override
    public CompletableFuture<String> getNamespaceVersion() {
        return this.getProperty(NamespaceMetadataType.NAMESPACE_VERSION);
    }

    @Override
    public CompletableFuture<StatusCode> setNamespaceVersion(String value) {
        return this.setProperty(NamespaceMetadataType.NAMESPACE_VERSION, value);
    }

    public CompletableFuture<PropertyNode> namespacePublicationDate() {
        return this.getPropertyNode(NamespaceMetadataType.NAMESPACE_PUBLICATION_DATE.getBrowseName());
    }

    @Override
    public CompletableFuture<DateTime> getNamespacePublicationDate() {
        return this.getProperty(NamespaceMetadataType.NAMESPACE_PUBLICATION_DATE);
    }

    @Override
    public CompletableFuture<StatusCode> setNamespacePublicationDate(DateTime value) {
        return this.setProperty(NamespaceMetadataType.NAMESPACE_PUBLICATION_DATE, value);
    }

    public CompletableFuture<PropertyNode> isNamespaceSubset() {
        return this.getPropertyNode(NamespaceMetadataType.IS_NAMESPACE_SUBSET.getBrowseName());
    }

    @Override
    public CompletableFuture<Boolean> getIsNamespaceSubset() {
        return this.getProperty(NamespaceMetadataType.IS_NAMESPACE_SUBSET);
    }

    @Override
    public CompletableFuture<StatusCode> setIsNamespaceSubset(Boolean value) {
        return this.setProperty(NamespaceMetadataType.IS_NAMESPACE_SUBSET, value);
    }

    public CompletableFuture<PropertyNode> staticNodeIdIdentifierTypes() {
        return this.getPropertyNode(NamespaceMetadataType.STATIC_NODE_ID_IDENTIFIER_TYPES.getBrowseName());
    }

    @Override
    public CompletableFuture<IdType[]> getStaticNodeIdIdentifierTypes() {
        return this.getProperty(NamespaceMetadataType.STATIC_NODE_ID_IDENTIFIER_TYPES);
    }

    @Override
    public CompletableFuture<StatusCode> setStaticNodeIdIdentifierTypes(IdType[] value) {
        return this.setProperty(NamespaceMetadataType.STATIC_NODE_ID_IDENTIFIER_TYPES, value);
    }

    public CompletableFuture<PropertyNode> staticNumericNodeIdRange() {
        return this.getPropertyNode(NamespaceMetadataType.STATIC_NUMERIC_NODE_ID_RANGE.getBrowseName());
    }

    @Override
    public CompletableFuture<String[]> getStaticNumericNodeIdRange() {
        return this.getProperty(NamespaceMetadataType.STATIC_NUMERIC_NODE_ID_RANGE);
    }

    @Override
    public CompletableFuture<StatusCode> setStaticNumericNodeIdRange(String[] value) {
        return this.setProperty(NamespaceMetadataType.STATIC_NUMERIC_NODE_ID_RANGE, value);
    }

    public CompletableFuture<PropertyNode> staticStringNodeIdPattern() {
        return this.getPropertyNode(NamespaceMetadataType.STATIC_STRING_NODE_ID_PATTERN.getBrowseName());
    }

    @Override
    public CompletableFuture<String[]> getStaticStringNodeIdPattern() {
        return this.getProperty(NamespaceMetadataType.STATIC_STRING_NODE_ID_PATTERN);
    }

    @Override
    public CompletableFuture<StatusCode> setStaticStringNodeIdPattern(String[] value) {
        return this.setProperty(NamespaceMetadataType.STATIC_STRING_NODE_ID_PATTERN, value);
    }

    public CompletableFuture<AddressSpaceFileNode> namespaceFile() {
        return this.getObjectComponent(QualifiedName.parse((String)"0:NamespaceFile")).thenApply(AddressSpaceFileNode.class::cast);
    }
}

