/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.api.identity;

import java.util.List;
import org.eclipse.milo.opcua.sdk.client.api.identity.IdentityProvider;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.enumerated.UserTokenType;
import org.eclipse.milo.opcua.stack.core.types.structured.AnonymousIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.SignatureData;
import org.eclipse.milo.opcua.stack.core.types.structured.UserIdentityToken;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.jooq.lambda.tuple.Tuple2;

public class AnonymousProvider
implements IdentityProvider {
    @Override
    public Tuple2<UserIdentityToken, SignatureData> getIdentityToken(EndpointDescription endpoint, ByteString serverNonce) throws Exception {
        List userIdentityTokens = ConversionUtil.l((Object[])endpoint.getUserIdentityTokens());
        return userIdentityTokens.stream().filter(t -> t.getTokenType() == UserTokenType.Anonymous).findFirst().map(policy -> {
            AnonymousIdentityToken token = new AnonymousIdentityToken(policy.getPolicyId());
            return new Tuple2((Object)token, (Object)new SignatureData());
        }).orElseThrow(() -> new Exception("no anonymous token policy found"));
    }

    public String toString() {
        return "AnonymousProvider{}";
    }
}

