/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.servicesets.impl;

import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.servicesets.MonitoredItemServiceSet;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateMonitoredItemsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateMonitoredItemsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteMonitoredItemsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteMonitoredItemsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifyMonitoredItemsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifyMonitoredItemsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.SetMonitoringModeRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.SetMonitoringModeResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.SetTriggeringRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.SetTriggeringResponse;
import org.eclipse.milo.opcua.stack.transport.server.ServiceRequestContext;

public class DefaultMonitoredItemServiceSet
implements MonitoredItemServiceSet {
    private final OpcUaServer server;

    public DefaultMonitoredItemServiceSet(OpcUaServer server) {
        this.server = server;
    }

    @Override
    public CreateMonitoredItemsResponse onCreateMonitoredItems(ServiceRequestContext context, CreateMonitoredItemsRequest request) throws UaException {
        Session session = this.server.getSessionManager().getSession(context, request.getRequestHeader());
        try {
            CreateMonitoredItemsResponse createMonitoredItemsResponse = session.getSubscriptionManager().createMonitoredItems(context, request);
            return createMonitoredItemsResponse;
        }
        catch (Throwable t) {
            session.getSessionDiagnostics().getCreateMonitoredItemsCount().incrementErrorCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementErrorCount();
            throw new UaException(t);
        }
        finally {
            session.getSessionDiagnostics().getCreateMonitoredItemsCount().incrementTotalCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementTotalCount();
        }
    }

    @Override
    public ModifyMonitoredItemsResponse onModifyMonitoredItems(ServiceRequestContext context, ModifyMonitoredItemsRequest request) throws UaException {
        Session session = this.server.getSessionManager().getSession(context, request.getRequestHeader());
        try {
            ModifyMonitoredItemsResponse modifyMonitoredItemsResponse = session.getSubscriptionManager().modifyMonitoredItems(context, request);
            return modifyMonitoredItemsResponse;
        }
        catch (Throwable t) {
            session.getSessionDiagnostics().getModifyMonitoredItemsCount().incrementErrorCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementErrorCount();
            throw new UaException(t);
        }
        finally {
            session.getSessionDiagnostics().getModifyMonitoredItemsCount().incrementTotalCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementTotalCount();
        }
    }

    @Override
    public DeleteMonitoredItemsResponse onDeleteMonitoredItems(ServiceRequestContext context, DeleteMonitoredItemsRequest request) throws UaException {
        Session session = this.server.getSessionManager().getSession(context, request.getRequestHeader());
        try {
            DeleteMonitoredItemsResponse deleteMonitoredItemsResponse = session.getSubscriptionManager().deleteMonitoredItems(context, request).get();
            return deleteMonitoredItemsResponse;
        }
        catch (Throwable t) {
            session.getSessionDiagnostics().getDeleteMonitoredItemsCount().incrementErrorCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementErrorCount();
            throw new UaException(t);
        }
        finally {
            session.getSessionDiagnostics().getDeleteMonitoredItemsCount().incrementTotalCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementTotalCount();
        }
    }

    @Override
    public SetMonitoringModeResponse onSetMonitoringMode(ServiceRequestContext context, SetMonitoringModeRequest request) throws UaException {
        Session session = this.server.getSessionManager().getSession(context, request.getRequestHeader());
        try {
            SetMonitoringModeResponse setMonitoringModeResponse = session.getSubscriptionManager().setMonitoringMode(context, request).get();
            return setMonitoringModeResponse;
        }
        catch (Throwable t) {
            session.getSessionDiagnostics().getSetMonitoringModeCount().incrementErrorCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementErrorCount();
            throw new UaException(t);
        }
        finally {
            session.getSessionDiagnostics().getSetMonitoringModeCount().incrementTotalCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementTotalCount();
        }
    }

    @Override
    public SetTriggeringResponse onSetTriggering(ServiceRequestContext context, SetTriggeringRequest request) throws UaException {
        Session session = this.server.getSessionManager().getSession(context, request.getRequestHeader());
        try {
            SetTriggeringResponse setTriggeringResponse = session.getSubscriptionManager().setTriggering(context, request).get();
            return setTriggeringResponse;
        }
        catch (Throwable t) {
            session.getSessionDiagnostics().getSetTriggeringCount().incrementErrorCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementErrorCount();
            throw new UaException(t);
        }
        finally {
            session.getSessionDiagnostics().getSetTriggeringCount().incrementTotalCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementTotalCount();
        }
    }
}

