/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.servicesets.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.milo.opcua.sdk.core.util.GroupMapCollate;
import org.eclipse.milo.opcua.sdk.server.AddressSpace;
import org.eclipse.milo.opcua.sdk.server.DiagnosticsContext;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.servicesets.AbstractServiceSet;
import org.eclipse.milo.opcua.sdk.server.servicesets.AttributeServiceSet;
import org.eclipse.milo.opcua.sdk.server.servicesets.impl.AccessController;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.UaRequestMessageType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadDetails;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadResult;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateDetails;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateResult;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteValue;
import org.eclipse.milo.opcua.stack.core.util.Lists;
import org.eclipse.milo.opcua.stack.transport.server.ServiceRequestContext;

public class DefaultAttributeServiceSet
extends AbstractServiceSet
implements AttributeServiceSet {
    private final OpcUaServer server;

    public DefaultAttributeServiceSet(OpcUaServer server) {
        this.server = server;
    }

    @Override
    public ReadResponse onRead(ServiceRequestContext context, ReadRequest request) throws UaException {
        Session session = this.server.getSessionManager().getSession(context, request.getRequestHeader());
        try {
            ReadResponse readResponse = this.read(request, session);
            return readResponse;
        }
        catch (UaException e) {
            session.getSessionDiagnostics().getReadCount().incrementErrorCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementErrorCount();
            throw e;
        }
        finally {
            session.getSessionDiagnostics().getReadCount().incrementTotalCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementTotalCount();
        }
    }

    @Override
    public HistoryReadResponse onHistoryRead(ServiceRequestContext context, HistoryReadRequest request) throws UaException {
        Session session = this.server.getSessionManager().getSession(context, request.getRequestHeader());
        try {
            HistoryReadResponse historyReadResponse = this.historyRead(request, session);
            return historyReadResponse;
        }
        catch (UaException e) {
            session.getSessionDiagnostics().getHistoryReadCount().incrementErrorCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementErrorCount();
            throw e;
        }
        finally {
            session.getSessionDiagnostics().getHistoryReadCount().incrementTotalCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementTotalCount();
        }
    }

    @Override
    public WriteResponse onWrite(ServiceRequestContext context, WriteRequest request) throws UaException {
        Session session = this.server.getSessionManager().getSession(context, request.getRequestHeader());
        try {
            WriteResponse writeResponse = this.write(request, session);
            return writeResponse;
        }
        catch (UaException e) {
            session.getSessionDiagnostics().getWriteCount().incrementErrorCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementErrorCount();
            throw e;
        }
        finally {
            session.getSessionDiagnostics().getWriteCount().incrementTotalCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementTotalCount();
        }
    }

    @Override
    public HistoryUpdateResponse onHistoryUpdate(ServiceRequestContext context, HistoryUpdateRequest request) throws UaException {
        Session session = this.server.getSessionManager().getSession(context, request.getRequestHeader());
        try {
            HistoryUpdateResponse historyUpdateResponse = this.historyUpdate(request, session);
            return historyUpdateResponse;
        }
        catch (UaException e) {
            session.getSessionDiagnostics().getHistoryUpdateCount().incrementErrorCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementErrorCount();
            throw e;
        }
        finally {
            session.getSessionDiagnostics().getHistoryUpdateCount().incrementTotalCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementTotalCount();
        }
    }

    private ReadResponse read(ReadRequest request, Session session) throws UaException {
        List nodesToRead = Lists.ofNullable((Object[])request.getNodesToRead());
        if (nodesToRead.isEmpty()) {
            throw new UaException(0x800F0000L);
        }
        if ((long)nodesToRead.size() > this.server.getConfig().getLimits().getMaxNodesPerRead().longValue()) {
            throw new UaException(0x80100000L);
        }
        if (request.getMaxAge() < 0.0) {
            throw new UaException(0x80700000L);
        }
        if (request.getTimestampsToReturn() == null) {
            throw new UaException(2150301696L);
        }
        Map<ReadValueId, AccessController.AccessResult> accessResults = this.server.getAccessController().checkReadAccess(session, nodesToRead);
        DiagnosticsContext diagnosticsContext = new DiagnosticsContext();
        List values = GroupMapCollate.groupMapCollate((List)nodesToRead, accessResults::get, accessResult -> group -> {
            if (accessResult instanceof AccessController.AccessResult.Denied) {
                AccessController.AccessResult.Denied denied = (AccessController.AccessResult.Denied)accessResult;
                return Collections.nCopies(group.size(), new DataValue(denied.statusCode()));
            }
            AddressSpace.ReadContext readContext = new AddressSpace.ReadContext(this.server, session, diagnosticsContext, request.getRequestHeader().getAuditEntryId(), request.getRequestHeader().getTimeoutHint(), request.getRequestHeader().getAdditionalHeader());
            return this.server.getAddressSpaceManager().read(readContext, request.getMaxAge(), request.getTimestampsToReturn(), (List<ReadValueId>)group);
        });
        DiagnosticInfo[] diagnosticInfos = diagnosticsContext.getDiagnosticInfos(nodesToRead);
        ResponseHeader header = DefaultAttributeServiceSet.createResponseHeader((UaRequestMessageType)request);
        return new ReadResponse(header, (DataValue[])values.toArray(DataValue[]::new), diagnosticInfos);
    }

    private HistoryReadResponse historyRead(HistoryReadRequest request, Session session) throws UaException {
        List nodesToRead = Lists.ofNullable((Object[])request.getNodesToRead());
        if (nodesToRead.isEmpty()) {
            throw new UaException(0x800F0000L);
        }
        if ((long)nodesToRead.size() > this.server.getConfig().getLimits().getMaxNodesPerRead().longValue()) {
            throw new UaException(0x80100000L);
        }
        if (request.getTimestampsToReturn() == null) {
            throw new UaException(2150301696L);
        }
        DiagnosticsContext<HistoryReadValueId> diagnosticsContext = new DiagnosticsContext<HistoryReadValueId>();
        AddressSpace.HistoryReadContext historyReadContext = new AddressSpace.HistoryReadContext(this.server, session, diagnosticsContext, request.getRequestHeader().getAuditEntryId(), request.getRequestHeader().getTimeoutHint(), request.getRequestHeader().getAdditionalHeader());
        ExtensionObject xo = request.getHistoryReadDetails();
        HistoryReadDetails details = (HistoryReadDetails)xo.decode(this.server.getStaticEncodingContext());
        List<HistoryReadResult> results = this.server.getAddressSpaceManager().historyRead(historyReadContext, details, request.getTimestampsToReturn(), nodesToRead);
        ResponseHeader header = DefaultAttributeServiceSet.createResponseHeader((UaRequestMessageType)request);
        DiagnosticInfo[] diagnosticInfos = diagnosticsContext.getDiagnosticInfos(nodesToRead);
        return new HistoryReadResponse(header, (HistoryReadResult[])results.toArray(HistoryReadResult[]::new), diagnosticInfos);
    }

    private WriteResponse write(WriteRequest request, Session session) throws UaException {
        List nodesToWrite = Lists.ofNullable((Object[])request.getNodesToWrite());
        if (nodesToWrite.isEmpty()) {
            throw new UaException(0x800F0000L);
        }
        if (nodesToWrite.size() > this.server.getConfig().getLimits().getMaxNodesPerWrite().intValue()) {
            throw new UaException(0x80100000L);
        }
        Map<WriteValue, AccessController.AccessResult> accessResults = this.server.getAccessController().checkWriteAccess(session, nodesToWrite);
        DiagnosticsContext diagnosticsContext = new DiagnosticsContext();
        List results = GroupMapCollate.groupMapCollate((List)nodesToWrite, accessResults::get, accessResult -> group -> {
            if (accessResult instanceof AccessController.AccessResult.Denied) {
                AccessController.AccessResult.Denied denied = (AccessController.AccessResult.Denied)accessResult;
                return Collections.nCopies(group.size(), denied.statusCode());
            }
            AddressSpace.WriteContext writeContext = new AddressSpace.WriteContext(this.server, session, diagnosticsContext, request.getRequestHeader().getAuditEntryId(), request.getRequestHeader().getTimeoutHint(), request.getRequestHeader().getAdditionalHeader());
            return this.server.getAddressSpaceManager().write(writeContext, (List<WriteValue>)group);
        });
        ResponseHeader header = DefaultAttributeServiceSet.createResponseHeader((UaRequestMessageType)request);
        DiagnosticInfo[] diagnosticInfos = diagnosticsContext.getDiagnosticInfos(nodesToWrite);
        return new WriteResponse(header, (StatusCode[])results.toArray(StatusCode[]::new), diagnosticInfos);
    }

    private HistoryUpdateResponse historyUpdate(HistoryUpdateRequest request, Session session) throws UaException {
        ExtensionObject[] historyUpdateDetails = Objects.requireNonNullElse(request.getHistoryUpdateDetails(), new ExtensionObject[0]);
        List<HistoryUpdateDetails> historyUpdateDetailsList = Stream.of(historyUpdateDetails).map(xo -> (HistoryUpdateDetails)xo.decode(this.server.getStaticEncodingContext())).collect(Collectors.toList());
        if (historyUpdateDetailsList.isEmpty()) {
            throw new UaException(0x800F0000L);
        }
        if (historyUpdateDetailsList.size() > this.server.getConfig().getLimits().getMaxNodesPerWrite().intValue()) {
            throw new UaException(0x80100000L);
        }
        DiagnosticsContext<HistoryUpdateDetails> diagnosticsContext = new DiagnosticsContext<HistoryUpdateDetails>();
        AddressSpace.HistoryUpdateContext historyUpdateContext = new AddressSpace.HistoryUpdateContext(this.server, session, diagnosticsContext, request.getRequestHeader().getAuditEntryId(), request.getRequestHeader().getTimeoutHint(), request.getRequestHeader().getAdditionalHeader());
        List<HistoryUpdateResult> results = this.server.getAddressSpaceManager().historyUpdate(historyUpdateContext, historyUpdateDetailsList);
        ResponseHeader header = DefaultAttributeServiceSet.createResponseHeader((UaRequestMessageType)request);
        DiagnosticInfo[] diagnosticInfos = diagnosticsContext.getDiagnosticInfos(historyUpdateDetailsList);
        return new HistoryUpdateResponse(header, (HistoryUpdateResult[])results.toArray(HistoryUpdateResult[]::new), diagnosticInfos);
    }
}

